/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.framestore.Registration;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.ClientAndFrame;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.server.framestore.background.WorkInfo;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheAbortComplete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCompleted;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRead;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheStartComplete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameCalculator {
    private static transient Logger log = Log.getLogger(FrameCalculator.class);
    public static long WAIT_FOR_OVERLOADED_CLIENT = 300L;
    public static long MAX_WORKINFO_QUEUE = 15000L;
    private FrameStore fs;
    private final Object kbLock;
    private ServerFrameStore server;
    private RemoteSession effectiveClient;
    FrameCalculatorThread innerThread;
    private Object requestLock = new Object();
    private SortedSet<WorkInfo> requests = new TreeSet<WorkInfo>();
    private Map<ClientAndFrame, WorkInfo> requestMap = new HashMap<ClientAndFrame, WorkInfo>();
    private ServerCacheStateMachine machine = null;
    private Map<RemoteSession, Registration> sessionMap;
    private static boolean disabled = false;
    private Set<RemoteSession> disabledSessions = new HashSet<RemoteSession>();
    private FrameCalculatorStatsImpl stats = new FrameCalculatorStatsImpl();
    private long startOfLockHeldTime;

    public FrameCalculator(FrameStore fs, ServerCacheStateMachine machine, Object kbLock, ServerFrameStore server, Map<RemoteSession, Registration> sessionMap) {
        this.fs = fs;
        this.machine = machine;
        this.kbLock = kbLock;
        this.server = server;
        this.sessionMap = sessionMap;
        this.innerThread = new FrameCalculatorThread();
        this.innerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStateMachine(ServerCacheStateMachine machine) {
        Object object = this.requestLock;
        synchronized (object) {
            this.machine = machine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork(WorkInfo wi) throws ServerSessionLost {
        Object object;
        Frame frame = wi.getFrame();
        this.effectiveClient = wi.getClient();
        ServerFrameStore.setCurrentSession(this.effectiveClient);
        if (log.isLoggable(Level.FINE)) {
            this.letOtherThreadsRun();
            object = this.kbLock;
            synchronized (object) {
                log.fine("Precalculating " + this.fs.getFrameName(frame) + "/" + frame.getFrameID());
            }
            this.afterKbLockHeld();
        }
        try {
            CacheResult<List> result;
            Sft sft;
            this.stats.startWork();
            this.letOtherThreadsRun();
            object = this.kbLock;
            synchronized (object) {
                if (this.server.inTransaction()) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("\tbut transaction in progress");
                    }
                    wi.setTargetFullCache(false);
                } else {
                    this.insertValueUpdate(frame, new CacheStartComplete<RemoteSession, Sft, List>());
                }
            }
            this.afterKbLockHeld();
            Set slots = null;
            List values = null;
            this.letOtherThreadsRun();
            Object object2 = this.kbLock;
            synchronized (object2) {
                this.checkAbilityToGenerateFullCache(wi);
                slots = this.fs.getOwnSlots(frame);
            }
            this.afterKbLockHeld();
            for (Object slot : slots) {
                this.letOtherThreadsRun();
                Object object3 = this.kbLock;
                synchronized (object3) {
                    this.checkAbilityToGenerateFullCache(wi);
                    sft = new Sft((Slot)slot, null, false);
                    if (slot.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES) && wi.skipDirectInstances()) {
                        CacheResult invalid = CacheResult.getInvalid();
                        this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, invalid));
                    } else {
                        values = this.fs.getDirectOwnSlotValues(frame, (Slot)slot);
                        if (values != null && !values.isEmpty()) {
                            result = new CacheResult<List>(values, true);
                            this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, result));
                        }
                    }
                    this.addFollowedExprs(frame, (Slot)slot, values);
                }
                this.afterKbLockHeld();
            }
            if (frame instanceof Cls) {
                Object slot;
                Cls cls = (Cls)frame;
                this.letOtherThreadsRun();
                slot = this.kbLock;
                synchronized (slot) {
                    this.checkAbilityToGenerateFullCache(wi);
                    slots = this.fs.getTemplateSlots(cls);
                }
                this.afterKbLockHeld();
                for (Slot slot2 : slots) {
                    Set<Facet> facets;
                    Object result2;
                    this.letOtherThreadsRun();
                    result = this.kbLock;
                    synchronized (result) {
                        this.checkAbilityToGenerateFullCache(wi);
                        sft = new Sft(slot2, null, true);
                        values = this.fs.getDirectTemplateSlotValues(cls, slot2);
                        if (values != null && !values.isEmpty()) {
                            result2 = new CacheResult<List>(values, true);
                            this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, (CacheResult<List>)result2));
                        }
                    }
                    this.afterKbLockHeld();
                    this.letOtherThreadsRun();
                    result2 = this.kbLock;
                    synchronized (result2) {
                        this.checkAbilityToGenerateFullCache(wi);
                        facets = this.fs.getTemplateFacets(cls, slot2);
                    }
                    this.afterKbLockHeld();
                    for (Facet facet : facets) {
                        this.letOtherThreadsRun();
                        Object object4 = this.kbLock;
                        synchronized (object4) {
                            this.checkAbilityToGenerateFullCache(wi);
                            sft = new Sft(slot2, facet, true);
                            values = this.fs.getDirectTemplateFacetValues(cls, slot2, facet);
                            if (values != null && !values.isEmpty()) {
                                CacheResult<List> result3 = new CacheResult<List>(values, true);
                                this.insertValueUpdate(frame, new CacheRead<RemoteSession, Sft, List>(this.effectiveClient, sft, result3));
                            }
                        }
                        this.afterKbLockHeld();
                    }
                }
            }
            this.letOtherThreadsRun();
            object2 = this.kbLock;
            synchronized (object2) {
                if (wi.isTargetFullCache() && !this.server.inTransaction()) {
                    this.insertValueUpdate(frame, new CacheCompleted<RemoteSession, Sft, List>());
                } else if (wi.isTargetFullCache()) {
                    this.insertValueUpdate(frame, new CacheAbortComplete<RemoteSession, Sft, List>());
                }
            }
            this.afterKbLockHeld();
        }
        catch (Throwable t) {
            Log.getLogger().log(Level.SEVERE, "Exception caught caching frame values", t);
            wi.setTargetFullCache(false);
            this.insertValueUpdate(frame, new CacheAbortComplete<RemoteSession, Sft, List>());
        }
        finally {
            this.stats.completeWork();
        }
    }

    private void checkAbilityToGenerateFullCache(WorkInfo wi) {
        if (this.server.inTransaction() && wi.isTargetFullCache()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Found transaction in progress - can't complete cache for frame " + wi.getFrame());
            }
            wi.setTargetFullCache(false);
            this.insertValueUpdate(wi.getFrame(), new CacheAbortComplete<RemoteSession, Sft, List>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFollowedExprs(Frame frame, Slot slot, List values) {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.machine == null) {
                return;
            }
            WorkInfo wi = this.requestMap.get(new ClientAndFrame(this.effectiveClient, frame));
            if (wi == null) {
                return;
            }
            for (ServerCachedState state : wi.getStates()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Following expr " + frame + " with slot " + slot + " in state " + state);
                }
                for (Object o : values) {
                    Frame inner;
                    ServerCachedState newState;
                    if (!(o instanceof Frame) || (newState = this.machine.nextState(state, frame, slot, inner = (Frame)o)) == null) continue;
                    WorkInfo iwi = this.addRequest(inner, this.effectiveClient, newState, CacheRequestReason.STATE_MACHINE, true);
                    if (iwi != null) {
                        iwi.setClient(wi.getClient());
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Added cache request frame for state transition " + frame + " x " + state + " -> " + inner + " x " + newState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, RemoteSession session, CacheRequestReason reason) {
        Object object = this.requestLock;
        synchronized (object) {
            return this.addRequest(frame, session, this.machine == null ? null : this.machine.getInitialState(), reason, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkInfo addRequest(Frame frame, RemoteSession session, ServerCachedState state, CacheRequestReason reason, boolean forceUpdate) {
        if (this.inFrameCalculatorThread() && !forceUpdate) {
            return null;
        }
        if (this.isDisabled(session)) {
            return null;
        }
        if (reason != CacheRequestReason.PRELOAD && reason != CacheRequestReason.IMMEDIATE_PRELOAD && this.sessionMap.get(session).getBandWidthPolicy().stopSending()) {
            return null;
        }
        if (frame.getKnowledgeBase() == null) {
            log.log(Level.WARNING, "Non-localized frame being added to the FrameCalculator", new Exception());
        }
        Object object = this.requestLock;
        synchronized (object) {
            ClientAndFrame cwf = new ClientAndFrame(session, frame);
            WorkInfo wi = this.requestMap.get(cwf);
            if (wi == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Added " + frame.getFrameID() + " in state " + state + " with reason " + (Object)((Object)reason) + " to head of frames to precalculate");
                }
                wi = new WorkInfo();
                wi.setClient(session);
                wi.setFrame(frame);
                this.requestMap.put(cwf, wi);
            } else {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Updating state for " + frame.getFrameID() + " to include " + state);
                }
                this.requests.remove(wi);
            }
            wi.addState(state);
            wi.addReason(reason);
            wi.setNewest();
            this.requests.add(wi);
            this.requestLock.notify();
            return wi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(WorkInfo wi) {
        Object object = this.requestLock;
        synchronized (object) {
            this.requests.remove(wi);
            this.requestMap.remove(new ClientAndFrame(wi.getClient(), wi.getFrame()));
        }
    }

    private void insertValueUpdate(Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> update) {
        Registration registration;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("For frame " + frame.getName() + " inserted value update " + update);
        }
        if ((registration = this.sessionMap.get(this.effectiveClient)) == null) {
            return;
        }
        registration.getBandWidthPolicy().addItemToWaitList();
        this.server.updateEvents(this.effectiveClient);
        this.server.addReadUpdate(this.effectiveClient, frame, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(RemoteSession session) {
        Object object = this.requestLock;
        synchronized (object) {
            ArrayList<WorkInfo> remove = new ArrayList<WorkInfo>();
            for (WorkInfo wi : this.requests) {
                if (!wi.getClient().equals(session)) continue;
                remove.add(wi);
            }
            for (WorkInfo wi : remove) {
                this.requests.remove(wi);
                this.requestMap.remove(wi.getClientAndFrame());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabled(RemoteSession session) {
        Object object = this.requestLock;
        synchronized (object) {
            return disabled || session == null || this.sessionMap.get(session) == null || this.disabledSessions.contains(session);
        }
    }

    public static void setDisabled(boolean disabled) {
        FrameCalculator.disabled = disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisabled(boolean disabled, RemoteSession session) {
        Object object = this.requestLock;
        synchronized (object) {
            boolean previousValue = this.disabledSessions.contains(session);
            if (disabled) {
                this.disabledSessions.add(session);
            } else {
                this.disabledSessions.remove(session);
            }
            return previousValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameCalculatorStats getStats() {
        HashMap<RemoteSession, Integer> backlogs = new HashMap<RemoteSession, Integer>();
        Object object = this.requestLock;
        synchronized (object) {
            for (WorkInfo wi : this.requests) {
                RemoteSession session = wi.getClient();
                Integer count = (Integer)backlogs.get(session);
                if (count == null) {
                    backlogs.put(session, 1);
                    continue;
                }
                backlogs.put(session, count + 1);
            }
        }
        this.stats.setPreCacheBackLog(backlogs);
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logRequests() {
        block19: {
            if (log.isLoggable(Level.FINE)) {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        TreeSet<WorkInfo> requestsCopy;
                        Object object = this.requestLock;
                        synchronized (object) {
                            requestsCopy = new TreeSet<WorkInfo>(this.requests);
                        }
                        log.fine("Request queue has size " + requestsCopy.size());
                        for (WorkInfo workInfo : requestsCopy) {
                            log.finer("Request for frame" + workInfo.getFrame());
                            log.finer("\tClient = " + workInfo.getClient());
                            log.finer("\tStates = " + workInfo.getStates());
                            log.finer("\tReasons = " + workInfo.getReasons());
                        }
                        break block19;
                    }
                    EnumMap<CacheRequestReason, Integer> reasonCounts = new EnumMap<CacheRequestReason, Integer>(CacheRequestReason.class);
                    HashMap<ServerCachedState, Integer> stateCounts = new HashMap<ServerCachedState, Integer>();
                    for (CacheRequestReason reason : CacheRequestReason.values()) {
                        reasonCounts.put(reason, 0);
                    }
                    Object object = this.requestLock;
                    synchronized (object) {
                        log.fine("Request queue has size " + this.requests.size());
                        for (WorkInfo wi : this.requests) {
                            for (ServerCachedState state : wi.getStates()) {
                                Integer counts = (Integer)stateCounts.get(state);
                                if (counts == null) {
                                    counts = 0;
                                }
                                stateCounts.put(state, counts + 1);
                            }
                        }
                        for (WorkInfo wi : this.requests) {
                            for (CacheRequestReason reason : wi.getReasons()) {
                                reasonCounts.put(reason, (Integer)reasonCounts.get((Object)reason) + 1);
                            }
                        }
                    }
                    for (ServerCachedState state : stateCounts.keySet()) {
                        if (stateCounts.get(state) == null) continue;
                        log.fine("\tCount for state " + state + " = " + stateCounts.get(state));
                    }
                    for (CacheRequestReason reason : CacheRequestReason.values()) {
                        if ((Integer)reasonCounts.get((Object)reason) == 0) continue;
                        log.fine("\tCount for reason " + (Object)((Object)reason) + " = " + reasonCounts.get((Object)reason));
                    }
                }
                catch (Throwable t) {
                    log.log(Level.FINE, "Could not log requests", t);
                }
            }
        }
    }

    public Object getRequestLock() {
        return this.requestLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inFrameCalculatorThread() {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.innerThread == null) {
                return false;
            }
            return Thread.currentThread().equals(this.innerThread);
        }
    }

    private void letOtherThreadsRun() {
        if (log.isLoggable(Level.FINE)) {
            this.startOfLockHeldTime = System.currentTimeMillis();
        }
        this.server.letOtherThreadsRun();
    }

    private void afterKbLockHeld() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Knowledge Base Lock held for " + (System.currentTimeMillis() - this.startOfLockHeldTime));
        }
    }

    private WorkInfo getWorkInfo() {
        Object object = this.requestLock;
        synchronized (object) {
            block5: while (true) {
                while (true) {
                    ArrayList<WorkInfo> toRemove = new ArrayList<WorkInfo>();
                    for (WorkInfo wi : this.requests) {
                        if (wi.expired()) {
                            toRemove.add(wi);
                            continue;
                        }
                        if (!wi.getReasons().contains((Object)CacheRequestReason.PRELOAD) && !wi.getReasons().contains((Object)CacheRequestReason.IMMEDIATE_PRELOAD) && this.sessionMap.get(wi.getClient()).getBandWidthPolicy().stopSending()) continue;
                        return wi;
                    }
                    for (WorkInfo removeMe : toRemove) {
                        this.removeRequest(removeMe);
                    }
                    try {
                        if (this.requests.isEmpty()) {
                            this.requestLock.wait();
                            continue block5;
                        }
                        this.requestLock.wait(WAIT_FOR_OVERLOADED_CLIENT);
                        continue block5;
                    }
                    catch (InterruptedException ie) {
                        log.log(Level.WARNING, "Unexpected interrupt", ie);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public static FrameCalculator getFrameCalculator(KnowledgeBase kb) {
        ServerProject sp = Server.getInstance().getServerProject(kb.getProject());
        if (sp == null) {
            return null;
        }
        ServerFrameStore sfs = (ServerFrameStore)sp.getDomainKbFrameStore(null);
        return sfs.getFrameCalculator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FrameCalculatorStatsImpl
    implements FrameCalculatorStats,
    Serializable {
        private static final long serialVersionUID = -573113660316027300L;
        private long startWorkTime;
        private long workUnits = 0L;
        private long totalWorkTime = 0L;
        private Map<RemoteSession, Integer> preCacheBacklog;

        private void startWork() {
            this.startWorkTime = System.currentTimeMillis();
        }

        private void completeWork() {
            this.totalWorkTime = this.totalWorkTime + System.currentTimeMillis() - this.startWorkTime;
            ++this.workUnits;
        }

        @Override
        public Map<RemoteSession, Integer> getPreCacheBacklog() {
            return this.preCacheBacklog;
        }

        public void setPreCacheBackLog(Map<RemoteSession, Integer> backlog) {
            this.preCacheBacklog = backlog;
        }

        @Override
        public long getPrecalculateTime() {
            return this.workUnits == 0L ? 0L : this.totalWorkTime / this.workUnits;
        }
    }

    private class FrameCalculatorThread
    extends Thread {
        public FrameCalculatorThread() {
            super("Frame Pre-Calculation Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WorkInfo workInfo = FrameCalculator.this.getWorkInfo();
                        long startTime = System.currentTimeMillis();
                        FrameCalculator.this.doWork(workInfo);
                        Object object = FrameCalculator.this.requestLock;
                        synchronized (object) {
                            FrameCalculator.this.removeRequest(workInfo);
                        }
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.fine("work on frame " + workInfo.getFrame() + " took " + (System.currentTimeMillis() - startTime));
                        FrameCalculator.this.logRequests();
                    }
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.SEVERE, "Exception caught in background frame value evaluator", t);
                    continue;
                }
                break;
            }
        }
    }
}

