/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore.background;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.ClientAndFrame;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.util.ApplicationProperties;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkInfo
implements Comparable<WorkInfo> {
    public static final String WORK_INFO_TIMEOUT_PROPERTY = "edu.stanford.smi.protege.server.framecalculator.work.info.expiration";
    public static final int WORK_INFO_TIMEOUT = ApplicationProperties.getIntegerProperty("edu.stanford.smi.protege.server.framecalculator.work.info.expiration", 60000);
    private static int counter = 0;
    private RemoteSession client;
    private Frame frame;
    private final Set<ServerCachedState> states = new HashSet<ServerCachedState>();
    private final EnumSet<CacheRequestReason> reasons = EnumSet.noneOf(CacheRequestReason.class);
    private boolean skipDirectInstances = true;
    private boolean targetFullCache = true;
    private int sequence = counter++;
    private final long timeWorkInfoAdded = System.currentTimeMillis();

    public boolean expired() {
        return System.currentTimeMillis() - this.timeWorkInfoAdded > (long)WORK_INFO_TIMEOUT;
    }

    public RemoteSession getClient() {
        return this.client;
    }

    public void setClient(RemoteSession client) {
        this.client = client;
    }

    public void addState(ServerCachedState state) {
        this.states.add(state);
    }

    public Set<ServerCachedState> getStates() {
        return this.states;
    }

    public void addReason(CacheRequestReason reason) {
        this.reasons.add(reason);
    }

    public EnumSet<CacheRequestReason> getReasons() {
        return this.reasons;
    }

    public boolean skipDirectInstances() {
        return this.skipDirectInstances;
    }

    public void setSkipDirectInstances(boolean skipDirectInstances) {
        this.skipDirectInstances = skipDirectInstances;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setNewest() {
        this.sequence = counter++;
    }

    @Override
    public int compareTo(WorkInfo other) {
        int otherPriority;
        int myPriority = CacheRequestReason.priority(this.reasons);
        if (myPriority != (otherPriority = CacheRequestReason.priority(other.reasons))) {
            return otherPriority - myPriority;
        }
        return other.sequence - this.sequence;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public boolean isTargetFullCache() {
        return this.targetFullCache;
    }

    public void setTargetFullCache(boolean targetFullCache) {
        this.targetFullCache = targetFullCache;
    }

    public ClientAndFrame getClientAndFrame() {
        return new ClientAndFrame(this.client, this.frame);
    }
}

