/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObjectCollection;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.PropertyValue;
import edu.stanford.smi.protege.server.metaproject.ServerInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.GroupImpl;
import edu.stanford.smi.protege.server.metaproject.impl.GroupOperationImpl;
import edu.stanford.smi.protege.server.metaproject.impl.OperationImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyControlledObjectCollectionImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyControlledObjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyImpl;
import edu.stanford.smi.protege.server.metaproject.impl.ProjectInstanceImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PropertyValueImpl;
import edu.stanford.smi.protege.server.metaproject.impl.ServerInstanceImpl;
import edu.stanford.smi.protege.server.metaproject.impl.UserImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.util.Log;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaProjectImpl
implements MetaProject,
Localizable,
Serializable {
    private static final long serialVersionUID = -1014746777241732515L;
    private transient KnowledgeBase kb;
    private transient Policy policy;

    public MetaProjectImpl(URI metaProjectURI) {
        this(metaProjectURI, false);
    }

    public MetaProjectImpl(URI metaprojectURI, boolean isMultiUserServer) {
        ArrayList errors = new ArrayList();
        Project project = Project.loadProjectFromURI(metaprojectURI, errors, isMultiUserServer);
        if (!errors.isEmpty()) {
            throw new RuntimeException(errors.iterator().next().toString());
        }
        this.kb = project.getKnowledgeBase();
    }

    public MetaProjectImpl(Project p) {
        this.kb = p.getKnowledgeBase();
    }

    public Cls getCls(ClsEnum cls) throws OntologyException {
        Cls frameCls = this.kb.getCls(cls.toString());
        if (frameCls == null) {
            throw new OntologyException("Metaproject Ontology should contain a class " + (Object)((Object)cls));
        }
        return frameCls;
    }

    public Slot getSlot(SlotEnum slot) throws OntologyException {
        Slot frameSlot = this.kb.getSlot(slot.toString());
        if (frameSlot == null) {
            throw new OntologyException("Metaproject Ontology should contain a slot " + (Object)((Object)slot));
        }
        return frameSlot;
    }

    protected WrappedProtegeInstanceImpl wrapInstance(ClsEnum cls, Instance i) {
        if (!i.hasType(this.getCls(cls))) {
            throw new IllegalArgumentException("" + i + " should be a " + (Object)((Object)cls) + " instance");
        }
        switch (cls) {
            case GroupOperation: {
                return new GroupOperationImpl(this, i);
            }
            case Group: {
                return new GroupImpl(this, i);
            }
            case Project: {
                return new ProjectInstanceImpl(this, i);
            }
            case Operation: {
                return new OperationImpl(this, i);
            }
            case User: {
                return new UserImpl(this, i);
            }
            case Server: {
                return new ServerInstanceImpl(this, i);
            }
            case PolicyControlledObject: {
                return new PolicyControlledObjectImpl(this, i);
            }
            case PropertyValue: {
                return new PropertyValueImpl(this, i);
            }
            case PolicyControlledObjectCollection: {
                return new PolicyControlledObjectCollectionImpl(this, i);
            }
        }
        throw new UnsupportedOperationException("Unexpected cls " + (Object)((Object)cls));
    }

    protected Set getWrappedInstances(ClsEnum cls) {
        HashSet<WrappedProtegeInstanceImpl> instances = new HashSet<WrappedProtegeInstanceImpl>();
        for (Instance i : this.kb.getInstances(this.getCls(cls))) {
            instances.add(this.wrapInstance(cls, i));
        }
        return instances;
    }

    @Override
    public Set<ProjectInstance> getProjects() {
        return this.getWrappedInstances(ClsEnum.Project);
    }

    @Override
    public ProjectInstance getProject(String name) {
        Collection frames = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, name);
        if (frames == null || frames.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)frames.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new ProjectInstanceImpl(this, (Instance)frame);
    }

    @Override
    public Set<User> getUsers() {
        return this.getWrappedInstances(ClsEnum.User);
    }

    @Override
    public User getUser(String name) {
        Collection frames = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, name);
        if (frames == null || frames.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)frames.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new UserImpl(this, (Instance)frame);
    }

    @Override
    public Operation getOperation(String name) {
        Collection frames = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, name);
        if (frames == null || frames.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)frames.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new OperationImpl(this, (Instance)frame);
    }

    @Override
    public Set<Operation> getOperations() {
        return this.getWrappedInstances(ClsEnum.Operation);
    }

    @Override
    public Group getGroup(String name) {
        Collection frames = this.kb.getFramesWithValue(this.getSlot(SlotEnum.name), null, false, name);
        if (frames == null || frames.isEmpty()) {
            return null;
        }
        Frame frame = (Frame)frames.iterator().next();
        if (!(frame instanceof Frame)) {
            return null;
        }
        return new GroupImpl(this, (Instance)frame);
    }

    @Override
    public Set<Group> getGroups() {
        return this.getWrappedInstances(ClsEnum.Group);
    }

    @Override
    public Set<GroupOperation> getGroupOperations() {
        return this.getWrappedInstances(ClsEnum.GroupOperation);
    }

    @Override
    public Set<ServerInstance> getServers() {
        return this.getWrappedInstances(ClsEnum.Server);
    }

    @Override
    public Policy getPolicy() {
        if (this.policy == null) {
            this.policy = new PolicyImpl(this);
        }
        return this.policy;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this.kb;
    }

    @Override
    public boolean save(Collection errors) {
        ArrayList saveErrors = new ArrayList();
        try {
            this.kb.getProject().save(saveErrors);
            if (saveErrors.size() > 0) {
                Log.getLogger().warning("Server: Errors at saving metaproject. Error messages: " + saveErrors);
                errors.addAll(saveErrors);
                return false;
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Server: Errors at saving metaproject. Error message: " + e.getMessage(), e);
            errors.add(e);
            return false;
        }
        if (Log.getLogger().isLoggable(Level.FINE)) {
            Log.getLogger().fine("SERVER: Saved metaproject.");
        }
        return true;
    }

    @Override
    public void dispose() {
        this.kb.getProject().dispose();
    }

    @Override
    public ProjectInstance createProject(String name) {
        Instance pi = this.kb.createInstance(name, this.getCls(ClsEnum.Project));
        ProjectInstanceImpl project = new ProjectInstanceImpl(this, pi);
        project.setName(name);
        return project;
    }

    @Override
    public User createUser(String name, String password) {
        Instance ui = this.kb.createInstance(null, this.getCls(ClsEnum.User));
        UserImpl userInstance = new UserImpl(this, ui);
        userInstance.setName(name);
        userInstance.setPassword(password);
        return userInstance;
    }

    @Override
    public Group createGroup(String name) {
        Instance pi = this.kb.createInstance(name, this.getCls(ClsEnum.Group));
        GroupImpl group = new GroupImpl(this, pi);
        group.setName(name);
        return group;
    }

    @Override
    public Operation createOperation(String name) {
        Instance pi = this.kb.createInstance(name, this.getCls(ClsEnum.Operation));
        OperationImpl op = new OperationImpl(this, pi);
        op.setName(name);
        return op;
    }

    @Override
    public GroupOperation createGroupOperation() {
        Instance pi = this.kb.createInstance(null, this.getCls(ClsEnum.GroupOperation));
        GroupOperationImpl groupOp = new GroupOperationImpl(this, pi);
        return groupOp;
    }

    @Override
    public PropertyValue createPropertyValue() {
        Instance pi = this.kb.createInstance(null, this.getCls(ClsEnum.PropertyValue));
        PropertyValueImpl pv = new PropertyValueImpl(this, pi);
        return pv;
    }

    @Override
    public PropertyValue createPropertyValue(String propertyName, String propertyValue) {
        PropertyValue pv = this.createPropertyValue();
        pv.setPropertyName(propertyName);
        pv.setPropertyValue(propertyValue);
        return pv;
    }

    public PolicyControlledObjectCollection createCollection(String name) {
        Instance collInst = this.kb.createInstance(null, this.getCls(ClsEnum.PolicyControlledObjectCollection));
        PolicyControlledObjectCollectionImpl collection = new PolicyControlledObjectCollectionImpl(this, collInst);
        return collection;
    }

    @Override
    public Collection<PropertyValue> getPropertyValues(String propertyName, String propertyValue) {
        Collection matchingFrames = this.kb.getFramesWithValue(this.getSlot(SlotEnum.propertyName), null, false, propertyName);
        ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
        Slot propValueSlot = this.getSlot(SlotEnum.propertyValue);
        Cls propValueCls = this.getCls(ClsEnum.PropertyValue);
        for (Frame matchingFrame : matchingFrames) {
            Object value;
            if (!((Instance)matchingFrame).hasType(propValueCls) || ((value = matchingFrame.getOwnSlotValue(propValueSlot)) != null || propertyValue != null) && (propertyValue == null || !propertyValue.equals(value))) continue;
            propertyValues.add(new PropertyValueImpl(this, (Instance)matchingFrame));
        }
        return propertyValues;
    }

    @Override
    public ServerInstance createServer(String name) {
        Instance pi = this.kb.createInstance(null, this.getCls(ClsEnum.Server));
        ServerInstanceImpl si = new ServerInstanceImpl(this, pi);
        si.setName(name);
        return si;
    }

    @Override
    public void localize(KnowledgeBase kb) {
        this.kb = kb;
        this.policy = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstanceEnum {
        Trash;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlotEnum {
        name,
        password,
        salt,
        location,
        email,
        lastLogin,
        lastAccess,
        group,
        member,
        allowedGroup,
        allowedOperation,
        policyModifiableByClient,
        inCollection,
        allowedGroupOperation,
        owner,
        description,
        annotationProject,
        hostName,
        properties,
        propertyName,
        propertyValue,
        server;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClsEnum {
        Project,
        User,
        Group,
        Operation,
        GroupOperation,
        PolicyControlledObject,
        Server,
        PropertyValue,
        PolicyControlledObjectCollection;

    }
}

