/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObject;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObjectCollection;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceWithPropsImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyControlledObjectImpl
extends WrappedProtegeInstanceWithPropsImpl
implements PolicyControlledObject,
Serializable {
    private static final long serialVersionUID = 881458997973667317L;
    private String name;

    protected PolicyControlledObjectImpl(MetaProjectImpl mp, Instance pi) {
        this(mp, pi, MetaProjectImpl.ClsEnum.PolicyControlledObject);
    }

    protected PolicyControlledObjectImpl(MetaProjectImpl mp, Instance pi, MetaProjectImpl.ClsEnum cls) {
        super(mp, pi, cls);
        this.name = (String)pi.getOwnSlotValue(mp.getSlot(MetaProjectImpl.SlotEnum.name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setSlotValue(MetaProjectImpl.SlotEnum.name, name);
    }

    @Override
    public String getDescription() {
        Object value = this.getProtegeInstance().getOwnSlotValue(((MetaProjectImpl)this.getMetaProject()).getSlot(MetaProjectImpl.SlotEnum.description));
        if (value == null) {
            return "";
        }
        if (!(value instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.description) + " slot should take on string values");
        }
        return (String)value;
    }

    @Override
    public void setDescription(String description) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.description, description);
    }

    @Override
    public boolean isPolicyModifiableByClient() {
        return (Boolean)this.getSlotValue(MetaProjectImpl.SlotEnum.policyModifiableByClient, null);
    }

    @Override
    public void setPolicyModifiableByClient(boolean modifiable) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.policyModifiableByClient, modifiable);
    }

    @Override
    public void setAllowedGroupOperations(Collection<GroupOperation> groupOperations) {
        Set<GroupOperation> oldGroupOperations = this.getAllowedGroupOperations();
        this.setSlotValuesAsProtegeInstances(MetaProjectImpl.SlotEnum.allowedGroupOperation, groupOperations);
        for (GroupOperation oldGroupOperation : oldGroupOperations) {
            Instance groupOperationInst = ((WrappedProtegeInstanceImpl)((Object)oldGroupOperation)).getProtegeInstance();
            if (!this.canDelete(groupOperationInst)) continue;
            groupOperationInst.delete();
        }
    }

    private boolean canDelete(Instance groupOperation) {
        Collection<Reference> references = groupOperation.getReferences();
        for (Reference ref : references) {
            if (!ref.getSlot().equals(((MetaProjectImpl)this.getMetaProject()).getSlot(MetaProjectImpl.SlotEnum.allowedGroupOperation))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addAllowedGroupOperations(GroupOperation groupOperation) {
        this.addSlotValue(MetaProjectImpl.SlotEnum.allowedGroupOperation, groupOperation);
    }

    @Override
    public Set<GroupOperation> getAllowedGroupOperations() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.allowedGroupOperation, MetaProjectImpl.ClsEnum.GroupOperation);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public Set<PolicyControlledObjectCollection> getInCollection() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.inCollection, MetaProjectImpl.ClsEnum.PolicyControlledObjectCollection);
    }

    @Override
    public void addInCollection(PolicyControlledObjectCollection collection) {
        this.addSlotValue(MetaProjectImpl.SlotEnum.inCollection, collection);
    }

    @Override
    public void removeInCollection(PolicyControlledObjectCollection collection) {
        this.removeSlotValue(MetaProjectImpl.SlotEnum.inCollection, collection);
    }

    @Override
    public void setInCollection(Set<PolicyControlledObjectCollection> collections) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.inCollection, collections);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PolicyControlledObject)) {
            return false;
        }
        PolicyControlledObject other = (PolicyControlledObject)o;
        return this.name.equals(other.getName());
    }

    @Override
    public int hashCode() {
        return this.name == null ? 41 : this.name.hashCode();
    }
}

