/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.GroupOperation;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.ServerInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyImpl
implements Policy,
Localizable,
Serializable {
    private static final long serialVersionUID = 2209527990426609790L;
    MetaProjectImpl mp;

    public PolicyImpl(MetaProjectImpl mp) {
        this.mp = mp;
    }

    @Override
    public boolean isOperationAuthorized(User user, Operation op, PolicyControlledObject project) {
        if (!this.getKnownOperations().contains(op)) {
            return true;
        }
        Set<Group> userGroups = user.getGroups();
        for (GroupOperation ga : project.getAllowedGroupOperations()) {
            if (!userGroups.contains(ga.getAllowedGroup()) || !ga.getAllowedOperations().contains(op)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Operation> getAllowedOperations(User user, ProjectInstance project) {
        HashSet<Operation> allowed = new HashSet<Operation>();
        if (project == null) {
            return allowed;
        }
        Set<Group> userGroups = user.getGroups();
        for (GroupOperation ga : project.getAllowedGroupOperations()) {
            if (!userGroups.contains(ga.getAllowedGroup())) continue;
            allowed.addAll(ga.getAllowedOperations());
        }
        return allowed;
    }

    @Override
    public Set<Operation> getKnownOperations() {
        return this.mp.getOperations();
    }

    @Override
    public User getUserByName(String userName) {
        if (userName == null) {
            return null;
        }
        for (User user : this.mp.getUsers()) {
            if (!userName.equals(user.getName())) continue;
            return user;
        }
        return null;
    }

    @Override
    public ProjectInstance getProjectInstanceByName(String projectName) {
        for (ProjectInstance projectInstance : this.mp.getProjects()) {
            if (!projectInstance.getName().equals(projectName)) continue;
            return projectInstance;
        }
        return null;
    }

    @Override
    public ServerInstance getServerInstanceByName(String serverName) {
        for (ServerInstance serverInstance : this.mp.getServers()) {
            if (!serverInstance.getName().equals(serverName)) continue;
            return serverInstance;
        }
        return null;
    }

    @Override
    public ServerInstance getFirstServerInstance() {
        return CollectionUtilities.getFirstItem(this.mp.getServers());
    }

    @Override
    public void localize(KnowledgeBase kb) {
        this.mp.localize(kb);
    }
}

