/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.PolicyControlledObjectImpl;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.io.File;
import java.io.Serializable;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInstanceImpl
extends PolicyControlledObjectImpl
implements ProjectInstance,
Serializable {
    private static final long serialVersionUID = 8666270295698053695L;
    String location;

    protected ProjectInstanceImpl(MetaProjectImpl mp, Instance pi) {
        super(mp, pi, MetaProjectImpl.ClsEnum.Project);
        if (pi != null) {
            this.location = (String)pi.getOwnSlotValue(mp.getSlot(MetaProjectImpl.SlotEnum.location));
        }
        ProjectInstanceImpl.localizeLocation(this.location);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private static String localizeLocation(String location) {
        if (location == null) {
            return null;
        }
        if (File.separatorChar != '\\') {
            location = location.replace('\\', File.separatorChar);
        }
        return location;
    }

    @Override
    public ProjectInstance getAnnotationProject() {
        return (ProjectInstance)this.getSlotValue(MetaProjectImpl.SlotEnum.annotationProject, MetaProjectImpl.ClsEnum.Project);
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
        this.setSlotValue(MetaProjectImpl.SlotEnum.location, location);
    }

    @Override
    public User getOwner() {
        return (User)this.getSlotValue(MetaProjectImpl.SlotEnum.owner, MetaProjectImpl.ClsEnum.User);
    }

    @Override
    public Set<User> getOwners() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.owner, MetaProjectImpl.ClsEnum.User);
    }

    @Override
    public void setAnnotationProject(ProjectInstance annotationProject) {
        Project prj = this.getProtegeInstance().getProject();
        Slot annotationProjectSlot = prj.getKnowledgeBase().getSlot(MetaProjectImpl.SlotEnum.annotationProject.name());
        if (annotationProjectSlot == null) {
            annotationProjectSlot = prj.getKnowledgeBase().createSlot(MetaProjectImpl.SlotEnum.annotationProject.name());
            annotationProjectSlot.setValueType(ValueType.INSTANCE);
            annotationProjectSlot.setAllowedClses(CollectionUtilities.createCollection(prj.getKnowledgeBase().getCls(MetaProjectImpl.ClsEnum.Project.name())));
        }
        this.setSlotValue(MetaProjectImpl.SlotEnum.annotationProject, annotationProject);
    }

    @Override
    public void setOwner(User owner) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.owner, owner);
    }

    @Override
    public void setOwners(Set<User> owners) {
        this.setSlotValuesAsProtegeInstances(MetaProjectImpl.SlotEnum.owner, owners);
    }
}

