/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.server.metaproject.Group;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceWithPropsImpl;
import edu.stanford.smi.protege.util.DigestAndSalt;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserImpl
extends WrappedProtegeInstanceWithPropsImpl
implements User,
Serializable {
    private static final long serialVersionUID = -4416984896523630762L;
    private static final Logger log = Log.getLogger(UserImpl.class);
    private String name;

    protected UserImpl(MetaProjectImpl mp, Instance ui) {
        super(mp, ui, MetaProjectImpl.ClsEnum.User);
        this.name = (String)ui.getOwnSlotValue(mp.getSlot(MetaProjectImpl.SlotEnum.name));
    }

    @Override
    public String getDescription() {
        Object value = this.getProtegeInstance().getOwnSlotValue(this.getMetaProject().getSlot(MetaProjectImpl.SlotEnum.description));
        if (!(value instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.name) + " slot should take on string values");
        }
        return (String)value;
    }

    @Override
    public Set<Group> getGroups() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.group, MetaProjectImpl.ClsEnum.Group);
    }

    @Override
    public Date getLastAccess() {
        Object unparsed = this.getSlotValue(MetaProjectImpl.SlotEnum.lastAccess, null);
        if (unparsed != null && !(unparsed instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.lastAccess) + " slot should take on string values");
        }
        return UserImpl.parseDate((String)unparsed);
    }

    @Override
    public Date getLastLogin() {
        Object unparsed = this.getSlotValue(MetaProjectImpl.SlotEnum.lastLogin, null);
        if (unparsed != null && !(unparsed instanceof String)) {
            throw new OntologyException("The " + (Object)((Object)MetaProjectImpl.SlotEnum.lastLogin) + " slot should take on string values");
        }
        return UserImpl.parseDate((String)unparsed);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.description, description);
    }

    @Override
    public void setLastAccess(Date time) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.lastAccess, new Long(time.getTime()).toString());
    }

    @Override
    public void setLastLogin(Date time) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.lastLogin, new Long(time.getTime()).toString());
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setSlotValue(MetaProjectImpl.SlotEnum.name, name);
    }

    @Override
    public void setPassword(String password) {
        if (password == null) {
            password = "";
        }
        DigestAndSalt encrypted = StringUtilities.makeDigest(password);
        this.setSlotValue(MetaProjectImpl.SlotEnum.salt, encrypted.getSalt());
        this.setSlotValue(MetaProjectImpl.SlotEnum.password, encrypted.getDigest());
    }

    @Override
    public boolean verifyPassword(String password) {
        if (password == null) {
            password = "";
        }
        DigestAndSalt encodedPassword = StringUtilities.makeDigest(password, (String)this.getSlotValue(MetaProjectImpl.SlotEnum.salt, null));
        return encodedPassword.getDigest().equals(this.getSlotValue(MetaProjectImpl.SlotEnum.password, null));
    }

    @Override
    public String getEmail() {
        return (String)this.getSlotValue(MetaProjectImpl.SlotEnum.email, null);
    }

    @Override
    public void setEmail(String email) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.email, email);
    }

    @Override
    public String getSalt() {
        return (String)this.getSlotValue(MetaProjectImpl.SlotEnum.salt, null);
    }

    @Override
    public String getDigestedPassword() {
        return (String)this.getSlotValue(MetaProjectImpl.SlotEnum.password, null);
    }

    @Override
    public void setDigestedPassword(String hashedPassword, String salt) {
        this.setSlotValue(MetaProjectImpl.SlotEnum.password, hashedPassword);
        this.setSlotValue(MetaProjectImpl.SlotEnum.salt, salt);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return this.name.equals(other.getName());
    }

    @Override
    public int hashCode() {
        return this.name == null ? 42 : this.name.hashCode();
    }

    @Override
    public String toString() {
        return this.name;
    }

    private static Date parseDate(String dateAsLong) {
        if (dateAsLong == null) {
            return null;
        }
        try {
            return new Date(Long.parseLong(dateAsLong));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

