/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.util.LocalizeUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class WrappedProtegeInstanceImpl
implements Localizable,
Serializable {
    private static final long serialVersionUID = -1976680694911360227L;
    MetaProjectImpl mp;
    private Instance i;
    private MetaProjectImpl.ClsEnum cls;

    public WrappedProtegeInstanceImpl(MetaProjectImpl mp, Instance i, MetaProjectImpl.ClsEnum cls) {
        if (!i.hasType(mp.getCls(cls))) {
            throw new IllegalArgumentException("" + i + " should be of type " + (Object)((Object)cls));
        }
        this.i = i;
        this.cls = cls;
        this.mp = mp;
    }

    public MetaProjectImpl getMetaProject() {
        return this.mp;
    }

    public Instance getProtegeInstance() {
        return this.i;
    }

    public MetaProjectImpl.ClsEnum getCls() {
        return this.cls;
    }

    protected Set getSlotValues(MetaProjectImpl.SlotEnum slot, MetaProjectImpl.ClsEnum rangeCls) {
        HashSet<WrappedProtegeInstanceImpl> results = new HashSet<WrappedProtegeInstanceImpl>();
        for (Object o : this.i.getOwnSlotValues(this.mp.getSlot(slot))) {
            if (!(o instanceof Instance)) continue;
            results.add(this.mp.wrapInstance(rangeCls, (Instance)o));
        }
        return results;
    }

    protected Object getSlotValue(MetaProjectImpl.SlotEnum slot, MetaProjectImpl.ClsEnum rangeCls) {
        Object o = this.i.getOwnSlotValue(this.mp.getSlot(slot));
        if (o != null && o instanceof Instance) {
            return this.mp.wrapInstance(rangeCls, (Instance)o);
        }
        return o;
    }

    protected void setSlotValuesAsProtegeInstances(MetaProjectImpl.SlotEnum slot, Collection valueCollection) {
        Slot protege_slot = this.mp.getSlot(slot);
        this.i.setDirectOwnSlotValues(protege_slot, this.getProtegeCollection(valueCollection));
    }

    protected void setSlotValue(MetaProjectImpl.SlotEnum slot, Object value) {
        Slot protege_slot = this.mp.getSlot(slot);
        if (value instanceof WrappedProtegeInstanceImpl) {
            value = ((WrappedProtegeInstanceImpl)value).getProtegeInstance();
        }
        this.i.setDirectOwnSlotValue(protege_slot, value);
    }

    protected void addSlotValue(MetaProjectImpl.SlotEnum slot, Object value) {
        Slot protege_slot = this.mp.getSlot(slot);
        if (value instanceof WrappedProtegeInstanceImpl) {
            Instance protegeValue = ((WrappedProtegeInstanceImpl)value).getProtegeInstance();
            if (protegeValue == null) {
                throw new OntologyException("Failed to add for " + this.i.getName() + " slot " + protege_slot.getName() + " value: " + value + ". Probably " + value + " is not in the metaproject.");
            }
            this.i.addOwnSlotValue(protege_slot, protegeValue);
        } else {
            this.i.addOwnSlotValue(protege_slot, value);
        }
    }

    protected void removeSlotValue(MetaProjectImpl.SlotEnum slot, Object value) {
        Slot protege_slot = this.mp.getSlot(slot);
        if (value instanceof WrappedProtegeInstanceImpl) {
            Instance protegeValue = ((WrappedProtegeInstanceImpl)value).getProtegeInstance();
            if (protegeValue == null) {
                throw new OntologyException("Failed to remove for " + this.i.getName() + " slot " + protege_slot.getName() + " value: " + value + ". Probably " + value + " is not in the metaproject.");
            }
            this.i.removeOwnSlotValue(protege_slot, protegeValue);
        } else {
            this.i.removeOwnSlotValue(protege_slot, value);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof WrappedProtegeInstanceImpl)) {
            return false;
        }
        WrappedProtegeInstanceImpl other = (WrappedProtegeInstanceImpl)o;
        return this.mp == other.mp && this.getProtegeInstance().equals(other.getProtegeInstance());
    }

    public int hashCode() {
        return this.getProtegeInstance().hashCode();
    }

    public Collection getProtegeCollection(Collection collection) {
        ArrayList<Instance> protegeColl = new ArrayList<Instance>();
        for (Object o : collection) {
            if (o instanceof WrappedProtegeInstanceImpl) {
                WrappedProtegeInstanceImpl wpi = (WrappedProtegeInstanceImpl)o;
                protegeColl.add(wpi.getProtegeInstance());
                continue;
            }
            protegeColl.add((Instance)o);
        }
        return protegeColl;
    }

    public void localize(KnowledgeBase kb) {
        this.mp.localize(kb);
        LocalizeUtils.localize(this.i, kb);
    }

    public String toString() {
        return "[" + (Object)((Object)this.cls) + ": " + this.i.getName() + "]";
    }
}

