/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.metaproject.impl;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.server.metaproject.PropertyValue;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WrappedProtegeInstanceWithPropsImpl
extends WrappedProtegeInstanceImpl {
    private static final long serialVersionUID = -6687720331317552706L;

    public WrappedProtegeInstanceWithPropsImpl(MetaProjectImpl mp, Instance i, MetaProjectImpl.ClsEnum cls) {
        super(mp, i, cls);
    }

    public Set<PropertyValue> getPropertyValues() {
        return this.getSlotValues(MetaProjectImpl.SlotEnum.properties, MetaProjectImpl.ClsEnum.PropertyValue);
    }

    public void setPropertyValues(Collection<PropertyValue> propertyValues) {
        this.setSlotValuesAsProtegeInstances(MetaProjectImpl.SlotEnum.properties, propertyValues);
    }

    public void setPropertyValue(String propertyName, String propertyValue) {
        Set<PropertyValue> propertyValues = this.getPropertyValues();
        HashSet<PropertyValue> propertyValuesToSet = new HashSet<PropertyValue>();
        for (PropertyValue value : propertyValues) {
            if (value.getPropertyName().equals(propertyValue)) continue;
            propertyValuesToSet.add(value);
        }
        PropertyValue propValue = this.getMetaProject().createPropertyValue();
        propValue.setPropertyName(propertyName);
        propValue.setPropertyValue(propertyValue);
        propertyValuesToSet.add(propValue);
        this.setPropertyValues(propertyValuesToSet);
    }

    public void addPropertyValue(PropertyValue propertyValue) {
        this.addSlotValue(MetaProjectImpl.SlotEnum.properties, propertyValue);
    }

    public void addPropertyValue(String prop, String value) {
        PropertyValue pv = this.getMetaProject().createPropertyValue();
        pv.setPropertyName(prop);
        pv.setPropertyValue(value);
        this.addPropertyValue(pv);
    }

    public void removePropertyValue(PropertyValue propertyValue) {
        this.removeSlotValue(MetaProjectImpl.SlotEnum.properties, propertyValue);
    }

    public void removePropertyValue(String prop, String value) {
        Set<PropertyValue> propVals = this.getPropertyValues();
        for (PropertyValue propVal : propVals) {
            String propertyName = propVal.getPropertyName();
            String propertyValue = propVal.getPropertyValue();
            if ((prop != null || propertyName != null) && (prop == null || !prop.equals(propertyName)) || (value != null || propertyValue != null) && (value == null || !value.equals(propertyValue))) continue;
            ((WrappedProtegeInstanceImpl)((Object)propVal)).getProtegeInstance().delete();
        }
    }

    public Collection<String> getPropertyValuesAsString(String prop) {
        ArrayList<String> values = new ArrayList<String>();
        for (PropertyValue pv : this.getPropertyValues()) {
            if (!prop.equals(pv.getPropertyName())) continue;
            values.add(pv.getPropertyValue());
        }
        return values;
    }

    public String getPropertyValue(String prop) {
        for (PropertyValue pv : this.getPropertyValues()) {
            if (!prop.equals(pv.getPropertyName())) continue;
            return pv.getPropertyValue();
        }
        return null;
    }
}

