/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.narrowframestore;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.narrowframestore.RemoteServerNarrowFrameStore;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerNarrowFrameStore
extends UnicastRemoteObject
implements RemoteServerNarrowFrameStore {
    private static final long serialVersionUID = 1996943880174792714L;
    private static transient Logger log = Log.getLogger(ServerNarrowFrameStore.class);
    private final NarrowFrameStore delegate;
    private final NarrowFrameStore fixedDelegate;
    private final KnowledgeBase kb;

    public ServerNarrowFrameStore(NarrowFrameStore delegate, KnowledgeBase kb) throws RemoteException {
        super(SSLFactory.getServerPort(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS));
        this.delegate = delegate;
        this.kb = kb;
        this.fixedDelegate = (NarrowFrameStore)Proxy.newProxyInstance(kb.getClass().getClassLoader(), new Class[]{NarrowFrameStore.class}, (InvocationHandler)new ServerInvocationHandler());
    }

    private void localize(Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                LocalizeUtils.localize(o, this.kb);
            }
        }
    }

    @Override
    public String getName(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getName();
    }

    @Override
    public void setName(String name, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.setName(name);
    }

    @Override
    public NarrowFrameStore getDelegate(RemoteSession session) throws RemoteException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public int getFrameCount(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getFrameCount();
    }

    @Override
    public int getClsCount(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getClsCount();
    }

    @Override
    public int getSlotCount(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getSlotCount();
    }

    @Override
    public int getFacetCount(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getSimpleInstanceCount();
    }

    @Override
    public Set<Frame> getFrames(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getFrames();
    }

    @Override
    public Frame getFrame(FrameID id, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getFrame(id);
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getValues(frame, slot, facet, isTemplate);
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getValuesCount(frame, slot, facet, isTemplate);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.addValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.moveValue(frame, slot, facet, isTemplate, from, to);
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.removeValue(frame, slot, facet, isTemplate, value);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.setValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean isTemplate, Object value, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getFrames(slot, facet, isTemplate, value);
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getFramesWithAnyValue(slot, facet, isTemplate);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getMatchingFrames(slot, facet, isTemplate, value, maxMatches);
    }

    @Override
    public Set<Reference> getReferences(Object value, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getReferences(value);
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getMatchingReferences(value, maxMatches);
    }

    @Override
    public Collection<Frame> executeQuery(Query query, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        SynchronizeQueryCallback callback = new SynchronizeQueryCallback(this.kb);
        this.fixedDelegate.executeQuery(query, callback);
        return callback.waitForResults();
    }

    @Override
    public void deleteFrame(Frame frame, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.deleteFrame(frame);
    }

    @Override
    public void close(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.close();
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getClosure(frame, slot, facet, isTemplate);
    }

    @Override
    public void replaceFrame(Frame frame, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.replaceFrame(frame);
    }

    @Override
    public boolean beginTransaction(String name, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.beginTransaction(name);
    }

    @Override
    public boolean commitTransaction(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction(RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor(RemoteSession session) throws TransactionException, RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.getTransactionStatusMonitor();
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement, RemoteSession session) throws RemoteException {
        ServerFrameStore.recordCallNoCheck(session);
        this.fixedDelegate.replaceFrame(original, replacement);
    }

    @Override
    public boolean setCaching(RemoteSession sessionToChangeCaching, boolean doCache, RemoteSession session) {
        ServerFrameStore.recordCallNoCheck(session);
        return this.fixedDelegate.setCaching(sessionToChangeCaching, doCache);
    }

    private class ServerInvocationHandler
    implements InvocationHandler {
        private ServerInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            ClassLoader correctLoader;
            ClassLoader currentLoader;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Server invoking client requested method " + method + " on " + object.getClass());
                if (args != null) {
                    for (Object arg : args) {
                        log.fine("\tArgument = " + arg);
                    }
                } else {
                    log.fine("No args");
                }
            }
            if ((currentLoader = Thread.currentThread().getContextClassLoader()) != (correctLoader = ServerNarrowFrameStore.this.kb.getClass().getClassLoader())) {
                if (log.isLoggable(Level.FINE)) {
                    Log.getLogger().fine("Changing loader from " + currentLoader + " to " + correctLoader);
                }
                Thread.currentThread().setContextClassLoader(correctLoader);
            }
            ServerNarrowFrameStore.this.localize(args);
            try {
                KnowledgeBase i$ = ServerNarrowFrameStore.this.kb;
                synchronized (i$) {
                    return method.invoke((Object)ServerNarrowFrameStore.this.delegate, args);
                }
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

