/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.socket.SocketAspect;
import edu.stanford.smi.protege.server.socket.deflate.CompressingInputStream;
import edu.stanford.smi.protege.server.socket.deflate.CompressingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CompressionAspect
implements SocketAspect {
    private SocketAspect delegate;
    private InputStream is;
    private OutputStream os;

    public CompressionAspect(SocketAspect delegate) {
        this.delegate = delegate;
    }

    public SocketAspect getDelegate() {
        return this.delegate;
    }

    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            this.is = new CompressingInputStream(this.delegate.getInputStream());
        }
        return this.is;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.os == null) {
            this.os = new CompressingOutputStream(this.delegate.getOutputStream());
        }
        return this.os;
    }

    public void close() throws IOException {
        if (this.os != null) {
            this.os.flush();
            this.os.close();
        }
        if (this.is != null) {
            this.is.close();
        }
    }

    public static boolean useCompression() {
        return ServerProperties.useCompression();
    }
}

