/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringInputStream
extends InputStream {
    static Logger log = Log.getLogger(MonitoringInputStream.class);
    private static int KB = 1024;
    private static int counter = 0;
    private InputStream is;
    private int id;
    private int bytesRead = 0;
    private boolean readingNotified = false;

    public MonitoringInputStream(InputStream is) throws IOException {
        this.is = is;
        this.id = counter++;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.logPrefix() + " opened.");
        }
    }

    public int read() throws IOException {
        int ret = -1;
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "requesting byte");
            }
            ret = this.is.read();
            this.showRead(ret);
            if (ret != -1) {
                this.countRead(1);
            }
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = -1;
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "requesting " + len + " bytes");
            }
            ret = this.is.read(b, off, len);
            this.showRead(b, off, len, ret);
            if (ret > 0) {
                this.countRead(ret);
            }
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
        return ret;
    }

    public long skip(long n) throws IOException {
        long ret = -1L;
        try {
            ret = this.is.skip(n);
            if (ret > 0L) {
                this.countRead((int)ret);
            }
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
        return ret;
    }

    public void close() throws IOException {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "closing");
            }
            this.readingNotified = false;
            this.is.close();
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
    }

    private void showRead(byte[] b, int off, int len, int ret) {
        if (log.isLoggable(Level.FINER) && len != ret) {
            log.finer(this.logPrefix() + "asked for " + len + " bytes and received " + ret);
        }
        if (log.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer(this.logPrefix());
            sb.append("bytes read: ");
            for (int i = off; i < off + ret; ++i) {
                sb.append(b[i]);
                sb.append(" ");
            }
            log.finest(sb.toString());
        }
    }

    private void showRead(int b) {
        if (log.isLoggable(Level.FINE) && b < 0) {
            log.fine(this.logPrefix() + "End of Stream read");
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.logPrefix() + " byte read " + (byte)b + " : " + b);
        }
    }

    private synchronized void countRead(int n) {
        int newMB;
        if (log.isLoggable(Level.FINER) && !this.readingNotified) {
            log.finer(this.logPrefix() + "reading");
            this.readingNotified = true;
        }
        int previousMB = this.bytesRead / (KB * KB);
        this.bytesRead += n;
        if (log.isLoggable(Level.FINE) && (newMB = this.bytesRead / (KB * KB)) > previousMB) {
            log.fine(this.logPrefix() + newMB + " megabytes read");
        }
    }

    private String logPrefix() {
        return "InputStream " + this.id + ": ";
    }

    private void rethrow(Throwable t) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Exception caught", t);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        IOException ioe = new IOException(t.getMessage());
        ioe.initCause(t);
        throw ioe;
    }
}

