/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MonitoringOutputStream
extends OutputStream {
    static Logger log = Log.getLogger(MonitoringOutputStream.class);
    private static int KB = 1024;
    private static int counter = 0;
    private OutputStream os;
    private int id;
    private int bytesWritten = 0;
    private int bytesToBeFlushed = 0;
    private boolean writingNotified = false;

    public MonitoringOutputStream(OutputStream os) {
        this.os = os;
        this.id = counter++;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.logPrefix() + "opened.");
        }
    }

    public void write(int b) throws IOException {
        try {
            this.os.write(b);
            this.showByte(b);
            this.countWritten(1);
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.os.write(b, off, len);
            this.showBytes(b, off, len);
            this.countWritten(len);
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
    }

    public void flush() throws IOException {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "flushing " + this.bytesToBeFlushed + " bytes");
            }
            this.bytesToBeFlushed = 0;
            this.writingNotified = false;
            this.os.flush();
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
    }

    public void close() throws IOException {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this.logPrefix() + "closing");
            }
            this.writingNotified = false;
            this.os.close();
        }
        catch (Throwable t) {
            this.rethrow(t);
        }
    }

    private void showBytes(byte[] b, int off, int len) {
        if (log.isLoggable(Level.FINE) && len == 0) {
            log.fine(this.logPrefix() + "writing zero bytes");
        }
        if (log.isLoggable(Level.FINEST) && log.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer(this.logPrefix());
            sb.append("bytes written: ");
            for (int i = off; i < off + len; ++i) {
                sb.append(b[i]);
                sb.append(" ");
            }
            log.finest(sb.toString());
        }
    }

    private void showByte(int b) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.logPrefix() + "writing " + b);
        }
    }

    private synchronized void countWritten(int n) {
        int newMB;
        if (log.isLoggable(Level.FINER) && !this.writingNotified) {
            log.finer(this.logPrefix() + "writing");
            this.writingNotified = true;
        }
        int previousMB = this.bytesWritten / (KB * KB);
        this.bytesWritten += n;
        this.bytesToBeFlushed += n;
        if (log.isLoggable(Level.FINE) && (newMB = this.bytesWritten / (KB * KB)) > previousMB) {
            log.fine(this.logPrefix() + newMB + " megabytes written");
        }
    }

    private String logPrefix() {
        return "OutputStream " + this.id + ": ";
    }

    private void rethrow(Throwable t) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Exception caught", t);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        IOException ioe = new IOException(t.getMessage());
        ioe.initCause(t);
        throw ioe;
    }
}

