/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.socket.CompressionAspect;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.server.socket.SocketWithAspects;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class RmiSocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory,
Serializable {
    private static final long serialVersionUID = -2237049150168090129L;
    public static final String SERVER_PORT = "protege.rmi.server.port";
    public static final String SERVER_SSL_PORT = "protege.rmi.server.ssl.port";
    public static final String REGISTRY_PORT = "protege.rmi.registry.port";
    private boolean useSSL = false;
    private boolean useCompression = CompressionAspect.useCompression();
    private static boolean portsReported = false;

    public RmiSocketFactory(SSLFactory.Context context) {
        this.useSSL = SSLFactory.useSSL(context);
        this.reportPorts();
    }

    public Socket createSocket(String host, int port) throws IOException {
        InetSocketAddress serverAddress = new InetSocketAddress(host, port);
        InetSocketAddress localAddress = new InetSocketAddress(0);
        SocketWithAspects socket = new SocketWithAspects(this.useCompression);
        socket.setReuseAddress(true);
        socket.bind(localAddress);
        socket.connect(serverAddress);
        return socket;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port){

            public Socket accept() throws IOException {
                SocketWithAspects socket = new SocketWithAspects(RmiSocketFactory.this.useCompression);
                this.implAccept(socket);
                return socket;
            }
        };
    }

    public boolean equals(Object o) {
        if (!(o instanceof RmiSocketFactory)) {
            return false;
        }
        RmiSocketFactory other = (RmiSocketFactory)o;
        return this.useSSL == other.useSSL && this.useCompression == other.useCompression;
    }

    public int hashCode() {
        return (this.useSSL ? 1 : 0) + (this.useCompression ? 2 : 0);
    }

    private void reportPorts() {
        if (!portsReported) {
            int serverPort = RmiSocketFactory.getPort(SERVER_PORT, 0);
            int registryPort = RmiSocketFactory.getPort(REGISTRY_PORT, 1099);
            StringBuffer sb = new StringBuffer("Server port = ");
            sb.append(serverPort);
            sb.append(", registry port = ");
            sb.append(registryPort);
            if (this.useCompression) {
                sb.append(", compressed stream");
            }
            if (this.useSSL) {
                sb.append(", SSL");
            }
            Log.getLogger().config(sb.toString());
            portsReported = true;
        }
    }

    private static int getPort(String name, int defaultValue) {
        Integer i = Integer.getInteger(name);
        return i == null ? defaultValue : i;
    }
}

