/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SSLFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory {
    private static Logger log = Log.getLogger(SSLFactory.class);
    private static Set<Thread> authorized = new HashSet<Thread>();
    private static Context policy;
    public static final String SSL_POLICY = "protege.rmi.ssl.policy";
    public static final String SSL_KEYSTORE = "protege.rmi.ssl.keystore";
    public static final String SSL_PASSWORD = "protege.rmi.ssl.password";
    public static final String KEYSTORE_TYPE = "protege.rmi.ssl.keystore.type";
    public static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    public static final String KEYMANAGER_ALGORITHM = "protege.rmi.ssl.keymanager.algorithm";
    public static final String DEFAULT_KEYMANAGER_ALGORITHM = "SunX509";
    public static final String SSL_PROTOCOL = "protege.rmi.ssl.protocol";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    private SSLServerSocketFactory factory;

    private void initializeSSLServerFactory() throws IOException {
        if (this.factory != null) {
            return;
        }
        try {
            char[] passphrase = SSLFactory.getPassword().toCharArray();
            KeyStore ks = KeyStore.getInstance(SSLFactory.getKeystoreType());
            ks.load(new FileInputStream(SSLFactory.getKeyStore()), passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(SSLFactory.getKeymanagerAlgorithm());
            kmf.init(ks, passphrase);
            SSLContext ctx = SSLContext.getInstance(SSLFactory.getSSLProtocol());
            ctx.init(kmf.getKeyManagers(), null, null);
            this.factory = ctx.getServerSocketFactory();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Could not initialize ssl socket factory " + e);
            ioe.initCause(e);
            throw ioe;
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (this.factory == null) {
            this.initializeSSLServerFactory();
        }
        return this.factory.createServerSocket(port);
    }

    public Socket createSocket(String host, int port) throws IOException {
        InetSocketAddress serverAddress = new InetSocketAddress(host, port);
        InetSocketAddress localAddress = new InetSocketAddress(0);
        Socket socket = SSLSocketFactory.getDefault().createSocket();
        socket.setReuseAddress(true);
        socket.bind(localAddress);
        socket.connect(serverAddress);
        authorized.add(Thread.currentThread());
        return socket;
    }

    public static int getServerPort(Context context) {
        if (SSLFactory.useSSL(context)) {
            return Integer.getInteger("protege.rmi.server.ssl.port", 0);
        }
        return Integer.getInteger("protege.rmi.server.port", 0);
    }

    public static boolean useSSL(Context context) {
        boolean usessl;
        if (policy == null) {
            policy = Context.NONE;
            String when = ApplicationProperties.getApplicationOrSystemProperty(SSL_POLICY);
            if (when != null && (policy = (when = when.toUpperCase()).equals("NONE") ? Context.NONE : (when.equals("LOGIN") ? Context.LOGIN : Context.ALWAYS)) != Context.NONE) {
                Log.getLogger().config("SSL policy set to " + (Object)((Object)policy));
            }
        }
        boolean bl = usessl = context.compareTo(policy) <= 0;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Policy = " + (Object)((Object)policy) + " context = " + (Object)((Object)context) + " use ssl = " + usessl);
        }
        return usessl;
    }

    public static void resetAuth() {
        authorized.remove(Thread.currentThread());
    }

    public static boolean checkAuth() throws SecurityException {
        return authorized.contains(Thread.currentThread());
    }

    private static File getKeyStore() throws IOException {
        String keystore = ApplicationProperties.getApplicationOrSystemProperty(SSL_KEYSTORE);
        if (keystore == null) {
            throw new IOException("keystore not specified. Set protege.rmi.ssl.keystore");
        }
        return new File(keystore);
    }

    private static String getPassword() {
        return ApplicationProperties.getApplicationOrSystemProperty(SSL_PASSWORD);
    }

    private static String getKeystoreType() {
        return ApplicationProperties.getApplicationOrSystemProperty(KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
    }

    private static String getKeymanagerAlgorithm() {
        return ApplicationProperties.getApplicationOrSystemProperty(KEYMANAGER_ALGORITHM, DEFAULT_KEYMANAGER_ALGORITHM);
    }

    private static String getSSLProtocol() {
        return ApplicationProperties.getApplicationOrSystemProperty(SSL_PROTOCOL, DEFAULT_SSL_PROTOCOL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Context {
        NONE,
        LOGIN,
        ALWAYS;

    }
}

