/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.util.Log;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimulateDelayInputStream
extends FilterInputStream {
    static Logger log = Log.getLogger(SimulateDelayInputStream.class);
    private static int KB = 1024;
    private InputStream is;
    private static int bandwidth = ServerProperties.getKiloBytesPerSecondDownload();
    private int bytesRead = 0;

    public SimulateDelayInputStream(InputStream is) throws IOException {
        super(is);
        this.is = is;
    }

    public int read() throws IOException {
        int ret = this.is.read();
        if (ret != -1) {
            this.delayForUpload(1);
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.is.read(b, off, len);
        if (ret > 0) {
            this.delayForUpload(ret);
        }
        return ret;
    }

    public long skip(long n) throws IOException {
        long ret = super.skip(n);
        if (ret > 0L) {
            this.delayForUpload((int)ret);
        }
        return ret;
    }

    private synchronized void delayForUpload(int n) {
        int secondsDelay;
        this.bytesRead += n;
        if (bandwidth != 0 && (secondsDelay = this.bytesRead / (bandwidth * KB)) > 0) {
            this.bytesRead -= bandwidth * KB * secondsDelay;
            try {
                Thread.sleep(1000 * secondsDelay);
                log.info("Simulated " + secondsDelay + " seconds of upload delay");
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "Simulation of network delay failed", e);
            }
        }
    }
}

