/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.util.Log;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimulateDelayOutputStream
extends FilterOutputStream {
    static Logger log = Log.getLogger(SimulateDelayOutputStream.class);
    private static int KB = 1024;
    private OutputStream os;
    private int bandwidth = ServerProperties.getKiloBytesPerSecondUpload();
    private int bytesWritten = 0;

    public SimulateDelayOutputStream(OutputStream os) {
        super(os);
        this.os = os;
    }

    public void write(int b) throws IOException {
        this.os.write(b);
        this.delayForDownLoad(1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
        this.delayForDownLoad(len);
    }

    private synchronized void delayForDownLoad(int n) {
        int secondsDelay;
        this.bytesWritten += n;
        if (this.bandwidth != 0 && (secondsDelay = this.bytesWritten / (this.bandwidth * KB)) > 0) {
            this.bytesWritten -= secondsDelay * this.bandwidth * KB;
            try {
                Thread.sleep(1000 * secondsDelay);
                log.info("Simulated " + secondsDelay + " seconds of download delay");
            }
            catch (InterruptedException e) {
                log.log(Level.WARNING, "Simulation of network delay failed", e);
            }
        }
    }
}

