/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket;

import edu.stanford.smi.protege.server.socket.CompressionAspect;
import edu.stanford.smi.protege.server.socket.MonitoringAspect;
import edu.stanford.smi.protege.server.socket.SimulateDelayAspect;
import edu.stanford.smi.protege.server.socket.SocketAspect;
import edu.stanford.smi.protege.server.socket.TeeAspect;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Logger;

public class SocketWithAspects
extends Socket {
    static Logger log = Log.getLogger(SocketWithAspects.class);
    private SocketAspect myAspects = new SocketAspect(){

        public SocketAspect getDelegate() {
            return null;
        }

        public InputStream getInputStream() throws IOException {
            return SocketWithAspects.this.defaultGetInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            return SocketWithAspects.this.defaultGetOutputStream();
        }

        public void close() throws IOException {
            SocketWithAspects.this.defaultClose();
        }
    };

    public SocketWithAspects(boolean useCompression) {
        if (SimulateDelayAspect.useSimulatedDelay()) {
            this.myAspects = new SimulateDelayAspect(this.myAspects);
        }
        if (useCompression) {
            this.myAspects = new CompressionAspect(this.myAspects);
        }
        if (MonitoringAspect.useMonitoring()) {
            this.myAspects = new MonitoringAspect(this.myAspects);
        }
        if (TeeAspect.doTeeOuput()) {
            this.myAspects = new TeeAspect(this.myAspects);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.myAspects.getInputStream();
    }

    private InputStream defaultGetInputStream() throws IOException {
        return super.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.myAspects.getOutputStream();
    }

    private OutputStream defaultGetOutputStream() throws IOException {
        return super.getOutputStream();
    }

    public void close() throws IOException {
        this.myAspects.close();
    }

    private void defaultClose() throws IOException {
        super.close();
    }
}

