/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket.deflate;

import edu.stanford.smi.protege.server.socket.deflate.PacketHeader;
import edu.stanford.smi.protege.util.Log;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CompressingInputStream
extends InputStream {
    private static Logger log = Log.getLogger(CompressingInputStream.class);
    protected InputStream is;
    protected byte[] buffer;
    protected int offset;
    private Inflater inflater;
    private static int counter = 0;
    private int id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressingInputStream(InputStream is) {
        this.is = is;
        this.inflater = new Inflater();
        Class<CompressingInputStream> clazz = CompressingInputStream.class;
        synchronized (CompressingInputStream.class) {
            this.id = counter++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            this.fillBuffer();
        }
        if (this.buffer == null) {
            return -1;
        }
        byte ret = this.buffer[this.offset++];
        if (this.buffer.length == this.offset) {
            this.buffer = null;
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            this.fillBuffer();
        }
        if (this.buffer == null) {
            return -1;
        }
        int bytesRead = 0;
        for (bytesRead = 0; this.offset < this.buffer.length && bytesRead < len; ++bytesRead) {
            b[off++] = this.buffer[this.offset++];
        }
        if (this.buffer.length == this.offset) {
            this.buffer = null;
        }
        return bytesRead;
    }

    private void fillBuffer() throws IOException {
        this.buffer = null;
        this.offset = 0;
        PacketHeader header = PacketHeader.read(this.is);
        this.buffer = new byte[header.getSize()];
        this.fillBuffer(header);
    }

    protected void fillBuffer(PacketHeader header) throws IOException {
        this.inflater.reset();
        int compressedSize = header.getCompressedSize();
        byte[] compressedBuffer = new byte[compressedSize];
        this.readFully(compressedBuffer, compressedSize);
        this.inflater.setInput(compressedBuffer);
        try {
            int inflatedSize = this.inflater.inflate(this.buffer);
            if (inflatedSize != header.getSize()) {
                throw new IOException("Inflated to the wrong size, expected " + header.getSize() + " bytes but got " + inflatedSize + " bytes");
            }
        }
        catch (DataFormatException dfe) {
            IOException ioe = new IOException("Compressed Data format bad: " + dfe.getMessage());
            ioe.initCause(dfe);
            throw ioe;
        }
        if (!this.inflater.needsInput()) {
            throw new IOException("Inflater thinks that there is more data to decompress");
        }
        this.logPacket(compressedBuffer);
    }

    protected void readFully(byte[] b, int len) throws IOException {
        int readThisTime;
        for (int bytesRead = 0; bytesRead < len; bytesRead += readThisTime) {
            readThisTime = this.is.read(b, bytesRead, len - bytesRead);
            if (readThisTime != -1) continue;
            throw new EOFException("Unabled to read entire compressed packet contents");
        }
    }

    protected void logPacket(byte[] compressedBuffer) {
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            int i;
            log.finest("----------------------------------------");
            log.finest("Incoming packet for reader " + this.id);
            StringBuffer sb = new StringBuffer();
            sb.append("Uncompressed buffer of size ");
            sb.append(this.buffer.length);
            sb.append(": ");
            for (i = 0; i < this.buffer.length; ++i) {
                sb.append(this.buffer[i]);
                sb.append(" ");
            }
            log.finest(sb.toString());
            sb = new StringBuffer();
            sb.append("Compressed buffer of size ");
            sb.append(compressedBuffer.length);
            sb.append(": ");
            for (i = 0; i < compressedBuffer.length; ++i) {
                sb.append(compressedBuffer[i]);
                sb.append(" ");
            }
            log.finest(sb.toString());
            log.finest("----------------------------------------");
        }
        catch (Throwable t) {
            log.finest("Could not log exitting packet");
        }
    }
}

