/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket.deflate;

import edu.stanford.smi.protege.server.socket.deflate.PacketHeader;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;

public class CompressingOutputStream
extends OutputStream {
    private static Logger log = Log.getLogger(CompressingOutputStream.class);
    public static int COMPRESSION_PAD = 1024;
    public static int BUFFER_SIZE = 131072;
    public static int KB = 1024;
    protected OutputStream os;
    private Deflater deflater;
    private static int counter = 0;
    private int id;
    protected byte[] buffer = new byte[BUFFER_SIZE];
    protected int offset = 0;
    private static int totalBytesWritten = 0;
    private static int totalCompressedBytesWritten = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompressingOutputStream(OutputStream os) {
        this.os = os;
        this.deflater = new Deflater();
        Class<CompressingOutputStream> clazz = CompressingOutputStream.class;
        synchronized (CompressingOutputStream.class) {
            this.id = counter++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void write(int b) throws IOException {
        this.ensureBufferNotFull();
        this.buffer[this.offset++] = (byte)b;
        this.ensureBufferNotFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            if (this.offset == 0) {
            } else {
                this.deflater.reset();
                this.deflater.setInput(this.buffer, 0, this.offset);
                this.deflater.finish();
                byte[] compressedBuffer = new byte[this.offset + COMPRESSION_PAD];
                this.deflater.deflate(compressedBuffer);
                if (!this.deflater.needsInput()) {
                    throw new IOException("Insufficient pad for compression");
                }
                int compressedSize = (int)this.deflater.getBytesWritten();
                PacketHeader header = new PacketHeader((int)this.deflater.getBytesRead(), compressedSize);
                this.logPacket(compressedBuffer, compressedSize);
                header.write(this.os);
                this.os.write(compressedBuffer, 0, compressedSize);
            }
        }
        finally {
            this.offset = 0;
        }
        this.os.flush();
    }

    private void ensureBufferNotFull() throws IOException {
        if (this.offset >= BUFFER_SIZE) {
            this.flush();
        }
    }

    protected void logPacket(byte[] compressedBuffer, int compressedSize) {
        this.logCompressionRatios(compressedSize);
        if (!log.isLoggable(Level.FINEST)) {
            return;
        }
        try {
            int i;
            log.finest("----------------------------------------");
            log.finest("Outgoing packet for writer " + this.id);
            StringBuffer sb = new StringBuffer();
            sb.append("Uncompressed buffer of size ");
            sb.append(this.offset);
            if (compressedSize > this.offset) {
                sb.append(" (compression increased size)");
            }
            sb.append(": ");
            for (i = 0; i < this.offset; ++i) {
                sb.append(this.buffer[i]);
                sb.append(" ");
            }
            log.finest(sb.toString());
            sb = new StringBuffer();
            sb.append("Compressed buffer of size ");
            sb.append(compressedSize);
            sb.append(": ");
            for (i = 0; i < compressedSize; ++i) {
                sb.append(compressedBuffer[i]);
                sb.append(" ");
            }
            log.finest(sb.toString());
            log.finest("----------------------------------------");
        }
        catch (Throwable t) {
            log.finest("Could not log exitting packet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCompressionRatios(int compressedSize) {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        Class<CompressingOutputStream> clazz = CompressingOutputStream.class;
        synchronized (CompressingOutputStream.class) {
            int previousMB = totalBytesWritten / (KB * KB);
            totalCompressedBytesWritten += compressedSize;
            if (previousMB < (totalBytesWritten += this.offset) / (KB * KB)) {
                log.fine(String.format("%d MBytes written: Compression ratio = %.3f to 1", totalBytesWritten / (KB * KB), (double)totalBytesWritten / (double)totalCompressedBytesWritten));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

