/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.socket.deflate;

import edu.stanford.smi.protege.util.Log;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PacketHeader {
    private static Logger log = Log.getLogger(PacketHeader.class);
    public static byte[] ALIGNMENT = new byte[]{76, 58, 116, 88};
    private static int BYTES_IN_INT = 4;
    private static int BITS_IN_BYTE = 8;
    private static int BYTE_MASK = 255;
    private int size;
    private int compressedSize;

    public PacketHeader(int size, int compressedSize) {
        this.size = size;
        this.compressedSize = compressedSize;
    }

    public static PacketHeader read(InputStream is) throws IOException {
        for (byte b : ALIGNMENT) {
            int alignCheck = is.read();
            if (alignCheck == -1) {
                throw new EOFException("No packet found");
            }
            if ((byte)alignCheck == b) continue;
            throw new IOException("Packet header out of alignment between reader and writer (Thread = " + Thread.currentThread().getName() + ")");
        }
        int size = PacketHeader.readInt(is);
        int compressedSize = PacketHeader.readInt(is);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Read compressed packet header, size = " + size + " compressed size = " + compressedSize);
        }
        return new PacketHeader(size, compressedSize);
    }

    public void write(OutputStream os) throws IOException {
        for (byte b : ALIGNMENT) {
            os.write(b);
        }
        PacketHeader.writeInt(os, this.size);
        PacketHeader.writeInt(os, this.compressedSize);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Wrote compressed packet header, size = " + this.size + " compressed size = " + this.compressedSize);
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    private static int readInt(InputStream is) throws IOException {
        int i;
        int result = 0;
        int[] buffer = new int[BYTES_IN_INT];
        for (i = 0; i < BYTES_IN_INT; ++i) {
            int c = is.read();
            if (c == -1) {
                throw new EOFException("Could not read compressed packet header");
            }
            buffer[i] = c;
        }
        for (i = BYTES_IN_INT - 1; i >= 0; --i) {
            result <<= BITS_IN_BYTE;
            int b = buffer[i];
            result += b < 0 ? 256 + b : b;
        }
        return result;
    }

    private static void writeInt(OutputStream os, int v) throws IOException {
        for (int i = 0; i < BYTES_IN_INT - 1; ++i) {
            os.write(v & BYTE_MASK);
            v >>= BITS_IN_BYTE;
        }
        os.write(v);
    }
}

