/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.update;

import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredOperationCache
implements Cache<RemoteSession, Sft, List> {
    private FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> transactionUpdates;
    private Cache<RemoteSession, Sft, List> delegate;

    public DeferredOperationCache(Cache<RemoteSession, Sft, List> delegate, FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> transactionUpdates) {
        this.delegate = delegate;
        this.transactionUpdates = transactionUpdates;
    }

    @Override
    public CacheResult<List> readCache(RemoteSession session, Sft var) {
        this.catchUp();
        return this.delegate.readCache(session, var);
    }

    @Override
    public void updateCache(RemoteSession session, Sft var) {
        this.catchUp();
        this.delegate.updateCache(session, var);
    }

    @Override
    public void updateCache(RemoteSession session, Sft var, List value) {
        this.catchUp();
        this.delegate.updateCache(session, var, value);
    }

    @Override
    public void modifyCache(RemoteSession session, Sft var) {
        this.catchUp();
        this.delegate.modifyCache(session, var);
    }

    @Override
    public void modifyCache(RemoteSession session, Sft var, List value) {
        this.catchUp();
        this.delegate.modifyCache(session, var, value);
    }

    @Override
    public void invalidate(RemoteSession session) {
        this.catchUp();
        this.delegate.invalidate(session);
    }

    @Override
    public boolean isInvalid() {
        this.catchUp();
        return this.delegate.isInvalid();
    }

    @Override
    public void flush() {
        while (this.transactionUpdates.read() != null) {
        }
        this.delegate.flush();
    }

    @Override
    public void startCompleteCache() {
        this.catchUp();
        this.delegate.startCompleteCache();
    }

    @Override
    public void finishCompleteCache() {
        this.catchUp();
        this.delegate.finishCompleteCache();
    }

    @Override
    public void abortCompleteCache() {
        this.catchUp();
        this.delegate.abortCompleteCache();
    }

    @Override
    public boolean isCacheComplete() {
        this.catchUp();
        return this.delegate.isCacheComplete();
    }

    @Override
    public void beginTransaction(RemoteSession session) {
        throw new UnsupportedOperationException("transactions are deferred");
    }

    @Override
    public void commitTransaction(RemoteSession session) {
        throw new UnsupportedOperationException("transactions are deferred");
    }

    @Override
    public void rollbackTransaction(RemoteSession session) {
        throw new UnsupportedOperationException("transactions are deferred");
    }

    @Override
    public int getTransactionNesting(RemoteSession session) {
        this.catchUp();
        return this.delegate.getTransactionNesting(session);
    }

    private void catchUp() {
        SerializedCacheUpdate<RemoteSession, Sft, List> update;
        while ((update = this.transactionUpdates.read()) != null) {
            update.performUpdate(this.delegate);
        }
    }

    @Override
    public int getCacheId() {
        return this.delegate.getCacheId();
    }
}

