/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.update;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRead;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueUpdate
implements Serializable,
Localizable {
    private static final long serialVersionUID = -7753881900765528485L;
    private Frame frame;
    private SerializedCacheUpdate<RemoteSession, Sft, List> update;

    public ValueUpdate(Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> update) {
        this.frame = frame;
        this.update = update;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public SerializedCacheUpdate<RemoteSession, Sft, List> getUpdate() {
        return this.update;
    }

    @Override
    public void localize(KnowledgeBase kb) {
        LocalizeUtils.localize(this.frame, kb);
        if (this.update instanceof CacheRead) {
            CacheRead read = (CacheRead)this.update;
            ((Sft)read.getVar()).localize(kb);
            LocalizeUtils.localize(read.getValue().getResult(), kb);
        } else if (this.update instanceof CacheModify) {
            CacheModify modify = (CacheModify)this.update;
            ((Sft)modify.getVar()).localize(kb);
            LocalizeUtils.localize(modify.getNewValue().getResult(), kb);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        sb.append(this.update);
        sb.append(" applied to ");
        if (this.frame != null) {
            sb.append(this.frame.getFrameID().getName());
            sb.append(" cache}");
        } else {
            sb.append("all frame caches");
        }
        return sb.toString();
    }
}

