/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.util;

import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.server.RemoteClientProject;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.ui.StatusBar;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteProjectUtil {
    private static transient Logger log = Log.getLogger(RemoteProjectUtil.class);
    private static Thread statusBarUpdateThread;
    private static final int DELAY_MSEC = 2000;

    public static void configure(ProjectView view) {
        StatusBar statusBar = new StatusBar();
        view.add((Component)statusBar, "South");
        RemoteProjectUtil.createUpdateThread((RemoteClientProject)view.getProject(), statusBar);
    }

    public static void dispose(ProjectView view) {
        statusBarUpdateThread = null;
    }

    private static void createUpdateThread(final RemoteClientProject project, final StatusBar bar) {
        statusBarUpdateThread = new Thread("Status Bar Updater"){

            public void run() {
                try {
                    while (statusBarUpdateThread == this) {
                        try {
                            1.sleep(2000L);
                            RemoteProjectUtil.updateStatus(project, bar);
                        }
                        catch (InterruptedException e) {
                            log.log(Level.INFO, "Exception caught", e);
                        }
                    }
                }
                catch (Throwable t) {
                    log.log(Level.INFO, "Exception caught", t);
                }
            }
        };
        statusBarUpdateThread.setDaemon(true);
        statusBarUpdateThread.start();
    }

    private static void updateStatus(RemoteClientProject project, StatusBar bar) {
        ArrayList users = new ArrayList(project.getCurrentUsers());
        users.remove(project.getLocalUser());
        String userText = StringUtilities.commaSeparatedList(users);
        String text = userText.length() == 0 ? "No other users" : "Other users: " + userText;
        bar.setText(text);
    }

    public static RemoteServer getRemoteServer(KnowledgeBase kb) {
        if (!kb.getProject().isMultiUserClient()) {
            return null;
        }
        FrameStoreManager framestore_manager = ((DefaultKnowledgeBase)kb).getFrameStoreManager();
        RemoteClientFrameStore remote_frame_store = framestore_manager.getFrameStoreFromClass(RemoteClientFrameStore.class);
        RemoteServer server = remote_frame_store.getRemoteServer();
        return server;
    }

    public static boolean isOperationAllowed(RemoteServer server, RemoteSession session, String projectName, Operation op) {
        try {
            return server.isOperationAllowed(session, op, projectName);
        }
        catch (RemoteException e) {
            Log.getLogger().log(Level.WARNING, "Could not figure out from server whether session: " + session + " is allowed to: " + op + " on remote project: " + projectName + ". Allowing the operation");
            return true;
        }
    }

    public static boolean isServerOperationAllowed(RemoteServer server, RemoteSession session, Operation op) {
        try {
            return server.isServerOperationAllowed(session, op);
        }
        catch (RemoteException e) {
            Log.getLogger().log(Level.WARNING, "Could not figure out from server whether session: " + session + " is allowed to: " + op);
            return true;
        }
    }
}

