/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.metaproject.impl.WrappedProtegeInstanceImpl;
import edu.stanford.smi.protege.util.ArchiveManager;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtil {
    private static final String SERVER_APPLIED_OPERATION_CLS = "ServerAppliedOperation";
    private static final String PROJECT_APPLIED_OPERATION_CLS = "ProjectAppliedOperation";
    private static final String GROUP_APPLIED_OPERATION_CLS = "GroupAppliedOperation";
    private static final String USER_COLLECTION_CLS = "UserCollection";
    private static final String GROUP_COLLECTION_CLS = "GroupCollection";
    private static final String PROJECT_COLLECTION_CLS = "ProjectCollection";

    public static void fixMetaProject(MetaProject metaproject) {
        block5: {
            if (!(metaproject instanceof MetaProjectImpl)) {
                return;
            }
            boolean changed = false;
            MetaProjectImpl mp = (MetaProjectImpl)metaproject;
            try {
                changed = ServerUtil.addPolicyControlledObjectClass(mp);
                changed = ServerUtil.addAccessSlots(mp) || changed;
                changed = ServerUtil.changeGroup(mp) || changed;
                changed = ServerUtil.addEmail(mp) || changed;
                changed = ServerUtil.addSalt(mp) || changed;
                changed = ServerUtil.addPropertyValues(mp) || changed;
                changed = ServerUtil.addPolicyStuff(mp) || changed;
                boolean bl = changed = ServerUtil.addCollections(mp) || changed;
                if (!changed) break block5;
                try {
                    ArchiveManager manager = ArchiveManager.getArchiveManager();
                    manager.archive(mp.getKnowledgeBase().getProject(), "Version before the update of the metaproject format from " + new Date());
                    Log.getLogger().info("Archived original metaproject to archive subfolder.");
                }
                catch (Exception e) {
                    Log.getLogger().log(Level.WARNING, "Failed at creating backup of metaproject", e);
                }
                ArrayList errors = new ArrayList();
                mp.save(errors);
                Log.getLogger().info("The metaproject was updated to a new version. Saved the updated metaproject on " + new Date());
                Log.handleErrors(Log.getLogger(), Level.WARNING, errors);
            }
            catch (Throwable t) {
                Log.getLogger().log(Level.WARNING, "Failed to fix up metaproject to new version.", t);
            }
        }
    }

    private static boolean addPropertyValues(MetaProjectImpl mp) {
        Cls userCls;
        Cls propertyValueCls;
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        changed = ServerUtil.addTemplateSlot(kb, propertyValueCls = ServerUtil.createCls(kb, MetaProjectImpl.ClsEnum.PropertyValue.name(), kb.getRootClses()), MetaProjectImpl.SlotEnum.propertyName) || changed;
        changed = ServerUtil.addTemplateSlot(kb, propertyValueCls, MetaProjectImpl.SlotEnum.propertyValue) || changed;
        Slot propertiesSlot = kb.getSlot(MetaProjectImpl.SlotEnum.properties.name());
        if (propertiesSlot == null) {
            propertiesSlot = kb.createSlot(MetaProjectImpl.SlotEnum.properties.name());
            propertiesSlot.setValueType(ValueType.INSTANCE);
            propertiesSlot.setAllowsMultipleValues(true);
            propertiesSlot.setAllowedClses(CollectionUtilities.createCollection(propertyValueCls));
            changed = true;
        }
        changed = ServerUtil.addTemplateSlot(kb, userCls = mp.getCls(MetaProjectImpl.ClsEnum.User), MetaProjectImpl.SlotEnum.properties) || changed;
        Cls policyCtrledObjCls = mp.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject);
        changed = ServerUtil.addTemplateSlot(kb, policyCtrledObjCls, MetaProjectImpl.SlotEnum.properties) || changed;
        Cls groupOpCls = mp.getCls(MetaProjectImpl.ClsEnum.GroupOperation);
        changed = ServerUtil.addTemplateSlot(kb, groupOpCls, MetaProjectImpl.SlotEnum.properties) || changed;
        Cls opCls = mp.getCls(MetaProjectImpl.ClsEnum.Operation);
        changed = ServerUtil.addTemplateSlot(kb, opCls, MetaProjectImpl.SlotEnum.properties) || changed;
        return changed;
    }

    private static boolean addEmail(MetaProjectImpl mp) {
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        Slot emailSlot = kb.getSlot(MetaProjectImpl.SlotEnum.email.name());
        if (emailSlot == null) {
            emailSlot = kb.createSlot(MetaProjectImpl.SlotEnum.email.name());
            Cls userCls = mp.getCls(MetaProjectImpl.ClsEnum.User);
            userCls.addDirectTemplateSlot(emailSlot);
            changed = true;
        }
        return changed;
    }

    private static boolean addSalt(MetaProjectImpl mp) {
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        Slot saltSlot = kb.getSlot(MetaProjectImpl.SlotEnum.salt.name());
        if (saltSlot == null) {
            saltSlot = kb.createSlot(MetaProjectImpl.SlotEnum.salt.name());
            Cls userCls = mp.getCls(MetaProjectImpl.ClsEnum.User);
            userCls.addDirectTemplateSlot(saltSlot);
            Slot passSlot = mp.getSlot(MetaProjectImpl.SlotEnum.password);
            for (User u : mp.getUsers()) {
                WrappedProtegeInstanceImpl ui = (WrappedProtegeInstanceImpl)((Object)u);
                String password = (String)ui.getProtegeInstance().getOwnSlotValue(passSlot);
                u.setPassword(password);
            }
            changed = true;
            Log.getLogger().info("\tEncoded all user passwords as part of the metaproject upgrade. Please adjust the User class forms to use the DigestedPassword slot widget for password field.");
        }
        return changed;
    }

    private static boolean addPolicyControlledObjectClass(MetaProjectImpl mp) {
        Cls serverCls;
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        Cls policyCtrledObjCls = kb.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name());
        if (policyCtrledObjCls == null) {
            Log.getLogger().info("Fixing up the metaproject to new version. No information will be lost.");
            policyCtrledObjCls = kb.createCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name(), kb.getRootClses());
            changed = true;
        }
        ServerUtil.addTemplateSlot(policyCtrledObjCls, mp.getSlot(MetaProjectImpl.SlotEnum.name));
        ServerUtil.addTemplateSlot(policyCtrledObjCls, mp.getSlot(MetaProjectImpl.SlotEnum.description));
        ServerUtil.addTemplateSlot(policyCtrledObjCls, mp.getSlot(MetaProjectImpl.SlotEnum.allowedGroupOperation));
        Slot hostNameSlot = kb.getSlot(MetaProjectImpl.SlotEnum.hostName.name());
        if (hostNameSlot == null) {
            hostNameSlot = kb.createSlot(MetaProjectImpl.SlotEnum.hostName.name());
            changed = true;
        }
        if ((serverCls = kb.getCls(MetaProjectImpl.ClsEnum.Server.name())) == null) {
            serverCls = kb.createCls(MetaProjectImpl.ClsEnum.Server.name(), CollectionUtilities.createCollection(policyCtrledObjCls));
            changed = true;
        }
        ServerUtil.addTemplateSlot(serverCls, hostNameSlot);
        Cls projectCls = mp.getCls(MetaProjectImpl.ClsEnum.Project);
        if (!projectCls.hasSuperclass(policyCtrledObjCls)) {
            projectCls.addDirectSuperclass(policyCtrledObjCls);
            projectCls.removeDirectSuperclass(kb.getRootCls());
            changed = true;
        }
        return changed;
    }

    private static boolean addAccessSlots(MetaProjectImpl mp) {
        Cls user;
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        changed = ServerUtil.addTemplateSlot(kb, user = kb.getCls(MetaProjectImpl.ClsEnum.User.toString()), MetaProjectImpl.SlotEnum.lastLogin) || changed;
        changed = ServerUtil.addTemplateSlot(kb, user, MetaProjectImpl.SlotEnum.lastAccess) || changed;
        return changed;
    }

    private static boolean changeGroup(MetaProjectImpl mp) {
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        Cls policyCtrledObjCls = kb.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name());
        Cls groupCls = kb.getCls(MetaProjectImpl.ClsEnum.Group.name());
        if (!groupCls.hasSuperclass(policyCtrledObjCls)) {
            groupCls.addDirectSuperclass(policyCtrledObjCls);
            groupCls.removeDirectSuperclass(kb.getRootCls());
            Cls operationCls = kb.getCls(MetaProjectImpl.ClsEnum.Operation.name());
            Collection<Cls> operationClsColl = CollectionUtilities.createCollection(operationCls);
            ServerUtil.createCls(kb, GROUP_APPLIED_OPERATION_CLS, operationClsColl);
            ServerUtil.createCls(kb, PROJECT_APPLIED_OPERATION_CLS, operationClsColl);
            ServerUtil.createCls(kb, SERVER_APPLIED_OPERATION_CLS, operationClsColl);
            changed = true;
        }
        return changed;
    }

    private static boolean addCollections(MetaProjectImpl mp) {
        Instance trashInst;
        Slot inCollectionSlot;
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        Cls policyControlledObjectCollection = kb.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObjectCollection.name());
        if (policyControlledObjectCollection == null) {
            policyControlledObjectCollection = ServerUtil.createCls(kb, MetaProjectImpl.ClsEnum.PolicyControlledObjectCollection.name(), kb.getRootClses());
            policyControlledObjectCollection.addDirectTemplateSlot(kb.getSlot(MetaProjectImpl.SlotEnum.name.name()));
            Collection<Cls> policyControlledObjectCollectionColl = CollectionUtilities.createCollection(policyControlledObjectCollection);
            ServerUtil.createCls(kb, PROJECT_COLLECTION_CLS, policyControlledObjectCollectionColl);
            ServerUtil.createCls(kb, GROUP_COLLECTION_CLS, policyControlledObjectCollectionColl);
            ServerUtil.createCls(kb, USER_COLLECTION_CLS, policyControlledObjectCollectionColl);
            changed = true;
        }
        if ((inCollectionSlot = kb.getSlot(MetaProjectImpl.SlotEnum.inCollection.name())) == null) {
            inCollectionSlot = kb.createSlot(MetaProjectImpl.SlotEnum.inCollection.name());
            inCollectionSlot.setValueType(ValueType.INSTANCE);
            inCollectionSlot.setAllowsMultipleValues(true);
            inCollectionSlot.setAllowedClses(CollectionUtilities.createCollection(policyControlledObjectCollection));
            kb.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name()).addDirectTemplateSlot(inCollectionSlot);
            changed = true;
        }
        if ((trashInst = kb.getInstance(MetaProjectImpl.InstanceEnum.Trash.name())) == null) {
            trashInst = kb.getCls(PROJECT_COLLECTION_CLS).createDirectInstance(MetaProjectImpl.InstanceEnum.Trash.name());
            trashInst.setOwnSlotValue(kb.getSlot(MetaProjectImpl.SlotEnum.name.name()), MetaProjectImpl.InstanceEnum.Trash.name());
            changed = true;
        }
        return changed;
    }

    private static boolean addPolicyStuff(MetaProjectImpl mp) {
        Slot ownerSlot;
        boolean changed = false;
        KnowledgeBase kb = mp.getKnowledgeBase();
        Slot policyModifiedByClientSlot = kb.getSlot(MetaProjectImpl.SlotEnum.policyModifiableByClient.name());
        if (policyModifiedByClientSlot == null) {
            policyModifiedByClientSlot = kb.createSlot(MetaProjectImpl.SlotEnum.policyModifiableByClient.name());
            policyModifiedByClientSlot.setValueType(ValueType.BOOLEAN);
            Cls policyControlledObjectCls = kb.getCls(MetaProjectImpl.ClsEnum.PolicyControlledObject.name());
            policyControlledObjectCls.addDirectTemplateSlot(policyModifiedByClientSlot);
            policyControlledObjectCls.setTemplateSlotDefaultValues(policyModifiedByClientSlot, CollectionUtilities.createCollection(true));
            changed = true;
        }
        if (!(ownerSlot = kb.getSlot(MetaProjectImpl.SlotEnum.owner.name())).getAllowsMultipleValues()) {
            ownerSlot.setAllowsMultipleValues(true);
            changed = true;
        }
        return changed;
    }

    private static boolean addTemplateSlot(KnowledgeBase kb, Cls cls, MetaProjectImpl.SlotEnum slotEnum) {
        String slotName = slotEnum.toString();
        boolean changed = false;
        Slot slot = kb.getSlot(slotName);
        if (slot == null) {
            slot = kb.createSlot(slotName);
            changed = true;
        }
        return ServerUtil.addTemplateSlot(cls, slot) || changed;
    }

    private static boolean addTemplateSlot(Cls cls, Slot slot) {
        if (!cls.hasTemplateSlot(slot)) {
            cls.addDirectTemplateSlot(slot);
            return true;
        }
        return false;
    }

    private static Cls createCls(KnowledgeBase kb, String name, Collection<Cls> parents) {
        Cls cls = kb.getCls(name);
        if (cls == null) {
            cls = kb.createCls(name, parents);
        }
        return cls;
    }

    private static Slot createSlot(KnowledgeBase kb, String name) {
        Slot slot = kb.getSlot(name);
        if (slot == null) {
            slot = kb.createSlot(name);
        }
        return slot;
    }
}

