/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.storage.clips.ClipsFilesExportProjectPlugin;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.Box;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClipsExportToNewFormatWizardPage
extends WizardPage {
    private static final long serialVersionUID = -5274698158929238115L;
    private FileField projectFileField;
    private JTextField clsesFileField;
    private JTextField instancesFileField;
    private ClipsFilesExportProjectPlugin plugin;

    public ClipsExportToNewFormatWizardPage(Wizard wizard, Project project, ClipsFilesExportProjectPlugin plugin) {
        super("clips export", wizard);
        this.plugin = plugin;
        this.createComponents(null);
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents(File projectPath) {
        this.projectFileField = new FileField("Project (.pprj) File", null, ".pprj", "Project File");
        this.clsesFileField = ComponentFactory.createTextField();
        this.clsesFileField.setEnabled(false);
        this.instancesFileField = ComponentFactory.createTextField();
        this.instancesFileField.setEnabled(false);
        this.projectFileField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                ClipsExportToNewFormatWizardPage.this.onProjectFieldChanged();
                ClipsExportToNewFormatWizardPage.this.updateSetPageComplete();
            }
        });
    }

    private void onProjectFieldChanged() {
        String name = this.getProjectFileName();
        ClipsExportToNewFormatWizardPage.replaceName(this.instancesFileField, ".pins", name);
        ClipsExportToNewFormatWizardPage.replaceName(this.clsesFileField, ".pont", name);
    }

    private static void replaceName(JTextField field, String extension, String baseName) {
        String name = FileUtilities.replaceExtension(baseName, extension);
        name = new File(name).getName();
        field.setText(name);
    }

    private void updateSetPageComplete() {
        this.setPageComplete(this.getProjectFileName() != null);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box panel = Box.createVerticalBox();
        panel.add(this.projectFileField);
        panel.add(new LabeledComponent("Classes (.pont) File", this.clsesFileField));
        panel.add(new LabeledComponent("Instances (.pins) File", this.instancesFileField));
        this.add((Component)panel, "North");
    }

    public void onFinish() {
        String projectName = this.getProjectFileName();
        String clsesFileName = this.clsesFileField.getText();
        String instancesFileName = this.instancesFileField.getText();
        this.plugin.setNewProjectPath(projectName);
        this.plugin.setFiles(clsesFileName, instancesFileName);
    }

    private String getProjectFileName() {
        return ClipsExportToNewFormatWizardPage.getPath(this.projectFileField, ".pprj");
    }

    private static String getPath(FileField field, String extension) {
        String path = field.getPath();
        return FileUtilities.ensureExtension(path, extension);
    }
}

