/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.storage.clips.ClipsFilesPlugin;
import edu.stanford.smi.protege.storage.clips.ClipsFilesWizardPage;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.WizardPage;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClipsFilesCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements ClipsFilesPlugin {
    private String clsesFileName;
    private String instancesFileName;
    private Collection<URI> includedProjects;

    public ClipsFilesCreateProjectPlugin() {
        super(ClipsKnowledgeBaseFactory.DESCRIPTION);
    }

    @Override
    public void setFiles(String clsesFileName, String instancesFileName) {
        this.clsesFileName = clsesFileName;
        this.instancesFileName = instancesFileName;
    }

    public void setIncludedProjects(Collection<URI> includedProjects) {
        this.includedProjects = new ArrayList<URI>(includedProjects);
    }

    @Override
    public boolean canCreateProject(KnowledgeBaseFactory factory, boolean useExistingSources) {
        return factory.getClass() == ClipsKnowledgeBaseFactory.class;
    }

    @Override
    protected void initialize(Project project) {
        super.initialize(project);
        if (this.includedProjects != null) {
            for (URI uri : this.includedProjects) {
                project.includeProject(uri, false, null);
            }
        }
    }

    @Override
    protected void initializeSources(PropertyList sources) {
        String className = FileUtilities.getName(this.clsesFileName);
        String instancesName = FileUtilities.getName(this.instancesFileName);
        ClipsKnowledgeBaseFactory.setSourceFiles(sources, className, instancesName);
    }

    @Override
    protected URI getBuildProjectURI() {
        String name = this.clsesFileName.substring(0, this.clsesFileName.length() - 5);
        name = name + ".pprj";
        File file = new File(name);
        return file.toURI();
    }

    @Override
    public WizardPage createCreateProjectWizardPage(CreateProjectWizard wizard, boolean useExistingSources) {
        ClipsFilesWizardPage page = null;
        if (useExistingSources) {
            page = new ClipsFilesWizardPage(wizard, this);
        }
        return page;
    }
}

