/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractBackendExportPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.storage.clips.ClipsExportToNewFormatWizardPage;
import edu.stanford.smi.protege.storage.clips.ClipsFilesPlugin;
import edu.stanford.smi.protege.storage.clips.ClipsFilesWizardPage;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.WizardPage;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class ClipsFilesExportProjectPlugin
extends AbstractBackendExportPlugin
implements ClipsFilesPlugin {
    private String clsesFileName;
    private String instancesFileName;

    public ClipsFilesExportProjectPlugin() {
        super(ClipsKnowledgeBaseFactory.DESCRIPTION);
    }

    public boolean canExport(Project project) {
        return true;
    }

    public boolean canExportToNewFormat(Project project) {
        return this.canExport(project);
    }

    public WizardPage createExportWizardPage(ExportWizard wizard, Project project) {
        return new ClipsFilesWizardPage(wizard, this);
    }

    public WizardPage createExportToNewFormatWizardPage(ExportWizard wizard, Project project) {
        return new ClipsExportToNewFormatWizardPage(wizard, project, this);
    }

    protected void overwriteDomainInformation(Project project, Collection errors) {
        KnowledgeBase kb = project.getKnowledgeBase();
        new ClipsKnowledgeBaseFactory().saveKnowledgeBase(kb, this.clsesFileName, this.instancesFileName, errors);
    }

    protected void initializeSources(Project project, Collection errors) {
        PropertyList sources = project.getSources();
        project.setKnowledgeBaseFactory(new ClipsKnowledgeBaseFactory());
        ClipsKnowledgeBaseFactory.setSourceFiles(sources, this.clsesFileName, this.instancesFileName);
    }

    public void setFiles(String clsesFileName, String instancesFileName) {
        this.clsesFileName = clsesFileName;
        this.instancesFileName = instancesFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportProject(Project project) {
        Writer clsesWriter = null;
        Writer instancesWriter = null;
        try {
            ArrayList errors = new ArrayList();
            KnowledgeBase kb = project.getKnowledgeBase();
            ClipsKnowledgeBaseFactory factory = new ClipsKnowledgeBaseFactory();
            clsesWriter = FileUtilities.getWriter(this.clsesFileName);
            instancesWriter = FileUtilities.getWriter(this.instancesFileName);
            factory.saveKnowledgeBase(kb, clsesWriter, instancesWriter, errors);
            this.handleErrors(errors);
        }
        catch (Throwable throwable) {
            FileUtilities.close(clsesWriter);
            FileUtilities.close(instancesWriter);
            throw throwable;
        }
        FileUtilities.close(clsesWriter);
        FileUtilities.close(instancesWriter);
    }
}

