/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.storage.clips.ClipsFilesCreateProjectPlugin;
import edu.stanford.smi.protege.storage.clips.ClipsFilesPlugin;
import edu.stanford.smi.protege.storage.clips.IncludedProjectsWizardPage;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClipsFilesWizardPage
extends WizardPage {
    private static final long serialVersionUID = -3081726266101640734L;
    private FileField clsesFileField;
    private FileField instancesFileField;
    private ClipsFilesPlugin plugin;

    public ClipsFilesWizardPage(Wizard wizard, ClipsFilesPlugin plugin) {
        super("clips files", wizard);
        this.plugin = plugin;
        this.createComponents();
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents() {
        this.clsesFileField = new FileField("Classes (.pont) File", null, ".pont", "Classes File");
        this.instancesFileField = new FileField("Instances (.pins) File", null, ".pins", "Instances File");
        this.clsesFileField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                ClipsFilesWizardPage.this.onClsFieldChanged();
                ClipsFilesWizardPage.this.updateSetPageComplete();
            }
        });
    }

    private void onClsFieldChanged() {
        String name = this.getClsesFileName();
        String instancesName = FileUtilities.replaceExtension(name, ".pins");
        this.instancesFileField.setPath(instancesName);
    }

    private void updateSetPageComplete() {
        this.setPageComplete(this.getClsesFileName() != null);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box panel = Box.createVerticalBox();
        panel.add(this.clsesFileField);
        panel.add(this.instancesFileField);
        this.add((Component)panel, "North");
    }

    public void onFinish() {
        String clsesFileName = this.getClsesFileName();
        String instancesFileName = this.getInstancesFileName();
        this.plugin.setFiles(clsesFileName, instancesFileName);
    }

    private String getClsesFileName() {
        return ClipsFilesWizardPage.getPath(this.clsesFileField, ".pont");
    }

    private String getInstancesFileName() {
        return ClipsFilesWizardPage.getPath(this.instancesFileField, ".pins");
    }

    private static String getPath(FileField field, String extension) {
        String path = field.getPath();
        return FileUtilities.ensureExtension(path, extension);
    }

    public WizardPage getNextPage() {
        WizardPage page;
        if (this.plugin instanceof ClipsFilesCreateProjectPlugin) {
            ClipsFilesCreateProjectPlugin createPlugin = (ClipsFilesCreateProjectPlugin)this.plugin;
            page = new IncludedProjectsWizardPage(this.getWizard(), createPlugin);
        } else {
            page = super.getNextPage();
        }
        return page;
    }
}

