/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ExportPlugin;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.storage.clips.ClipsFilePanel;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.WaitCursor;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClipsImportExportPlugin
implements ImportPlugin,
ExportPlugin {
    private static transient Logger log = Log.getLogger(ClipsImportExportPlugin.class);

    public String getName() {
        return "CLIPS";
    }

    public Project handleImportRequest() {
        Project project = Project.createNewProject(null, new ArrayList());
        ClipsImportExportPlugin.handleImportRequest(project);
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleImportRequest(Project project) {
        ClipsFilePanel panel = new ClipsFilePanel();
        String title = LocalizedText.getText(ResourceKey.CLIPS_FILES_TO_IMPORT_DIALOG_TITLE);
        int rval = ModalDialog.showDialog(null, panel, title, 11);
        if (rval == 1) {
            String classesFileName = panel.getClsesFileName();
            String instancesFileName = panel.getInstancesFileName();
            WaitCursor cursor = new WaitCursor(ProjectManager.getProjectManager().getMainPanel());
            try {
                ClipsImportExportPlugin.importProject(project, classesFileName, instancesFileName);
            }
            finally {
                cursor.hide();
            }
        }
    }

    private static void importProject(Project project, String clsesFileName, String instancesFileName) {
        ArrayList errors = new ArrayList();
        KnowledgeBase kb = project.getKnowledgeBase();
        ClipsKnowledgeBaseFactory factory = new ClipsKnowledgeBaseFactory();
        Reader clsesReader = FileUtilities.getReader(clsesFileName);
        Reader instancesReader = FileUtilities.getReader(instancesFileName);
        factory.loadKnowledgeBase(kb, clsesReader, instancesReader, false, errors);
        Log.handleErrors(Log.getLogger(ClipsImportExportPlugin.class), Level.WARNING, errors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExportRequest(Project project) {
        ClipsFilePanel panel = new ClipsFilePanel();
        String title = LocalizedText.getText(ResourceKey.CLIPS_FILES_TO_EXPORT_DIALOG_TITLE);
        int rval = ModalDialog.showDialog(null, panel, title, 11);
        if (rval == 1) {
            String classesFileName = panel.getClsesFileName();
            String instancesFileName = panel.getInstancesFileName();
            WaitCursor cursor = new WaitCursor(ProjectManager.getProjectManager().getMainPanel());
            try {
                ClipsImportExportPlugin.exportProject(project, classesFileName, instancesFileName);
            }
            finally {
                cursor.hide();
            }
        }
    }

    private static void exportProject(Project project, String clsesFileName, String instancesFileName) {
        ArrayList errors = new ArrayList();
        KnowledgeBase kb = project.getKnowledgeBase();
        ClipsKnowledgeBaseFactory factory = new ClipsKnowledgeBaseFactory();
        Writer clsesWriter = FileUtilities.getWriter(clsesFileName);
        Writer instancesWriter = FileUtilities.getWriter(instancesFileName);
        factory.saveKnowledgeBase(kb, clsesWriter, instancesWriter, errors);
        Log.handleErrors(log, Level.WARNING, errors);
    }

    public void dispose() {
    }
}

