/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.AbstractKnowledgeBaseFactory;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.clips.ClsStorer;
import edu.stanford.smi.protege.storage.clips.FileSourcesPanel;
import edu.stanford.smi.protege.storage.clips.InstanceStorer;
import edu.stanford.smi.protege.storage.clips.Parser;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;

public class ClipsKnowledgeBaseFactory
extends AbstractKnowledgeBaseFactory {
    public static final String DESCRIPTION = Text.getProgramName() + " Files (.pont and .pins)";
    private static final String CLSES_FILE_NAME = "classes_file_name";
    private static final String INSTANCES_FILE_NAME = "instances_file_name";

    public KnowledgeBase createKnowledgeBase(Collection errors) {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase(this);
        return kb;
    }

    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String project, PropertyList list) {
        return new FileSourcesPanel(project, list);
    }

    public static String getClsesSourceFile(PropertyList sources) {
        return sources.getString(CLSES_FILE_NAME);
    }

    public static URI getClsesSourceRelativeURI(PropertyList sources) {
        return URIUtilities.createURI(ClipsKnowledgeBaseFactory.getClsesSourceFile(sources));
    }

    public Reader getClsesSourceReader(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String name = ClipsKnowledgeBaseFactory.getClsesSourceFile(sources);
        return name == null ? null : this.createReader(kb, name, errors);
    }

    public Reader getInstancesSourceReader(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String name = ClipsKnowledgeBaseFactory.getInstancesSourceFile(sources);
        return name == null ? null : this.createReader(kb, name, errors);
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public static String getInstancesSourceFile(PropertyList sources) {
        return sources.getString(INSTANCES_FILE_NAME);
    }

    public static URI getInstancesSourceRelativeURI(PropertyList sources) {
        return URIUtilities.createURI(ClipsKnowledgeBaseFactory.getInstancesSourceFile(sources));
    }

    public boolean isComplete(PropertyList sources) {
        return true;
    }

    protected void loadKnowledgeBase(KnowledgeBase kb, PropertyList sources, boolean isInclude, Collection errors) {
        Reader clsesReader = this.getClsesSourceReader(kb, sources, errors);
        Reader instancesReader = this.getInstancesSourceReader(kb, sources, errors);
        this.loadKnowledgeBase(kb, clsesReader, instancesReader, isInclude, errors);
        this.close(clsesReader);
        this.close(instancesReader);
    }

    public void loadKnowledgeBase(KnowledgeBase kb, Reader clsesReader, Reader instancesReader, boolean isInclude, Collection errors) {
        Parser delegate;
        boolean cachingEnabled = kb.setCallCachingEnabled(false);
        boolean eventsEnabled = kb.setGenerateEventsEnabled(false);
        if (clsesReader != null) {
            delegate = new Parser(clsesReader);
            delegate.loadClses(kb, isInclude, errors);
        }
        if (instancesReader != null) {
            delegate = new Parser(instancesReader);
            delegate.loadInstances(kb, isInclude, errors);
        }
        kb.setGenerateEventsEnabled(eventsEnabled);
        kb.setCallCachingEnabled(cachingEnabled);
    }

    public void loadKnowledgeBase(KnowledgeBase kb, String clsesName, String instancesName, boolean isInclude, Collection errors) {
        BufferedReader clsesReader = this.createReader(kb, clsesName, errors);
        BufferedReader instancesReader = this.createReader(kb, instancesName, errors);
        this.loadKnowledgeBase(kb, clsesReader, instancesReader, isInclude, errors);
        FileUtilities.close(clsesReader);
        FileUtilities.close(instancesReader);
    }

    public KnowledgeBase loadKnowledgeBase(Reader clsesReader, Reader instancesReader, Collection errors) {
        KnowledgeBase kb = this.createKnowledgeBase(errors);
        this.loadKnowledgeBase(kb, clsesReader, instancesReader, false, errors);
        return kb;
    }

    public KnowledgeBase loadKnowledgeBase(String clsesFileName, String instancesFileName, Collection errors) {
        KnowledgeBase kb = this.createKnowledgeBase(errors);
        this.loadKnowledgeBase(kb, clsesFileName, instancesFileName, false, errors);
        return kb;
    }

    public void saveKnowledgeBase(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String instancesName;
        boolean changed = false;
        String projectBaseName = kb.getProject().getProjectName();
        String clsesName = ClipsKnowledgeBaseFactory.getClsesSourceFile(sources);
        if (clsesName == null) {
            clsesName = projectBaseName + ".pont";
            changed = true;
        }
        if ((instancesName = ClipsKnowledgeBaseFactory.getInstancesSourceFile(sources)) == null) {
            instancesName = projectBaseName + ".pins";
            changed = true;
        }
        if (changed) {
            ClipsKnowledgeBaseFactory.setSourceFiles(sources, clsesName, instancesName);
        }
        this.saveKnowledgeBase(kb, clsesName, instancesName, errors);
    }

    public void saveKnowledgeBase(KnowledgeBase kb, Writer clsesWriter, Writer instancesWriter, Collection errors) {
        if (clsesWriter != null) {
            ClsStorer clsStorer = new ClsStorer(clsesWriter);
            clsStorer.storeClses(kb, errors);
        }
        if (instancesWriter != null) {
            InstanceStorer instanceStorer = new InstanceStorer(instancesWriter);
            instanceStorer.storeInstances(kb, errors);
        }
    }

    public void saveKnowledgeBase(KnowledgeBase kb, String clsesFileName, String instancesFileName, Collection errors) {
        BufferedWriter pontWriter = null;
        BufferedWriter pinsWriter = null;
        try {
            File pontFile = this.createTempFile(kb, clsesFileName);
            File pinsFile = this.createTempFile(kb, instancesFileName);
            pontWriter = this.createWriter(pontFile);
            pinsWriter = this.createWriter(pinsFile);
            this.saveKnowledgeBase(kb, pontWriter, pinsWriter, errors);
            this.close(pontWriter);
            this.close(pinsWriter);
            if (errors.isEmpty()) {
                this.makeTempFilePermanent(pontFile);
                this.makeTempFilePermanent(pinsFile);
            }
        }
        catch (Exception e) {
            String message = "Error saving project. Classes file name: " + clsesFileName + ". Instances file name: " + instancesFileName;
            errors.add(new MessageError(e, message));
            Log.getLogger().log(Level.SEVERE, message, e);
            this.close(pontWriter);
            this.close(pinsWriter);
        }
    }

    public static void setSourceFiles(PropertyList sources, String clsesFileName, String instancesFileName) {
        ClipsKnowledgeBaseFactory.setProperty(sources, CLSES_FILE_NAME, clsesFileName);
        ClipsKnowledgeBaseFactory.setProperty(sources, INSTANCES_FILE_NAME, instancesFileName);
    }

    public static void setSourceURIs(PropertyList sources, URI relativeClsesURI, URI relativeInstancesURI) {
        Assert.assertTrue("Classes uri", relativeClsesURI == null || !relativeClsesURI.isAbsolute());
        Assert.assertTrue("Instances uri", relativeInstancesURI == null || !relativeInstancesURI.isAbsolute());
        ClipsKnowledgeBaseFactory.setSourceFiles(sources, ClipsKnowledgeBaseFactory.toString(relativeClsesURI), ClipsKnowledgeBaseFactory.toString(relativeInstancesURI));
    }

    private static String toString(URI uri) {
        return uri == null ? null : uri.toString();
    }

    private static void setProperty(PropertyList sources, String propertyName, String value) {
        sources.setString(propertyName, value);
    }
}

