/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ClipsUtil {
    public static final String TOP_LEVEL_SLOT_CLASS = ":CLIPS_TOP_LEVEL_SLOT_CLASS";
    public static final String FALSE = "FALSE";
    public static final String TRUE = "TRUE";
    private static char REAL_SPACE = (char)32;
    private static char FAKE_SPACE = (char)94;

    private static String replace(String s, char inchar, char outchar) {
        String newString;
        int index = s.indexOf(inchar);
        if (index == -1) {
            newString = s;
        } else {
            StringBuffer buffer = new StringBuffer(s);
            int i = index;
            while (i != -1) {
                buffer.setCharAt(i, outchar);
                i = s.indexOf(inchar, i + 1);
            }
            newString = buffer.toString();
        }
        return newString.intern();
    }

    public static String toExternalString(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"');
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\"': {
                    buffer.append("\\\"");
                    continue block6;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block6;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public static String toExternalSymbol(String s) {
        String symbol;
        try {
            symbol = URLEncoder.encode(s, FileUtilities.getWriteEncoding());
        }
        catch (UnsupportedEncodingException e) {
            symbol = s;
            Log.getLogger().warning(e.getMessage());
        }
        return symbol;
    }

    public static String toInternalString(String s) {
        String newString;
        if (s.charAt(0) == '\"') {
            int len = s.length();
            int bufferLen = 0;
            char[] buffer = new char[len];
            for (int i = 1; i < len - 1; ++i) {
                int c = s.charAt(i);
                if (c == 92) {
                    if ((c = s.charAt(++i)) == 110) {
                        c = 10;
                    } else if (c == 114) continue;
                }
                buffer[bufferLen] = c;
                ++bufferLen;
            }
            newString = new String(buffer, 0, bufferLen);
        } else {
            newString = s;
        }
        return newString.intern();
    }

    public static String toInternalSymbol(String s) {
        String result = ClipsUtil.replace(s, FAKE_SPACE, REAL_SPACE);
        try {
            result = URLDecoder.decode(result, FileUtilities.getReadEncoding()).intern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.intern();
    }
}

