/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.storage.clips.ClipsFileWriter;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClsStorer
extends ClipsFileWriter {
    private static Map _typeStrings = new HashMap();
    private Collection _storedClses = new HashSet();
    private KnowledgeBase _kb;
    private Collection _errors;

    public ClsStorer(Writer writer) {
        super(writer);
    }

    protected static boolean isStorable(Cls cls) {
        return cls == null || !cls.isSystem() && !cls.isIncluded();
    }

    private void storeAccessorFacet() {
        this.println();
        this.print("\t\t(create-accessor read-write)");
    }

    private static ValueType getTemplateSlotValueType(Cls cls, Slot slot) {
        return cls == null ? slot.getValueType() : cls.getTemplateSlotValueType(slot);
    }

    private static Collection getTemplateSlotAllowedClses(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowedClses() : cls.getTemplateSlotAllowedClses(slot);
    }

    private static Collection getTemplateSlotAllowedParents(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowedParents() : cls.getTemplateSlotAllowedParents(slot);
    }

    private static Collection getTemplateSlotAllowedValues(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowedValues() : cls.getTemplateSlotAllowedValues(slot);
    }

    private static Collection getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return cls == null ? Collections.EMPTY_LIST : cls.getDirectTemplateFacetValues(slot, facet);
    }

    private static Collection getTemplateFacets(Cls cls, Slot slot) {
        return cls == null ? Collections.EMPTY_LIST : cls.getTemplateFacets(slot);
    }

    private static boolean getTemplateSlotAllowsMultipleValues(Cls cls, Slot slot) {
        return cls == null ? slot.getAllowsMultipleValues() : cls.getTemplateSlotAllowsMultipleValues(slot);
    }

    private static Collection getTemplateSlotDefaultValues(Cls cls, Slot slot) {
        return cls == null ? slot.getDefaultValues() : cls.getTemplateSlotDefaultValues(slot);
    }

    private static Collection getTemplateSlotDocumentation(Cls cls, Slot slot) {
        return cls == null ? slot.getDocumentation() : cls.getTemplateSlotDocumentation(slot);
    }

    private static int getTemplateSlotMaximumCardinality(Cls cls, Slot slot) {
        return cls == null ? slot.getMaximumCardinality() : cls.getTemplateSlotMaximumCardinality(slot);
    }

    private static int getTemplateSlotMinimumCardinality(Cls cls, Slot slot) {
        return cls == null ? slot.getMinimumCardinality() : cls.getTemplateSlotMinimumCardinality(slot);
    }

    private static Number getTemplateSlotMaximumValue(Cls cls, Slot slot) {
        return cls == null ? (Number)slot.getMaximumValue() : (Number)cls.getTemplateSlotMaximumValue(slot);
    }

    private static Number getTemplateSlotMinimumValue(Cls cls, Slot slot) {
        return cls == null ? (Number)slot.getMinimumValue() : (Number)cls.getTemplateSlotMinimumValue(slot);
    }

    private static Collection getDirectSubclasses(Cls cls) {
        return cls == null ? Collections.EMPTY_LIST : cls.getDirectSubclasses();
    }

    private Collection<Cls> getDirectSuperclasses(Cls cls) {
        return cls == null ? this._kb.getRootClses() : cls.getDirectSuperclasses();
    }

    private static Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return cls == null ? slot.getValues() : cls.getTemplateSlotValues(slot);
    }

    private static boolean isAbstract(Cls cls) {
        return cls == null ? true : cls.isAbstract();
    }

    private static boolean hasDirectlyOverriddenTemplateFacet(Cls cls, Slot slot, Facet facet) {
        return cls == null ? false : cls.hasDirectlyOverriddenTemplateFacet(slot, facet);
    }

    private Cls getRootCls() {
        return this._kb.getRootCls();
    }

    private static String getComment(Cls cls) {
        return cls == null ? "Fake class to save top-level slot information" : (String)CollectionUtilities.getFirstItem(cls.getDocumentation());
    }

    private void storeAllowedClsesFacet(Cls cls, Slot slot) {
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (type == ValueType.INSTANCE) {
            Collection clses = ClsStorer.getTemplateSlotAllowedClses(cls, slot);
            this.storeCollectionFacet("allowed-classes", clses, true, ValueType.CLS, true);
        }
    }

    private void storeAllowedParentsFacet(Cls cls, Slot slot) {
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (type == ValueType.CLS) {
            Collection clses = ClsStorer.getTemplateSlotAllowedParents(cls, slot);
            this.storeCollectionFacet("allowed-parents", clses, true, type, true);
        }
    }

    private void storeAllowedValuesFacet(Cls cls, Slot slot) {
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        Collection<Boolean> values = null;
        if (type == ValueType.BOOLEAN) {
            values = new ArrayList<Boolean>();
            values.add(Boolean.FALSE);
            values.add(Boolean.TRUE);
        } else if (type == ValueType.SYMBOL) {
            values = ClsStorer.getTemplateSlotAllowedValues(cls, slot);
        }
        this.storeCollectionFacet("allowed-values", values, false, type, false);
    }

    private void storeAssociatedFacet(Slot slot) {
        Facet facet = slot.getAssociatedFacet();
        if (facet != null) {
            this.println();
            this.print(";+\t\t(associated-facet ");
            this.printFrame(facet);
            this.print(")");
        }
    }

    private void storeCardinalityFacet(Cls cls, Slot slot, boolean allowsMultiple) {
        int min = ClsStorer.getTemplateSlotMinimumCardinality(cls, slot);
        int max = ClsStorer.getTemplateSlotMaximumCardinality(cls, slot);
        if (min != 0 || max != -1) {
            this.println();
            if (!allowsMultiple) {
                this.print(";+");
            }
            this.print("\t\t(cardinality ");
            this.print(min);
            this.print(" ");
            if (max == -1) {
                this.print("?VARIABLE");
            } else {
                this.print(max);
            }
            this.print(")");
        }
    }

    private void storeCls(Cls cls) {
        try {
            if (ClsStorer.isStorable(cls)) {
                this.printCls(cls);
            }
        }
        catch (Exception e) {
            String message = "Errors at storing class " + cls;
            Log.getLogger().log(Level.WARNING, message, e);
            this._errors.add(new MessageError(e, message));
        }
    }

    private void printCls(Cls cls) {
        this.println();
        this.println();
        this.print("(defclass ");
        this.storeFrameName(cls);
        this.storeComment(cls);
        this.storeSuperclasses(cls);
        this.storeRole(cls);
        this.storeSlots(cls);
        this.print(")");
    }

    private void storeFrameName(Cls cls) {
        if (cls == null) {
            this.printFrameName(":CLIPS_TOP_LEVEL_SLOT_CLASS");
        } else {
            this.printFrame(cls);
        }
    }

    private void storeClsAndSubclasses(Cls cls) {
        this._storedClses.add(cls);
        this.storeCls(cls);
        this.storeSubclasses(cls);
    }

    public void storeClses(KnowledgeBase kb, Collection errors) {
        this._kb = kb;
        this._errors = errors;
        this.storeTopLevelSlots(kb);
        Cls root = kb.getRootCls();
        this._storedClses.add(root);
        this.storeSubclasses(root);
        this.flush();
        if (!this.printSucceeded()) {
            errors.add(new MessageError("Store classes failed."));
            Log.getLogger().warning("Store classes failed.");
        }
        this._kb = null;
    }

    private void storeCollectionFacet(String name, Collection c, boolean isExtension, ValueType type, boolean storeIfEmpty) {
        if (c != null && (storeIfEmpty || !c.isEmpty())) {
            this.println();
            if (isExtension) {
                this.print(";+");
            }
            this.print("\t\t(");
            this.print(name);
            Iterator i = c.iterator();
            while (i.hasNext()) {
                this.print(" ");
                Object o = i.next();
                if (o == null) {
                    Log.getLogger().warning("ignoring null facet value");
                    continue;
                }
                String s = o instanceof Cls || o instanceof Slot || o instanceof Facet ? ClsStorer.toExternalFrameName((Frame)o) : (o instanceof Instance ? "[" + ClsStorer.toExternalFrameName((Frame)o) + "]" : (o instanceof Boolean ? ((Boolean)o != false ? "TRUE" : "FALSE") : (type == ValueType.STRING ? ClipsUtil.toExternalString((String)o) : ClipsUtil.toExternalSymbol(o.toString()))));
                this.print(s);
            }
            this.print(")");
        }
    }

    private void storeComment(Cls cls) {
        String comment = ClsStorer.getComment(cls);
        if (comment != null) {
            this.print(" ");
            this.print(ClipsUtil.toExternalString(comment));
        }
    }

    private void storeDefaultValueFacet(Cls cls, Slot slot) {
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        this.storeCollectionFacet("default", ClsStorer.getTemplateSlotDefaultValues(cls, slot), false, type, false);
    }

    private void storeInverseProperty(Slot slot) {
        Slot inverseSlot = slot.getInverseSlot();
        if (inverseSlot != null) {
            this.println();
            this.print(";+\t\t(inverse-slot ");
            this.printFrame(inverseSlot);
            this.print(")");
        }
    }

    private void storeRangeFacet(Cls cls, Slot slot) {
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (type == ValueType.INTEGER || type == ValueType.FLOAT) {
            Number minValue = ClsStorer.getTemplateSlotMinimumValue(cls, slot);
            Number maxValue = ClsStorer.getTemplateSlotMaximumValue(cls, slot);
            if (minValue != null || maxValue != null) {
                ArrayList<String> c = new ArrayList<String>();
                if (type == ValueType.INTEGER) {
                    minValue = minValue == null ? (Number)null : (Number)new Integer(minValue.intValue());
                    maxValue = maxValue == null ? (Number)null : (Number)new Integer(maxValue.intValue());
                }
                c.add(minValue == null ? "?VARIABLE" : minValue.toString());
                c.add(maxValue == null ? "?VARIABLE" : maxValue.toString());
                this.storeCollectionFacet("range", c, false, type, false);
            }
        }
    }

    private void storeRole(Cls cls) {
        this.println();
        this.print("\t(role ");
        String text = ClsStorer.isAbstract(cls) ? "abstract" : "concrete";
        this.print(text);
        this.print(")");
    }

    private void storeSlot(Cls cls, Slot slot) {
        try {
            this.println();
            boolean allowsMultiple = ClsStorer.getTemplateSlotAllowsMultipleValues(cls, slot);
            if (allowsMultiple) {
                this.print("\t(multislot ");
            } else {
                this.print("\t(single-slot ");
            }
            String name = slot.getName();
            if (name.equals("name")) {
                this.print("name_");
            } else if (name.equals("is-a")) {
                this.print("is-a_");
            } else {
                this.printFrame(slot);
            }
            this.storeSlotDocumentation(cls, slot);
            this.storeTypeFacet(cls, slot);
            this.storeAllowedValuesFacet(cls, slot);
            this.storeAllowedParentsFacet(cls, slot);
            this.storeAllowedClsesFacet(cls, slot);
            this.storeRangeFacet(cls, slot);
            this.storeDefaultValueFacet(cls, slot);
            this.storeValueFacet(cls, slot);
            this.storeCardinalityFacet(cls, slot, allowsMultiple);
            if (cls == null) {
                this.storeInverseProperty(slot);
                this.storeSuperslotProperty(slot);
                this.storeAssociatedFacet(slot);
            }
            this.storeConstraintsFacet(cls, slot);
            this.storeUserFacets(cls, slot);
            this.storeAccessorFacet();
            this.print(")");
        }
        catch (Exception e) {
            String message = "Errors at storing slot " + slot + " at class " + cls;
            Log.getLogger().log(Level.WARNING, message, e);
            this._errors.add(new MessageError(e, message));
        }
    }

    private void storeSlotDocumentation(Cls cls, Slot slot) {
        String text = (String)CollectionUtilities.getFirstItem(ClsStorer.getTemplateSlotDocumentation(cls, slot));
        if (text != null) {
            this.println();
            this.print(";+\t\t(comment ");
            this.print(ClipsUtil.toExternalString(text));
            this.print(")");
        }
    }

    private void storeSlots(Cls cls) {
        Collection slotsToStore = this.getSlotsToStore(cls);
        for (Slot slot : slotsToStore) {
            this.storeSlot(cls, slot);
        }
    }

    private Collection getSlotsToStore(Cls cls) {
        HashSet<Slot> slotsToStore;
        if (cls == null) {
            slotsToStore = this.getDirectSlots();
        } else {
            slotsToStore = new HashSet<Slot>(cls.getDirectTemplateSlots());
            slotsToStore.addAll(this._kb.getDirectlyOverriddenTemplateSlots(cls));
        }
        return slotsToStore;
    }

    private Collection getDirectSlots() {
        HashSet slots = new HashSet(this._kb.getSlots());
        Iterator i = slots.iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (!slot.isIncluded()) continue;
            i.remove();
        }
        return slots;
    }

    private void storeSubclasses(Cls cls) {
        for (Cls subclass : ClsStorer.getDirectSubclasses(cls)) {
            if (this._storedClses.contains(subclass) || !this.superclassesStored(subclass)) continue;
            this.storeClsAndSubclasses(subclass);
        }
    }

    private void storeSuperclasses(Cls cls) {
        this.println();
        this.print("\t(is-a");
        Collection<Cls> superclasses = this.getDirectSuperclasses(cls);
        Cls rootCls = this.getRootCls();
        for (Cls superclass : superclasses) {
            if (ClsStorer.equals(superclass, rootCls)) {
                this.print(" USER");
                continue;
            }
            this.print(" ");
            this.printFrame(superclass);
        }
        this.print(")");
    }

    private void storeSuperslotProperty(Slot slot) {
        Collection superslots = slot.getDirectSuperslots();
        if (!superslots.isEmpty()) {
            this.println();
            this.print(";+\t\t(subslot-of ");
            boolean isFirst = true;
            Iterator i = superslots.iterator();
            while (i.hasNext()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.print(" ");
                }
                Slot superslot = (Slot)i.next();
                this.printFrame(superslot);
            }
            this.print(")");
        }
    }

    private void storeTopLevelSlots(KnowledgeBase kb) {
        this.printCls(null);
    }

    private void storeTypeFacet(Cls cls, Slot slot) {
        this.println();
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        if (type == ValueType.ANY) {
            this.print(";+");
        }
        this.print("\t\t(type ");
        String typeName = (String)_typeStrings.get(type);
        this.print(typeName);
        this.print(")");
    }

    private void storeConstraintsFacet(Cls cls, Slot slot) {
        Facet facet = this._kb.getFacet(":CONSTRAINTS");
        this.storeUserFacet(cls, slot, facet);
    }

    private void storeUserFacet(Cls cls, Slot slot, Facet facet) {
        if (ClsStorer.hasDirectlyOverriddenTemplateFacet(cls, slot, facet)) {
            Collection values = ClsStorer.getDirectTemplateFacetValues(cls, slot, facet);
            ValueType type = facet.getValueType();
            this.storeCollectionFacet("user-facet " + facet.getName(), values, true, type, true);
        }
    }

    private void storeUserFacets(Cls cls, Slot slot) {
        for (Facet facet : ClsStorer.getTemplateFacets(cls, slot)) {
            if (facet.isSystem()) continue;
            this.storeUserFacet(cls, slot, facet);
        }
    }

    private void storeValueFacet(Cls cls, Slot slot) {
        ValueType type = ClsStorer.getTemplateSlotValueType(cls, slot);
        this.storeCollectionFacet("value", ClsStorer.getTemplateSlotValues(cls, slot), true, type, false);
    }

    private boolean superclassesStored(Cls cls) {
        boolean superclassesStored = true;
        for (Cls superclass : cls.getDirectSuperclasses()) {
            if (this._storedClses.contains(superclass)) continue;
            superclassesStored = false;
            break;
        }
        return superclassesStored;
    }

    static {
        _typeStrings.put(ValueType.ANY, "ANY");
        _typeStrings.put(ValueType.BOOLEAN, "SYMBOL");
        _typeStrings.put(ValueType.CLS, "SYMBOL");
        _typeStrings.put(ValueType.FLOAT, "FLOAT");
        _typeStrings.put(ValueType.INSTANCE, "INSTANCE");
        _typeStrings.put(ValueType.INTEGER, "INTEGER");
        _typeStrings.put(ValueType.STRING, "STRING");
        _typeStrings.put(ValueType.SYMBOL, "SYMBOL");
    }
}

