/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileField;
import edu.stanford.smi.protege.util.PropertyList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URI;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FileSourcesPanel
extends KnowledgeBaseSourcesEditor {
    private static final long serialVersionUID = -6725659436464810319L;
    private FileField _clsesField;
    private FileField _instancesField;

    public FileSourcesPanel(String projectURIString, PropertyList sources) {
        super(projectURIString, sources);
        Box box = Box.createVerticalBox();
        box.add(this.createClsesField());
        box.add(this.createInstancesField());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "North");
        this.add(panel);
    }

    public URI getProjectURI() {
        return null;
    }

    public void saveContents() {
        String clsesFileName = this.getBaseFile(this._clsesField);
        String instancesFileName = this.getBaseFile(this._instancesField);
        ClipsKnowledgeBaseFactory.setSourceFiles(this.getSources(), clsesFileName, instancesFileName);
    }

    public boolean validateContents() {
        return true;
    }

    protected JComponent createClsesField() {
        String file = ClipsKnowledgeBaseFactory.getClsesSourceFile(this.getSources());
        this._clsesField = new FileField("Classes file name", file, ".pont", "Ontology");
        return this._clsesField;
    }

    protected JComponent createInstancesField() {
        String file = ClipsKnowledgeBaseFactory.getInstancesSourceFile(this.getSources());
        this._instancesField = new FileField("Instances file name", file, ".pins", "Instances");
        return this._instancesField;
    }

    public void onProjectPathChange(String oldPath, String newPath) {
        super.onProjectPathChange(oldPath, newPath);
        if (newPath != null) {
            this.updatePath(this._clsesField, newPath, ".pont");
            this.updatePath(this._instancesField, newPath, ".pins");
        }
    }
}

