/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.storage.clips.ClipsFileWriter;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.ui.FrameNameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class InstanceStorer
extends ClipsFileWriter {
    private Collection _errors;
    private Map _clsToSlotsMap = new HashMap();
    private Slot _constraintsSlot;
    private Map clsToSlotToValueTypeMap = new HashMap();
    private Set _slotNamesToNotSaveForClsesAndSlots = new HashSet();
    private Set _slotNamesNeverToSave = new HashSet();
    private Map clsToSlotToBooleanMap;

    public InstanceStorer(Writer writer) {
        super(writer);
        this._slotNamesToNotSaveForClsesAndSlots.add(":NAME");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-TYPE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-INSTANCES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUPERCLASSES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUBCLASSES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-TEMPLATE-SLOTS");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-DOMAIN");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DOCUMENTATION");
        this._slotNamesToNotSaveForClsesAndSlots.add(":ROLE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-VALUE-TYPE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-MINIMUM-CARDINALITY");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-MAXIMUM-CARDINALITY");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-NUMERIC-MINIMUM");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-NUMERIC-MAXIMUM");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-DEFAULTS");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-VALUES");
        this._slotNamesToNotSaveForClsesAndSlots.add(":SLOT-INVERSE");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUBSLOTS");
        this._slotNamesToNotSaveForClsesAndSlots.add(":DIRECT-SUPERSLOTS");
        this._slotNamesNeverToSave.add(":NAME");
        this._slotNamesNeverToSave.add(":DIRECT-TYPE");
        this.clsToSlotToBooleanMap = new HashMap();
    }

    private static Collection anyToStrings(Collection anyValues) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object o : anyValues) {
            String value = o instanceof Frame ? "[" + InstanceStorer.toExternalFrameName((Frame)o) + "]" : (o instanceof String ? ClipsUtil.toExternalString((String)o) : (o instanceof Boolean ? ((Boolean)o != false ? "TRUE" : "FALSE") : o.toString()));
            strings.add(value);
        }
        return strings;
    }

    private static Collection booleansToStrings(Collection booleans) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Boolean b : booleans) {
            String s = b != false ? "TRUE" : "FALSE";
            strings.add(s);
        }
        return strings;
    }

    private static Collection clsesToStrings(Collection clses) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object o : clses) {
            if (o instanceof Cls) {
                Cls cls = (Cls)o;
                strings.add(InstanceStorer.toExternalFrameName(cls));
                continue;
            }
            Log.getLogger().warning("not a class: " + o);
        }
        return strings;
    }

    private Collection getSlots(Instance instance) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Cls type : instance.getDirectTypes()) {
            ArrayList<Slot> typeSlots = (ArrayList<Slot>)this._clsToSlotsMap.get(type);
            if (typeSlots == null) {
                typeSlots = new ArrayList<Slot>(type.getTemplateSlots());
                Collections.sort(typeSlots);
                this._clsToSlotsMap.put(type, typeSlots);
            }
            slots.addAll(typeSlots);
        }
        return slots;
    }

    private boolean hasConstraintSlotValues(Instance instance) {
        if (this._constraintsSlot == null) {
            this._constraintsSlot = (Slot)instance.getKnowledgeBase().getFrame(":SLOT-CONSTRAINTS");
        }
        return instance.getOwnSlotValueCount(this._constraintsSlot) != 0;
    }

    private static Collection instancesToStrings(Collection instances) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Instance instance : instances) {
            strings.add("[" + InstanceStorer.toExternalFrameName(instance) + "]");
        }
        return strings;
    }

    private static Collection internalToExternalStrings(Collection internalStrings) {
        ArrayList<String> externalStrings = new ArrayList<String>();
        for (String s : internalStrings) {
            if (s.length() <= 0) continue;
            externalStrings.add(ClipsUtil.toExternalString(s));
        }
        return externalStrings;
    }

    private static Collection internalToExternalSymbols(Collection internalSymbols) {
        ArrayList<String> externalStrings = new ArrayList<String>();
        for (String s : internalSymbols) {
            if (s.length() <= 0) continue;
            externalStrings.add(ClipsUtil.toExternalSymbol(s));
        }
        return externalStrings;
    }

    private static boolean isStandardClsSlot(Instance instance) {
        Collection types = instance.getDirectTypes();
        boolean isStandard = false;
        if (types.size() == 1) {
            Cls type = instance.getDirectType();
            FrameID typeID = type.getFrameID();
            isStandard = InstanceStorer.equals(typeID, Model.ClsID.STANDARD_CLASS) || InstanceStorer.equals(typeID, Model.ClsID.STANDARD_SLOT);
        }
        return isStandard;
    }

    protected boolean isStorableInstance(Instance instance) {
        boolean isStorable = false;
        if (instance.isDeleted()) {
            Log.getLogger().warning("has been deleted: " + instance.getName());
        } else if (instance.getDirectType() == null) {
            Log.getLogger().warning("null type: " + instance.getName());
        } else if (InstanceStorer.isStandardClsSlot(instance)) {
            isStorable = this.hasConstraintSlotValues(instance);
        } else if (instance.getName() == null) {
            Log.getLogger().warning("null name: " + instance.hashCode());
        } else {
            isStorable = !instance.isIncluded();
        }
        return isStorable;
    }

    protected boolean isStorableSlot(Instance instance, Slot slot) {
        boolean storable = instance instanceof Cls || instance instanceof Slot ? !this._slotNamesToNotSaveForClsesAndSlots.contains(slot.getName()) : !this._slotNamesNeverToSave.contains(slot.getName());
        return storable;
    }

    private void printValues(Slot slot, Collection values, boolean onePerLine, boolean allowsMultiple) {
        this.println();
        this.print("\t(");
        this.printFrame(slot);
        if (values.size() == 1 || !allowsMultiple) {
            this.print(" ");
            this.print(values.iterator().next().toString());
            this.print(")");
        } else {
            Iterator i = values.iterator();
            while (i.hasNext()) {
                if (onePerLine) {
                    this.println();
                    this.print("\t\t");
                } else {
                    this.print(" ");
                }
                String value = i.next().toString();
                this.print(value);
            }
            this.print(")");
        }
    }

    private void storeInstance(Instance instance) {
        try {
            if (this.isStorableInstance(instance)) {
                this.println();
                this.print("([");
                this.printFrame(instance);
                this.print("] of ");
                this.printTypes(instance);
                this.storeSlotValues(instance);
                this.println(")");
            }
        }
        catch (Exception e) {
            String message = "Errors at storing instance " + instance;
            Log.getLogger().log(Level.WARNING, message, e);
            this._errors.add(new MessageError(e, message));
        }
    }

    private void printTypes(Instance instance) {
        Collection types = instance.getDirectTypes();
        for (Cls cls : types) {
            this.print(" ");
            this.printFrame(cls);
        }
        this.println();
    }

    public void storeInstances(KnowledgeBase kb, Collection errors) {
        this._errors = errors;
        ArrayList<Instance> instances = new ArrayList<Instance>(kb.getInstances());
        Collections.sort(instances, new FrameNameComparator());
        for (Instance instance : instances) {
            this.storeInstance(instance);
        }
        this.flush();
        if (!this.printSucceeded()) {
            errors.add(new MessageError("Store instances failed"));
            Log.getLogger().warning("Store instances failed");
        }
    }

    private void storeSlotValue(Instance instance, Slot slot, boolean multiple) {
        try {
            Collection values = instance.getDirectOwnSlotValues(slot);
            if (!values.isEmpty()) {
                boolean onePerLine = false;
                ValueType type = this.getValueType(instance, slot);
                if (InstanceStorer.equals(type, ValueType.BOOLEAN)) {
                    values = InstanceStorer.booleansToStrings(values);
                } else if (InstanceStorer.equals(type, ValueType.INSTANCE)) {
                    values = InstanceStorer.instancesToStrings(values);
                    onePerLine = true;
                } else if (InstanceStorer.equals(type, ValueType.CLS)) {
                    values = InstanceStorer.clsesToStrings(values);
                    onePerLine = true;
                } else if (InstanceStorer.equals(type, ValueType.STRING)) {
                    values = InstanceStorer.internalToExternalStrings(values);
                    onePerLine = true;
                } else if (InstanceStorer.equals(type, ValueType.SYMBOL)) {
                    values = InstanceStorer.internalToExternalSymbols(values);
                } else if (InstanceStorer.equals(type, ValueType.ANY)) {
                    values = InstanceStorer.anyToStrings(values);
                }
                if (!values.isEmpty()) {
                    this.printValues(slot, values, onePerLine, multiple);
                }
            }
        }
        catch (Exception e) {
            String message = "Errors at storing slot " + slot + " at instance " + instance;
            Log.getLogger().log(Level.WARNING, message, e);
            this._errors.add(new MessageError(e, message));
        }
    }

    private void storeSlotValues(Instance instance) {
        for (Slot slot : this.getSlots(instance)) {
            if (!this.isStorableSlot(instance, slot)) continue;
            boolean allowsMultiple = this.getAllowsMultipleValues(instance, slot);
            this.storeSlotValue(instance, slot, allowsMultiple);
        }
    }

    private boolean getAllowsMultipleValues(Instance instance, Slot slot) {
        Boolean allowsMultipleValues;
        Collection types = instance.getDirectTypes();
        if (types.size() == 1) {
            Cls type = (Cls)CollectionUtilities.getFirstItem(types);
            HashMap<Slot, Boolean> slotToBooleanMap = (HashMap<Slot, Boolean>)this.clsToSlotToBooleanMap.get(type);
            if (slotToBooleanMap == null) {
                slotToBooleanMap = new HashMap<Slot, Boolean>();
                this.clsToSlotToBooleanMap.put(type, slotToBooleanMap);
            }
            if ((allowsMultipleValues = (Boolean)slotToBooleanMap.get(slot)) == null) {
                boolean allowsMultiple = instance.getOwnSlotAllowsMultipleValues(slot);
                allowsMultipleValues = allowsMultiple;
                slotToBooleanMap.put(slot, allowsMultipleValues);
            }
        } else {
            allowsMultipleValues = instance.getOwnSlotAllowsMultipleValues(slot);
        }
        return allowsMultipleValues;
    }

    private ValueType getValueType(Instance instance, Slot slot) {
        ValueType valueType;
        Collection types = instance.getDirectTypes();
        if (types.size() == 1) {
            Cls type = (Cls)CollectionUtilities.getFirstItem(types);
            HashMap<Slot, ValueType> slotToValueTypeMap = (HashMap<Slot, ValueType>)this.clsToSlotToValueTypeMap.get(type);
            if (slotToValueTypeMap == null) {
                slotToValueTypeMap = new HashMap<Slot, ValueType>();
                this.clsToSlotToValueTypeMap.put(type, slotToValueTypeMap);
            }
            if ((valueType = (ValueType)slotToValueTypeMap.get(slot)) == null) {
                valueType = instance.getOwnSlotValueType(slot);
                slotToValueTypeMap.put(slot, valueType);
            }
        } else {
            valueType = instance.getOwnSlotValueType(slot);
        }
        return valueType;
    }
}

