/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.storage.clips.ClipsUtil;
import edu.stanford.smi.protege.storage.clips.ParseException;
import edu.stanford.smi.protege.storage.clips.ParserConstants;
import edu.stanford.smi.protege.storage.clips.ParserTokenManager;
import edu.stanford.smi.protege.storage.clips.SimpleCharStream;
import edu.stanford.smi.protege.storage.clips.Token;
import edu.stanford.smi.protege.storage.clips.TokenMgrError;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public final class Parser
implements ParserConstants {
    private KnowledgeBase itsKB;
    private Collection _itsErrors;
    private boolean isInclude;
    private Cls itsDefaultMetaCls;
    private Map itsInverseSlotMap = new HashMap();
    private Map itsSuperslotsMap = new HashMap();
    private Collection itsUndefinedClses = new HashSet();
    private Collection itsUndefinedInstances = new HashSet();
    private String state;
    private static final String LOADING_CLASSES = "loading classes";
    private static final String LOADING_INSTANCES = "loading instances";
    private static final String UNDEFINED_CLASS = ":UNDEFINED";
    private int nClses;
    private static int MIN_TRACE_COUNT = 5000;
    private static int TRACE_COUNT_DELTA = 1000;
    private static int MIN_CLASS_TRACE_COUNT = MIN_TRACE_COUNT;
    private static int MIN_INSTANCE_TRACE_COUNT = MIN_TRACE_COUNT;
    private static int CLASS_TRACE_COUNT_DELTA = TRACE_COUNT_DELTA;
    private static int INSTANCE_TRACE_COUNT_DELTA = TRACE_COUNT_DELTA;
    private int nInstances;
    private int nSetTypeInstances;
    private static final String VARIABLE = "?VARIABLE";
    private Map clsToSlotToValueType = new HashMap();
    public ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[43];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public String toString() {
        return "ClipsParser";
    }

    private void recordError(String msg) {
        this.recordError(msg, null);
    }

    private void recordError(String msg, Throwable e) {
        Object error = e == null ? msg : e;
        this._itsErrors.add(error);
        Log.getLogger().log(Level.SEVERE, msg, e);
    }

    public void loadClses(KnowledgeBase kb, boolean isIncluded, Collection errors) {
        try {
            this.state = LOADING_CLASSES;
            this.itsKB = kb;
            this.itsDefaultMetaCls = kb.getCls(":STANDARD-CLASS");
            this.isInclude = isIncluded;
            this._itsErrors = errors;
            this.parseOntology();
            this.connectInverseSlots();
            this.connectSuperslots();
            this.checkUndefinedClasses();
        }
        catch (Exception e) {
            this.recordError("Error parsing classes", e);
        }
    }

    private Cls getUndefinedSuperclass() {
        Cls cls = this.itsKB.getCls(UNDEFINED_CLASS);
        if (cls == null) {
            Collection<Cls> parents = CollectionUtilities.createCollection(this.itsKB.getRootCls());
            cls = this.itsKB.createCls(UNDEFINED_CLASS, parents);
        }
        return cls;
    }

    private void checkUndefinedClasses() {
        if (!this.itsUndefinedClses.isEmpty()) {
            Cls standardCls = this.itsKB.getDefaultClsMetaCls();
            Cls undefinedSuperclass = this.getUndefinedSuperclass();
            for (Cls cls : this.itsUndefinedClses) {
                this.recordError("Undefined class: " + cls.getName() + " found while " + this.state);
                cls.addDirectSuperclass(undefinedSuperclass);
                cls.setDirectType(standardCls);
            }
            this.itsUndefinedClses.clear();
        }
    }

    private void checkUndefinedInstances() {
        if (!this.itsUndefinedInstances.isEmpty()) {
            Cls cls = this.getUndefinedSuperclass();
            for (Instance instance : this.itsUndefinedInstances) {
                this.recordError("Undefined instance: " + instance.getName());
                instance.setDirectType(cls);
            }
        }
    }

    public void loadInstances(KnowledgeBase kb, boolean isIncluded, Collection errors) {
        try {
            this.state = LOADING_INSTANCES;
            this.itsKB = kb;
            this.isInclude = isIncluded;
            this._itsErrors = errors;
            this.parseKnowledgeBase();
            this.checkUndefinedClasses();
            this.checkUndefinedInstances();
        }
        catch (Exception e) {
            this.recordError("Error loading instances", e);
        }
    }

    private void handleException(Throwable e) {
        Token t;
        this.recordError("Parsing error", e);
        do {
            t = this.getNextToken();
        } while (t.kind != 0 && t.kind != 12 && this.getToken((int)1).kind != 11);
    }

    private void nameConflictError(String name, String typeName, Frame frame) {
        String text = name + " is both a " + typeName + " and a " + this.getTypeName(frame);
        this.recordError(text, null);
    }

    private String getTypeName(Frame frame) {
        String typeName = frame instanceof Cls ? "class" : (frame instanceof Slot ? "slot" : (frame instanceof Facet ? "facet" : (frame instanceof SimpleInstance ? "simple instance" : frame.getClass().getName())));
        return typeName;
    }

    private Cls getCls(String name, String comment, Collection parents, boolean isDefinition) {
        Cls cls;
        Frame frame;
        if (name.equals(":CLIPS_TOP_LEVEL_SLOT_CLASS")) {
            return null;
        }
        if (name.equals("USER")) {
            name = this.itsKB.getRootCls().getName();
        }
        if ((frame = this.itsKB.getFrame(name)) == null) {
            cls = this.itsKB.createCls(name, parents, this.itsDefaultMetaCls, false);
            if (++this.nClses % CLASS_TRACE_COUNT_DELTA == 0 && this.nClses >= MIN_CLASS_TRACE_COUNT) {
                Log.getLogger().info("Loaded " + this.nClses + " classes: " + name);
            }
            if (comment != null) {
                cls.setDocumentation(comment);
            }
            if (!isDefinition) {
                this.itsUndefinedClses.add(cls);
            }
        } else if (frame instanceof Cls) {
            cls = (Cls)frame;
            if (isDefinition) {
                boolean succeeded = this.itsUndefinedClses.remove(cls);
                if (succeeded) {
                    if (comment != null) {
                        cls.setDocumentation(comment);
                    }
                    if (!parents.isEmpty()) {
                        this.addDirectSuperclasses(cls, parents);
                    }
                } else {
                    this.recordError("Duplicate definition of class " + name + " was ignored");
                }
            }
        } else if (frame instanceof SimpleInstance && ((Instance)frame).getDirectType() == null) {
            this.itsKB.setDirectType((Instance)frame, this.itsKB.getDefaultClsMetaCls());
            cls = this.itsKB.getCls(name);
            for (Cls parent : parents) {
                cls.addDirectSuperclass(parent);
            }
        } else {
            this.nameConflictError(name, "class", frame);
            cls = this.getCls(name + "_", comment, parents, isDefinition);
        }
        if (this.isInclude) {
            cls.setIncluded(true);
        }
        return cls;
    }

    private void addDirectSuperclasses(Cls cls, Collection parents) {
        for (Cls parent : parents) {
            cls.addDirectSuperclass(parent);
        }
    }

    private boolean hasSlot(String name) {
        return this.itsKB.containsFrame(name);
    }

    private Slot getExistingSlot(String name) {
        Slot slot;
        Frame frame = this.itsKB.getFrame(name);
        if (frame instanceof Slot) {
            slot = (Slot)frame;
        } else {
            this.recordError("non-existent slot: " + name);
            slot = this.getSlot(name);
        }
        return slot;
    }

    private Slot getSlot(String name) {
        Slot slot;
        Frame frame = this.itsKB.getFrame(name);
        if (frame == null) {
            slot = this.itsKB.createSlot(name, this.itsKB.getDefaultSlotMetaCls(), false);
        } else if (frame instanceof Slot) {
            slot = (Slot)frame;
        } else {
            this.nameConflictError(name, "slot", frame);
            slot = this.getSlot(name + "_");
        }
        if (this.isInclude) {
            slot.setIncluded(true);
        }
        return slot;
    }

    private Instance getInstance(String instanceName, Collection types) {
        Instance instance = this.itsKB.getInstance(instanceName);
        if (instance == null) {
            Collection directTypes = types == null ? Collections.EMPTY_LIST : types;
            instance = this.itsKB.createInstance(new FrameID(instanceName), directTypes, false);
            if (++this.nInstances % INSTANCE_TRACE_COUNT_DELTA == 0 && this.nInstances >= MIN_INSTANCE_TRACE_COUNT) {
                Log.getLogger().info("Loaded " + this.nInstances + " instances: " + instanceName);
            }
            if (types == null) {
                this.itsUndefinedInstances.add(instance);
            }
            if (instance instanceof Cls) {
                this.itsUndefinedClses.add(instance);
            }
        } else if (types != null && !CollectionUtilities.equalsSet(instance.getDirectTypes(), types)) {
            if (Parser.isTypeMismatch(instance, types)) {
                this.recordError("type mismatch: " + instance + " cannot become an instance of " + types);
            }
            Instance oldInstance = instance;
            instance = instance.setDirectTypes(types);
            if (++this.nSetTypeInstances % INSTANCE_TRACE_COUNT_DELTA == 0 && this.nSetTypeInstances >= MIN_INSTANCE_TRACE_COUNT) {
                Log.getLogger().info("Set type on " + this.nSetTypeInstances + " instances: " + instanceName);
            }
            this.itsUndefinedInstances.remove(oldInstance);
        }
        if (this.isInclude) {
            instance.setIncluded(true);
        }
        return instance;
    }

    private static boolean isTypeMismatch(Instance instance, Collection types) {
        Cls cls = (Cls)CollectionUtilities.getFirstItem(types);
        boolean isTypeMismatch = instance instanceof Cls ? !cls.isClsMetaCls() : (instance instanceof Slot ? !cls.isSlotMetaCls() : (instance instanceof Facet ? !cls.isFacetMetaCls() : false));
        return isTypeMismatch;
    }

    private void checkBooleanAndSetValues(Cls cls, Slot slot, Collection values) {
        if (this.areBooleanValues(values)) {
            if (cls == null) {
                Collection defaults = slot.getDefaultValues();
                defaults = this.convertToBooleanDefaults(defaults);
                slot.setValueType(ValueType.BOOLEAN);
                slot.setDefaultValues(defaults);
            } else {
                Collection defaults = cls.getTemplateSlotDefaultValues(slot);
                defaults = this.convertToBooleanDefaults(defaults);
                cls.setTemplateSlotValueType(slot, ValueType.BOOLEAN);
                cls.setTemplateSlotDefaultValues(slot, defaults);
            }
        } else if (cls == null) {
            slot.setAllowedValues(values);
        } else {
            cls.setTemplateSlotAllowedValues(slot, values);
        }
    }

    private boolean areBooleanValues(Collection values) {
        String v2;
        Iterator i;
        String v1;
        boolean areBooleanValues = false;
        if (values.size() == 2 && Parser.isBooleanValue(v1 = (String)(i = values.iterator()).next()) && Parser.isBooleanValue(v2 = (String)i.next())) {
            areBooleanValues = !v1.equalsIgnoreCase(v2);
        }
        return areBooleanValues;
    }

    private Collection convertToBooleanDefaults(Collection c) {
        ArrayList<Boolean> booleans;
        if (c.isEmpty()) {
            booleans = Collections.EMPTY_LIST;
        } else {
            booleans = new ArrayList<Boolean>();
            for (Object o : c) {
                booleans.add(Boolean.valueOf(o.toString()));
            }
        }
        return booleans;
    }

    private static boolean isBooleanValue(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    private void checkedValueAdd(Collection values, ValueType type, Object value) {
        try {
            this.tryCheckedValueAdd(values, type, value);
        }
        catch (Exception e) {
            this.recordError("invalid object type", e);
        }
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    private void tryCheckedValueAdd(Collection values, ValueType type, Object value) {
        Object first;
        if (type == ValueType.CLS && value instanceof String) {
            value = this.getCls((String)value, null, Collections.EMPTY_LIST, false);
        } else if (type == ValueType.INSTANCE && value instanceof String) {
            value = this.getInstance((String)value, null);
        } else if (type == ValueType.FLOAT) {
            value = this.toFloat((String)value);
        } else if (type == ValueType.INTEGER) {
            value = this.toInteger((String)value);
        } else if (type == ValueType.BOOLEAN) {
            value = new Boolean((String)value);
        } else if (type == ValueType.ANY && value instanceof String && (first = CollectionUtilities.getFirstItem(values)) != null && Parser.appearsToBeValueType(values)) {
            value = this.getInstance((String)value, null);
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        values.add(value);
    }

    private static boolean appearsToBeValueType(Collection values) {
        boolean isValueType = false;
        Object first = CollectionUtilities.getFirstItem(values);
        if (first != null) {
            isValueType = first.equals(ValueType.INSTANCE.toString()) || first.equals(ValueType.CLS.toString());
        }
        return isValueType;
    }

    Slot createTemplateSlot(String name, boolean isSingle, Cls cls, boolean isTopLevel) {
        Slot slot = this.getSlot(name);
        if (cls != null && !cls.hasTemplateSlot(slot)) {
            cls.addDirectTemplateSlot(slot);
        }
        if (!isSingle) {
            if (isTopLevel) {
                slot.setAllowsMultipleValues(true);
            } else {
                cls.setTemplateSlotAllowsMultipleValues(slot, true);
            }
        }
        return slot;
    }

    ValueType getSlotType(Cls cls, Slot slot) {
        return cls == null ? slot.getValueType() : cls.getTemplateSlotValueType(slot);
    }

    private Integer toInteger(String s) {
        Integer i = null;
        try {
            if (!s.equals(VARIABLE)) {
                i = new Integer(s);
            }
        }
        catch (Exception e) {
            try {
                Float f = new Float(s);
                i = new Integer(f.intValue());
            }
            catch (Exception e2) {
                this.recordError("Invalid integer: " + s, e2);
                i = null;
            }
        }
        return i;
    }

    private Float toFloat(String s) {
        Float f = null;
        try {
            if (!s.equals(VARIABLE)) {
                f = new Float(s);
            }
        }
        catch (Exception e) {
            this.recordError("Invalid floating point number: " + s, e);
            f = null;
        }
        return f;
    }

    private void addInverseSlotPair(Slot slot, Slot inverseSlot) {
        Slot existingSlot = (Slot)this.itsInverseSlotMap.get(inverseSlot);
        if (existingSlot == null) {
            this.itsInverseSlotMap.put(slot, inverseSlot);
        } else if (!Parser.equals(existingSlot, slot)) {
            this.recordError("mismatched inverse slots: " + slot + ", " + inverseSlot + ", " + existingSlot);
        }
    }

    private void addSuperslots(Slot slot, Collection superslots) {
        this.itsSuperslotsMap.put(slot, superslots);
    }

    private void connectInverseSlots() {
        for (Slot slot : this.itsInverseSlotMap.keySet()) {
            Slot inverseSlot = (Slot)this.itsInverseSlotMap.get(slot);
            slot.setInverseSlot(inverseSlot);
        }
    }

    private void connectSuperslots() {
        for (Slot slot : this.itsSuperslotsMap.keySet()) {
            Collection superslots = (Collection)this.itsSuperslotsMap.get(slot);
            this.connectSuperslots(slot, superslots);
        }
    }

    private void connectSuperslots(Slot slot, Collection superslots) {
        for (String name : superslots) {
            Slot superslot = this.itsKB.getSlot(name);
            slot.addDirectSuperslot(superslot);
        }
    }

    private Facet getOrCreateFacet(String facetName) {
        Facet facet = this.itsKB.getFacet(facetName);
        if (facet == null) {
            facet = this.itsKB.createFacet(facetName, this.itsKB.getDefaultFacetMetaCls(), false);
        }
        return facet;
    }

    private ValueType getOwnSlotValueType(Instance instance, Collection directTypes, Slot slot) {
        ValueType valueType;
        if (directTypes.size() == 1) {
            Cls type = (Cls)CollectionUtilities.getFirstItem(directTypes);
            HashMap<Slot, ValueType> slotToValueType = (HashMap<Slot, ValueType>)this.clsToSlotToValueType.get(type);
            if (slotToValueType == null) {
                slotToValueType = new HashMap<Slot, ValueType>();
                this.clsToSlotToValueType.put(type, slotToValueType);
            }
            if ((valueType = (ValueType)slotToValueType.get(slot)) == null) {
                valueType = instance.getOwnSlotValueType(slot);
                slotToValueType.put(slot, valueType);
            }
        } else {
            valueType = instance.getOwnSlotValueType(slot);
        }
        return valueType;
    }

    public final void accessFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(17);
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allowedClassesValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(18);
        List clses = this.clsesList();
        if (cls == null) {
            slot.setAllowedClses(clses);
        } else {
            cls.setTemplateSlotAllowedClses(slot, clses);
        }
    }

    public final void allowedConstantValueDescription(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 19: {
                this.allowedFloatsValueDescription(cls, slot);
                break;
            }
            case 21: {
                this.allowedIntegersValueDescription(cls, slot);
                break;
            }
            case 24: {
                this.allowedSymbolsValueDescription(cls, slot);
                break;
            }
            case 23: {
                this.allowedStringsValueDescription(cls, slot);
                break;
            }
            case 25: {
                this.allowedValuesValueDescription(cls, slot);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allowedConstantValueDescriptionExtension(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 18: {
                this.allowedClassesValueDescription(cls, slot);
                break;
            }
            case 20: {
                this.allowedGrammarValueDescription(cls, slot);
                break;
            }
            case 22: {
                this.allowedParentsValueDescription(cls, slot);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void allowedFloatsValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        this.jj_consume_token(19);
        block3: while (true) {
            String s = this.symbol();
            list.add(s);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[3] = this.jj_gen;
    }

    public final void allowedGrammarValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(20);
        this.string();
        switch (this.jj_nt.kind) {
            case 77: {
                this.string();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
    }

    public final void allowedIntegersValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        this.jj_consume_token(21);
        block3: while (true) {
            String s = this.symbol();
            list.add(s);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[5] = this.jj_gen;
    }

    public final void allowedParentsValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(22);
        List parents = this.clsesList();
        if (cls == null) {
            slot.setAllowedParents(parents);
        } else {
            cls.setTemplateSlotAllowedParents(slot, parents);
        }
    }

    public final void allowedStringsValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        this.jj_consume_token(23);
        block3: while (true) {
            String s = this.string();
            list.add(s);
            switch (this.jj_nt.kind) {
                case 77: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[6] = this.jj_gen;
        if (cls == null) {
            slot.setAllowedValues(list);
        } else {
            cls.setTemplateSlotAllowedValues(slot, list);
        }
    }

    public final void allowedSymbolsValueDescription(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        this.jj_consume_token(24);
        block3: while (true) {
            String s = this.symbol();
            list.add(s);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[7] = this.jj_gen;
        if (cls == null) {
            slot.setAllowedValues(list);
        } else {
            cls.setTemplateSlotAllowedValues(slot, list);
        }
    }

    public final void allowedValuesValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(25);
        List list = this.constants();
        this.checkBooleanAndSetValues(cls, slot, list);
    }

    public final void cardinalityValueDescription(Cls cls, Slot slot) throws ParseException {
        Integer max;
        this.jj_consume_token(29);
        String minString = this.symbol();
        String maxString = this.symbol();
        Integer min = this.toInteger(minString);
        if (min != null && min != 0) {
            if (cls == null) {
                slot.setMinimumCardinality(min);
            } else {
                cls.setTemplateSlotMinimumCardinality(slot, min);
            }
        }
        if ((max = this.toInteger(maxString)) != null) {
            if (cls == null) {
                slot.setMaximumCardinality(max);
            } else {
                cls.setTemplateSlotMaximumCardinality(slot, max);
            }
        }
    }

    public final void cls() throws ParseException {
        String comment = null;
        try {
            this.jj_consume_token(11);
            this.jj_consume_token(35);
            String name = this.symbol();
            switch (this.jj_nt.kind) {
                case 77: {
                    comment = this.string();
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                }
            }
            this.jj_consume_token(11);
            this.jj_consume_token(44);
            List parents = this.clsesList();
            this.jj_consume_token(12);
            Cls cls = this.getCls(name, comment, parents, true);
            this.clsRole(cls);
            block9: while (true) {
                switch (this.jj_nt.kind) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        break block9;
                    }
                }
                this.slot(cls);
            }
            this.jj_consume_token(12);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        catch (TokenMgrError e) {
            this.handleException(e);
        }
    }

    public final Cls clsReference() throws ParseException {
        String name = this.symbol();
        return this.getCls(name, null, Collections.EMPTY_LIST, false);
    }

    public final List clsesList() throws ParseException {
        ArrayList<Cls> clses = new ArrayList<Cls>();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            Cls cls = this.clsReference();
            clses.add(cls);
        }
        return clses;
    }

    public final void clsRole(Cls cls) throws ParseException {
        boolean isAbstract;
        this.jj_consume_token(11);
        this.jj_consume_token(61);
        switch (this.jj_nt.kind) {
            case 32: {
                this.jj_consume_token(32);
                isAbstract = false;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                isAbstract = true;
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(12);
        if (cls != null) {
            cls.setAbstract(isAbstract);
        }
    }

    public final Object constant() throws ParseException {
        Object o;
        switch (this.jj_nt.kind) {
            case 77: {
                o = this.string();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: {
                o = this.symbol();
                break;
            }
            case 76: {
                o = this.instanceReference();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return o;
    }

    public final List constants() throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        block3: while (true) {
            Object value = this.constant();
            list.add(value);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[13] = this.jj_gen;
        return list;
    }

    public final void constraintValueDescription(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 70: {
                this.typeValueDescription(cls, slot);
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                this.allowedConstantValueDescription(cls, slot);
                break;
            }
            case 56: {
                this.rangeValueDescription(cls, slot);
                break;
            }
            case 29: {
                this.cardinalityValueDescription(cls, slot);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void constraintValueDescriptionExtension(Cls cls, Slot slot) throws ParseException {
        this.allowedConstantValueDescriptionExtension(cls, slot);
    }

    public final void createAccessorFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(33);
        switch (this.jj_nt.kind) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void defaultFacet(Cls cls, Slot slot) throws ParseException {
        ArrayList list = new ArrayList();
        ValueType type = this.getSlotType(cls, slot);
        this.jj_consume_token(34);
        block3: while (true) {
            Object value = this.constant();
            this.checkedValueAdd(list, type, value);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[16] = this.jj_gen;
        if (cls == null) {
            slot.setDefaultValues(list);
        } else {
            cls.setTemplateSlotDefaultValues(slot, list);
        }
    }

    public final String facetName() throws ParseException {
        String name = this.symbol();
        return name;
    }

    public final void userFacet(Cls cls, Slot slot) throws ParseException {
        ArrayList<Object> rawvalues = new ArrayList<Object>();
        this.jj_consume_token(71);
        String facetName = this.facetName();
        block3: while (true) {
            Object rawvalue = this.constant();
            rawvalues.add(rawvalue);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[17] = this.jj_gen;
        Facet facet = this.getOrCreateFacet(facetName);
        ValueType type = facet.getValueType();
        ArrayList values = new ArrayList();
        for (Object e : rawvalues) {
            this.checkedValueAdd(values, type, e);
        }
        if (cls != null) {
            cls.setTemplateFacetValues(slot, facet, values);
        }
    }

    public final void templateSlotValueFacet(Cls cls, Slot slot) throws ParseException {
        ArrayList list = new ArrayList();
        ValueType type = this.getSlotType(cls, slot);
        this.jj_consume_token(72);
        block3: while (true) {
            Object value = this.constant();
            this.checkedValueAdd(list, type, value);
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
        if (cls == null) {
            slot.setValues(list);
        } else {
            cls.setTemplateSlotValues(slot, list);
        }
    }

    public final void facet(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 34: {
                this.defaultFacet(cls, slot);
                break;
            }
            case 66: {
                this.storageFacet(cls, slot);
                break;
            }
            case 17: {
                this.accessFacet(cls, slot);
                break;
            }
            case 71: {
                this.userFacet(cls, slot);
                break;
            }
            case 54: {
                this.propagationFacet(cls, slot);
                break;
            }
            case 65: {
                this.sourceFacet(cls, slot);
                break;
            }
            case 52: {
                this.patternMatchFacet(cls, slot);
                break;
            }
            case 73: {
                this.visibilityFacet(cls, slot);
                break;
            }
            case 33: {
                this.createAccessorFacet(cls, slot);
                break;
            }
            case 51: {
                this.overrideMessageFacet(cls, slot);
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 56: 
            case 70: {
                this.constraintValueDescription(cls, slot);
                break;
            }
            case 30: {
                this.slotDocumentationFacet(cls, slot);
                break;
            }
            case 43: {
                this.inverseSlotProperty(cls, slot);
                break;
            }
            case 72: {
                this.templateSlotValueFacet(cls, slot);
                break;
            }
            case 68: {
                this.superslotProperty(cls, slot);
                break;
            }
            case 27: {
                this.associatedFacet(cls, slot);
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                this.constraintValueDescriptionExtension(cls, slot);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void facetStatement(Cls cls, Slot slot) throws ParseException {
        switch (this.jj_nt.kind) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(11);
        this.facet(cls, slot);
        this.jj_consume_token(12);
    }

    public final void includeOntologies() throws ParseException {
        ArrayList<String> list = new ArrayList<String>();
        this.jj_consume_token(15);
        this.jj_consume_token(11);
        this.jj_consume_token(38);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 77: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            String name = this.string();
            list.add(name);
        }
        this.jj_consume_token(12);
    }

    public final void instance() throws ParseException {
        ArrayList<Cls> types = new ArrayList<Cls>();
        try {
            this.jj_consume_token(11);
            String instanceName = this.instanceName();
            this.jj_consume_token(50);
            block9: while (true) {
                Cls type = this.clsReference();
                types.add(type);
                switch (this.jj_nt.kind) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 78: {
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[22] = this.jj_gen;
            Instance instance = this.getInstance(instanceName, types);
            block10: while (true) {
                switch (this.jj_nt.kind) {
                    case 11: {
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        break block10;
                    }
                }
                this.slotValue(instance, types);
            }
            this.jj_consume_token(12);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        catch (TokenMgrError e) {
            this.handleException(e);
        }
    }

    public final String instanceName() throws ParseException {
        Token t = this.jj_consume_token(76);
        String name = t.image;
        name = name.substring(1, name.length() - 1);
        name = ClipsUtil.toInternalSymbol(name);
        return name;
    }

    public final Instance instanceReference() throws ParseException {
        String name = this.instanceName();
        return this.getInstance(name, null);
    }

    public final void oldStuff() throws ParseException {
        this.jj_consume_token(15);
        this.string();
        this.jj_consume_token(15);
        this.instanceName();
    }

    public final void overrideMessageFacet(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(51);
        switch (this.jj_nt.kind) {
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 78: {
                this.symbol();
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void versionInfo() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(11);
        this.jj_consume_token(74);
        String version = this.string();
        this.jj_consume_token(12);
        this.jj_consume_token(15);
        this.jj_consume_token(11);
        this.jj_consume_token(28);
        String build = this.string();
        this.jj_consume_token(12);
        this.itsKB.setVersionString(version);
        this.itsKB.setBuildString(build);
    }

    public final void parseKnowledgeBase() throws ParseException {
        if (this.jj_2_1(3)) {
            this.oldStuff();
        }
        switch (this.jj_nt.kind) {
            case 15: {
                this.versionInfo();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block6;
                }
            }
            this.instance();
        }
        this.jj_consume_token(0);
    }

    public final void parseOntology() throws ParseException {
        if (this.jj_2_2(3)) {
            this.includeOntologies();
        }
        switch (this.jj_nt.kind) {
            case 15: {
                this.versionInfo();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 11: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block6;
                }
            }
            this.cls();
        }
        this.jj_consume_token(0);
    }

    public final void patternMatchFacet(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(52);
        switch (this.jj_nt.kind) {
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void patternMatchRole(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(11);
        this.jj_consume_token(52);
        switch (this.jj_nt.kind) {
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(12);
    }

    public final void propagationFacet(Frame frame, Slot slot) throws ParseException {
        this.jj_consume_token(54);
        switch (this.jj_nt.kind) {
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rangeValueDescription(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(56);
        String min = this.symbol();
        String max = this.symbol();
        Float minValue = this.toFloat(min);
        Float maxValue = this.toFloat(max);
        if (cls == null) {
            slot.setMinimumValue(minValue);
            slot.setMaximumValue(maxValue);
        } else {
            cls.setTemplateSlotMinimumValue(slot, minValue);
            cls.setTemplateSlotMaximumValue(slot, maxValue);
        }
    }

    public final void slot(Cls cls) throws ParseException {
        try {
            this.jj_consume_token(11);
            boolean isSingle = this.slotCardinality();
            String name = this.slotName();
            boolean isTopLevel = cls == null || !this.hasSlot(name);
            Slot slot = this.createTemplateSlot(name, isSingle, cls, isTopLevel);
            if (isTopLevel) {
                cls = null;
            }
            block5: while (true) {
                switch (this.jj_nt.kind) {
                    case 11: 
                    case 15: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block5;
                    }
                }
                this.facetStatement(cls, slot);
            }
            this.jj_consume_token(12);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public final boolean slotCardinality() throws ParseException {
        boolean single = true;
        switch (this.jj_nt.kind) {
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                single = false;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return single;
    }

    public final void slotDocumentationFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(30);
        String s = this.string();
        if (cls == null) {
            slot.setDocumentation(s);
        } else {
            cls.setTemplateSlotDocumentation(slot, s);
        }
    }

    public final void inverseSlotProperty(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(43);
        String s = this.slotName();
        Slot inverseSlot = this.getSlot(s);
        this.addInverseSlotPair(slot, inverseSlot);
    }

    public final void superslotProperty(Cls cls, Slot slot) throws ParseException {
        ArrayList<String> superslots = new ArrayList<String>();
        this.jj_consume_token(68);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block3;
                }
            }
            String s = this.slotName();
            superslots.add(s);
        }
        this.addSuperslots(slot, superslots);
    }

    public final void associatedFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(27);
        String facetName = this.facetName();
        Facet facet = this.getOrCreateFacet(facetName);
        slot.setAssociatedFacet(facet);
        facet.setAssociatedSlot(slot);
    }

    public final String slotName() throws ParseException {
        String s = this.symbol();
        if (s.equals("name_")) {
            s = "name";
        } else if (s.equals("is-a_")) {
            s = "is-a";
        } else if (s.charAt(0) == ':' && (s.equals(":domain-value") || s.equals(":range-value") || s.equals(":entry-slot") || s.equals(":domain-value-slots") || s.equals(":range-value-slots"))) {
            s = s.substring(1, s.length());
        }
        return s;
    }

    public final void slotValue(Instance instance, Collection directTypes) throws ParseException {
        this.jj_consume_token(11);
        String name = this.slotName();
        Slot slot = this.getExistingSlot(name);
        ValueType valueType = this.getOwnSlotValueType(instance, directTypes, slot);
        Collection values = this.slotValueFields(instance, slot, valueType);
        this.jj_consume_token(12);
        if (slot == null) {
            this.recordError("value for unknown slot: " + name + " in instance " + instance);
        } else {
            instance.setOwnSlotValues(slot, values);
        }
    }

    public final Collection slotValueFields(Instance instance, Slot slot, ValueType type) throws ParseException {
        ArrayList values = new ArrayList();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                    break block3;
                }
            }
            Object value = this.constant();
            this.checkedValueAdd(values, type, value);
        }
        return values;
    }

    public final void slotValueFieldProperty() throws ParseException {
        this.jj_consume_token(11);
        this.symbol();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                    break block3;
                }
            }
            this.constant();
        }
        this.jj_consume_token(12);
    }

    public final void sourceFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(65);
        switch (this.jj_nt.kind) {
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void storageFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(66);
        switch (this.jj_nt.kind) {
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String string() throws ParseException {
        Token t = this.jj_consume_token(77);
        return ClipsUtil.toInternalString(t.image);
    }

    public final String symbol() throws ParseException {
        String s;
        switch (this.jj_nt.kind) {
            case 78: {
                Token t = this.jj_consume_token(78);
                s = t.image;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                s = this.keyword();
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ClipsUtil.toInternalSymbol(s);
    }

    public final void typeValueDescription(Cls cls, Slot slot) throws ParseException {
        ValueType type;
        this.jj_consume_token(70);
        switch (this.jj_nt.kind) {
            case 37: {
                this.jj_consume_token(37);
                type = ValueType.FLOAT;
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                type = ValueType.INSTANCE;
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                type = ValueType.INTEGER;
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                type = ValueType.STRING;
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                type = ValueType.SYMBOL;
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                type = ValueType.ANY;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (cls == null) {
            if (slot.getValueType() != type) {
                slot.setValueType(type);
            }
        } else if (cls.getTemplateSlotValueType(slot) != type) {
            cls.setTemplateSlotValueType(slot, type);
        }
    }

    public final void visibilityFacet(Cls cls, Slot slot) throws ParseException {
        this.jj_consume_token(73);
        switch (this.jj_nt.kind) {
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String keyword() throws ParseException {
        Token t;
        switch (this.jj_nt.kind) {
            case 16: {
                t = this.jj_consume_token(16);
                break;
            }
            case 17: {
                t = this.jj_consume_token(17);
                break;
            }
            case 27: {
                t = this.jj_consume_token(27);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 20: {
                t = this.jj_consume_token(20);
                break;
            }
            case 22: {
                t = this.jj_consume_token(22);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            case 23: {
                t = this.jj_consume_token(23);
                break;
            }
            case 24: {
                t = this.jj_consume_token(24);
                break;
            }
            case 25: {
                t = this.jj_consume_token(25);
                break;
            }
            case 26: {
                t = this.jj_consume_token(26);
                break;
            }
            case 28: {
                t = this.jj_consume_token(28);
                break;
            }
            case 29: {
                t = this.jj_consume_token(29);
                break;
            }
            case 30: {
                t = this.jj_consume_token(30);
                break;
            }
            case 31: {
                t = this.jj_consume_token(31);
                break;
            }
            case 32: {
                t = this.jj_consume_token(32);
                break;
            }
            case 33: {
                t = this.jj_consume_token(33);
                break;
            }
            case 34: {
                t = this.jj_consume_token(34);
                break;
            }
            case 35: {
                t = this.jj_consume_token(35);
                break;
            }
            case 36: {
                t = this.jj_consume_token(36);
                break;
            }
            case 37: {
                t = this.jj_consume_token(37);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 41: {
                t = this.jj_consume_token(41);
                break;
            }
            case 42: {
                t = this.jj_consume_token(42);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                break;
            }
            case 44: {
                t = this.jj_consume_token(44);
                break;
            }
            case 45: {
                t = this.jj_consume_token(45);
                break;
            }
            case 46: {
                t = this.jj_consume_token(46);
                break;
            }
            case 47: {
                t = this.jj_consume_token(47);
                break;
            }
            case 48: {
                t = this.jj_consume_token(48);
                break;
            }
            case 49: {
                t = this.jj_consume_token(49);
                break;
            }
            case 50: {
                t = this.jj_consume_token(50);
                break;
            }
            case 51: {
                t = this.jj_consume_token(51);
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                break;
            }
            case 53: {
                t = this.jj_consume_token(53);
                break;
            }
            case 54: {
                t = this.jj_consume_token(54);
                break;
            }
            case 55: {
                t = this.jj_consume_token(55);
                break;
            }
            case 56: {
                t = this.jj_consume_token(56);
                break;
            }
            case 57: {
                t = this.jj_consume_token(57);
                break;
            }
            case 58: {
                t = this.jj_consume_token(58);
                break;
            }
            case 59: {
                t = this.jj_consume_token(59);
                break;
            }
            case 60: {
                t = this.jj_consume_token(60);
                break;
            }
            case 61: {
                t = this.jj_consume_token(61);
                break;
            }
            case 62: {
                t = this.jj_consume_token(62);
                break;
            }
            case 63: {
                t = this.jj_consume_token(63);
                break;
            }
            case 64: {
                t = this.jj_consume_token(64);
                break;
            }
            case 65: {
                t = this.jj_consume_token(65);
                break;
            }
            case 66: {
                t = this.jj_consume_token(66);
                break;
            }
            case 67: {
                t = this.jj_consume_token(67);
                break;
            }
            case 68: {
                t = this.jj_consume_token(68);
                break;
            }
            case 69: {
                t = this.jj_consume_token(69);
                break;
            }
            case 70: {
                t = this.jj_consume_token(70);
                break;
            }
            case 71: {
                t = this.jj_consume_token(71);
                break;
            }
            case 72: {
                t = this.jj_consume_token(72);
                break;
            }
            case 74: {
                t = this.jj_consume_token(74);
                break;
            }
            case 73: {
                t = this.jj_consume_token(73);
                break;
            }
            case 75: {
                t = this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_1() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3R_21() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_20() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_3R_22()) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private boolean jj_3_2() {
        return this.jj_3R_21();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 61341696, 0x540000, -65536, 0, -65536, 0, -65536, 0, 2048, -65536, 65536, -65536, -65536, 598212608, 512, -65536, -65536, -65536, 1811808256, 32768, 0, -65536, 2048, -64512, 32768, 2048, 32768, 2048, 0, 0, 0, 34816, 0, -65536, -65536, -65536, Integer.MIN_VALUE, 0, -65536, 0x4000000, 0, -65536};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x18000100, 0, 0, -1, 0, -1, 0, -1, 0, 0, -1, 1, -1, -1, 0x1000000, 0x14000000, -1, -1, -1, 22546438, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0x2010000, 0x2010000, 32896, 0, 0x40004000, -1, -1, -1, 16, -2147475456, -1, 1568, 0xA00000, -1};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 20479, 8192, 20479, 8192, 20479, 8192, 0, 20479, 0, Short.MAX_VALUE, Short.MAX_VALUE, 64, 2048, Short.MAX_VALUE, Short.MAX_VALUE, Short.MAX_VALUE, 982, 0, 8192, 20479, 0, 20479, 0, 0, 0, 0, 0, 0, 0, 0, 1, 20479, Short.MAX_VALUE, Short.MAX_VALUE, 0, 0, 20479, 40, 0, 4095};
    }

    public Parser(InputStream stream) {
        this(stream, null);
    }

    public Parser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[81];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 43; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 81; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        Parser.jj_la1_init_0();
        Parser.jj_la1_init_1();
        Parser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = -5400813976167602532L;

        private LookaheadSuccess() {
        }
    }
}

