/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.RobustConnection;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractDatabaseFrameDb
implements DatabaseFrameDb {
    public static Logger log = Log.getLogger(AbstractDatabaseFrameDb.class);
    public static final String SLOW_QUERY_PROPERTY = "slow.jdbc.query.milliseconds";
    private static final int slowQueryTime = ApplicationProperties.getIntegerProperty("slow.jdbc.query.milliseconds", 15000);
    private static int traceCount = 0;
    protected final Map<RemoteSession, RobustConnection> _connections = new HashMap<RemoteSession, RobustConnection>();
    protected String _driver;
    protected FrameFactory _frameFactory;
    protected boolean _isInclude;
    protected String _password;
    protected String _table;
    protected String _url;
    protected String _user;
    private String frameDbName;
    private TransactionMonitor transactionMonitor;

    private static void traceUpdate(PreparedStatement stmt, Level level) {
        AbstractDatabaseFrameDb.traceUpdate(stmt, "", level);
    }

    private static void traceUpdate(PreparedStatement stmt, String append, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(stmt, append, level);
        }
    }

    private static void traceQuery(PreparedStatement stmt, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(stmt, "", level);
        }
    }

    private static void trace(PreparedStatement stmt, String append, Level level) {
        if (log.isLoggable(level)) {
            int index;
            String text = stmt.toString();
            if (text.indexOf("PreparedStatement") != -1 && (index = text.indexOf(32)) != -1) {
                text = text.substring(index);
            }
            AbstractDatabaseFrameDb.trace(text + append, level);
        }
    }

    private static void trace(String text, Level level) {
        if (log.isLoggable(level)) {
            log.log(level, ++traceCount + " SQL: " + text);
        }
    }

    private static void traceQuery(String text, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(text, level);
        }
    }

    private static void traceUpdate(String text, Level level) {
        if (log.isLoggable(level)) {
            AbstractDatabaseFrameDb.trace(text, level);
        }
    }

    protected static ResultSet executeQuery(PreparedStatement stmt) throws SQLException {
        Level traceLevel = Level.FINER;
        AbstractDatabaseFrameDb.traceQuery(stmt, traceLevel);
        long startTime = System.nanoTime();
        ResultSet ret = stmt.executeQuery();
        double t = (double)(System.nanoTime() - startTime) / 1000000.0;
        if (t > (double)slowQueryTime) {
            if (!log.isLoggable(traceLevel)) {
                AbstractDatabaseFrameDb.traceQuery(stmt, Level.INFO);
            }
            log.info("*** SLOW QUERY: " + t + " msec ***");
        } else if (log.isLoggable(traceLevel)) {
            log.log(traceLevel, "Query took " + t + " milliseconds (more or less)");
        }
        return ret;
    }

    protected static int executeUpdate(PreparedStatement stmt) throws SQLException {
        Level traceLevel = Level.FINE;
        AbstractDatabaseFrameDb.traceUpdate(stmt, traceLevel);
        long startTime = System.nanoTime();
        int ret = stmt.executeUpdate();
        double t = (double)(System.nanoTime() - startTime) / 1000000.0;
        if (t > (double)slowQueryTime) {
            if (!log.isLoggable(traceLevel)) {
                AbstractDatabaseFrameDb.traceQuery(stmt, Level.INFO);
            }
            log.info("*** SLOW QUERY: " + t + " msec ***");
        } else if (log.isLoggable(traceLevel)) {
            log.log(traceLevel, "Query took " + t + " milliseconds (more or less)");
        }
        return ret;
    }

    private static boolean isDead(RemoteSession session) {
        return session != null && !Server.getInstance().isActive(session);
    }

    protected static boolean isNullValue(Object o) {
        boolean isNull;
        boolean bl = isNull = o == null;
        if (o instanceof String) {
            String s = (String)o;
            isNull = s.trim().length() == 0;
        }
        return isNull;
    }

    public boolean beginTransaction(String name) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("begin transaction " + name);
        }
        try {
            boolean success = this.getCurrentConnection().beginTransaction();
            return success;
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private void clearDeadConnections() throws SQLException {
        Iterator<Map.Entry<RemoteSession, RobustConnection>> i = this._connections.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<RemoteSession, RobustConnection> entry = i.next();
            RemoteSession session = entry.getKey();
            if (!AbstractDatabaseFrameDb.isDead(session)) continue;
            RobustConnection connection = entry.getValue();
            connection.dispose();
            i.remove();
        }
    }

    public void close() {
        this._frameFactory = null;
        try {
            for (Map.Entry<RemoteSession, RobustConnection> entry : this._connections.entrySet()) {
                RemoteSession session = entry.getKey();
                RobustConnection connection = entry.getValue();
                connection.dispose();
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Closed DB connection for session: " + session);
            }
            this._connections.clear();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    public boolean commitTransaction() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("commit transaction");
        }
        try {
            return this.getCurrentConnection().commitTransaction();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    protected RobustConnection createConnection() throws SQLException {
        this.clearDeadConnections();
        RemoteSession currentSession = ServerFrameStore.getCurrentSession();
        RobustConnection connection = new RobustConnection(this._driver, this._url, this._user, this._password, this.getTransactionStatusMonitor(), currentSession);
        this._connections.put(currentSession, connection);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created connection for " + currentSession);
        }
        return connection;
    }

    protected RuntimeException createRuntimeException(SQLException e) {
        try {
            if (this.getCurrentConnection() != null) {
                this.getCurrentConnection().checkConnection();
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        log.info(Log.toString(e));
        RuntimeException runtimeEx = new RuntimeException(e.getMessage());
        runtimeEx.initCause(e);
        return runtimeEx;
    }

    public RobustConnection getCurrentConnection() throws SQLException {
        RemoteSession currentSession = ServerFrameStore.getCurrentSession();
        RobustConnection connection = this._connections.get(currentSession);
        if (connection == null) {
            connection = this.createConnection();
            this._connections.put(currentSession, connection);
        }
        return connection;
    }

    public FrameFactory getFrameFactory() {
        return this._frameFactory;
    }

    public String getName() {
        return this.frameDbName;
    }

    public TransactionMonitor getTransactionStatusMonitor() {
        if (this.transactionMonitor == null) {
            this.transactionMonitor = new TransactionMonitor(){

                public TransactionIsolationLevel getTransationIsolationLevel() throws TransactionException {
                    int jdbcLevel = 0;
                    RobustConnection connection = null;
                    try {
                        connection = AbstractDatabaseFrameDb.this.getCurrentConnection();
                        jdbcLevel = connection.getTransactionIsolationLevel();
                    }
                    catch (SQLException sqle) {
                        throw new TransactionException(sqle);
                    }
                    finally {
                        connection.setIdle(true);
                    }
                    return TransactionIsolationLevel.getTransactionLevel(jdbcLevel);
                }

                public void setTransactionIsolationLevel(TransactionIsolationLevel level) throws TransactionException {
                    int jdbcLevel = level.getJdbcLevel();
                    RobustConnection connection = null;
                    try {
                        connection = AbstractDatabaseFrameDb.this.getCurrentConnection();
                        if (connection != null) {
                            connection.setTransactionIsolationLevel(jdbcLevel);
                        }
                    }
                    catch (SQLException e) {
                        throw new TransactionException(e);
                    }
                    finally {
                        connection.setIdle(true);
                    }
                }
            };
        }
        return this.transactionMonitor;
    }

    public void initialize(FrameFactory factory, String driver, String url, String user, String pass, String table, boolean isInclude) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Constructing database frame narrow frame store for " + driver + " " + url + " " + table);
            log.fine("No delegates");
        }
        this._isInclude = isInclude;
        this._table = table;
        this._frameFactory = factory;
        this._driver = driver;
        this._url = url;
        this._user = user;
        this._password = pass;
        try {
            this.createConnection();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    public boolean rollbackTransaction() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("roll back transaction");
        }
        try {
            return this.getCurrentConnection().rollbackTransaction();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    public void setName(String name) {
        this.frameDbName = name;
    }

    public String getTableName() {
        return this._table;
    }

    protected ResultSet executeQuery(String text) throws SQLException {
        return this.executeQuery(text, 0);
    }

    protected ResultSet executeQuery(String text, int maxRows) throws SQLException {
        Level traceLevel = Level.FINER;
        AbstractDatabaseFrameDb.traceQuery(text, traceLevel);
        Statement statement = this.getCurrentConnection().getStatement();
        long startTime = System.nanoTime();
        ResultSet ret = statement.executeQuery(text);
        double t = (double)(System.nanoTime() - startTime) / 1000000.0;
        if (t > (double)slowQueryTime) {
            if (!log.isLoggable(traceLevel)) {
                AbstractDatabaseFrameDb.traceQuery(text, Level.INFO);
            }
            log.info("*** SLOW QUERY: " + t + " msec ***");
        } else if (log.isLoggable(traceLevel)) {
            log.log(traceLevel, "Query took " + t + " milliseconds (more or less)");
        }
        return ret;
    }

    protected int executeUpdate(String text) throws SQLException {
        Level traceLevel = Level.FINE;
        AbstractDatabaseFrameDb.traceUpdate(text, traceLevel);
        long startTime = System.nanoTime();
        int ret = this.getCurrentConnection().getStatement().executeUpdate(text);
        double t = (double)(System.nanoTime() - startTime) / 1000000.0;
        if (log.isLoggable(traceLevel)) {
            log.log(traceLevel, "Query took " + t + " milliseconds (more or less)");
        }
        return ret;
    }

    public void executeQuery(Query query, final QueryCallback callback) {
        new Thread(new Runnable(){

            public void run() {
                callback.handleError(new ProtegeError("Not implemented yet"));
            }
        }, "Vacuous Callback Results Thread");
    }
}

