/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.storage.database.DatabasePlugin;
import edu.stanford.smi.protege.storage.database.DatabaseWizardPage;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.WizardPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class DatabaseCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements DatabasePlugin {
    private String driver;
    private String table;
    private String username;
    private String password;
    private String url;

    public DatabaseCreateProjectPlugin() {
        super(DatabaseKnowledgeBaseFactory.DESCRIPTION);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean canCreateProject(KnowledgeBaseFactory factory, boolean useExistingSources) {
        return factory.getClass() == DatabaseKnowledgeBaseFactory.class;
    }

    public Project createNewProject(KnowledgeBaseFactory factory) {
        ArrayList errors = new ArrayList();
        Project project = super.createNewProject(factory);
        this.initializeSources(project.getSources());
        try {
            File tempProjectFile = File.createTempFile("protege", "temp");
            project.setProjectFilePath(tempProjectFile.getPath());
            project.save(errors);
            project = Project.loadProjectFromFile(tempProjectFile.getPath(), errors);
            this.handleErrors(errors);
            project.setProjectFilePath(null);
            tempProjectFile.delete();
        }
        catch (IOException e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return project;
    }

    protected void initializeSources(PropertyList sources) {
        DatabaseKnowledgeBaseFactory.setSources(sources, this.driver, this.url, this.table, this.username, this.password);
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard wizard, boolean useExistingSources) {
        return new DatabaseWizardPage(wizard, this);
    }
}

