/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DefaultDatabaseFrameDb;
import edu.stanford.smi.protege.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFrameDbFactory {
    private static final Logger log = Log.getLogger(DatabaseFrameDbFactory.class);

    public static DatabaseFrameDb createDatabaseFrameDb(Class<? extends DatabaseFrameDb> clz) {
        try {
            return clz.newInstance();
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, "Failed to instantiate DatabaseFrameDb", e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "Illegal access exception while creating DatabaseFrameDb", e);
            return null;
        }
    }

    public static Class<? extends DatabaseFrameDb> getFrameDbClass(String className) {
        Class dbFrameDbClass = DefaultDatabaseFrameDb.class;
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                dbFrameDbClass = clazz.asSubclass(DatabaseFrameDb.class);
            }
            catch (ClassNotFoundException e) {
                log.warning(className + " not found, using default DatabaseFrameDb");
            }
            catch (ClassCastException e) {
                log.warning(className + " does not implement DatabaseFrameDb, using default DatabaseFrameDb");
            }
        }
        return dbFrameDbClass;
    }
}

