/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory2;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDbFactory;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.storage.database.DefaultDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.IdleConnectionNarrowFrameStore;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseKnowledgeBaseFactory
implements KnowledgeBaseFactory2 {
    public static final String DESCRIPTION = Text.getProgramName() + " Database";
    private boolean owlMode = false;

    @Override
    public KnowledgeBase createKnowledgeBase(Collection errors) {
        DefaultKnowledgeBase kb = new DefaultKnowledgeBase(this);
        return kb;
    }

    public Class<? extends DatabaseFrameDb> getDatabaseFrameDbClass() {
        return DefaultDatabaseFrameDb.class;
    }

    @Override
    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String projectName, PropertyList sources) {
        return new DatabaseKnowledgeBaseSourcesEditor(projectName, sources);
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public static String getDriver(PropertyList sources) {
        return sources.getString(DatabaseProperty.DRIVER_PROPERTY.getName());
    }

    public static String getPassword(PropertyList sources) {
        return sources.getString(DatabaseProperty.PASSWORD_PROPERTY.getName());
    }

    @Override
    public String getProjectFilePath() {
        return null;
    }

    public static String getTableName(PropertyList sources) {
        return sources.getString(DatabaseProperty.TABLENAME_PROPERTY.getName());
    }

    public static String getURL(PropertyList sources) {
        return sources.getString(DatabaseProperty.URL_PROPERTY.getName());
    }

    public static String getUsername(PropertyList sources) {
        return sources.getString(DatabaseProperty.USERNAME_PROPERTY.getName());
    }

    @Override
    public void includeKnowledgeBase(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String driver = DatabaseKnowledgeBaseFactory.getDriver(sources);
        String url = DatabaseKnowledgeBaseFactory.getURL(sources);
        if (driver != null && url != null) {
            String username = DatabaseKnowledgeBaseFactory.getUsername(sources);
            String password = DatabaseKnowledgeBaseFactory.getPassword(sources);
            String tablename = DatabaseKnowledgeBaseFactory.getTableName(sources);
            this.includeKnowledgeBase(kb, driver, url, username, password, tablename, errors);
        }
    }

    @Override
    public boolean isComplete(PropertyList sources) {
        String tablename = DatabaseKnowledgeBaseFactory.getTableName(sources);
        String url = DatabaseKnowledgeBaseFactory.getURL(sources);
        String driver = DatabaseKnowledgeBaseFactory.getDriver(sources);
        return tablename != null && url != null && driver != null;
    }

    @Override
    public void loadKnowledgeBase(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String driver = DatabaseKnowledgeBaseFactory.getDriver(sources);
        String url = DatabaseKnowledgeBaseFactory.getURL(sources);
        if (driver != null && url != null) {
            String username = DatabaseKnowledgeBaseFactory.getUsername(sources);
            String password = DatabaseKnowledgeBaseFactory.getPassword(sources);
            String tablename = DatabaseKnowledgeBaseFactory.getTableName(sources);
            this.loadKnowledgeBase(kb, driver, url, username, password, tablename, errors);
        }
    }

    public void includeKnowledgeBase(KnowledgeBase kb, String driver, String url, String user, String password, String table, Collection errors) {
        try {
            this.initializeKB(kb, driver, url, user, password, table, true);
        }
        catch (Exception e) {
            String message = "Unable to load included knowledgebase " + url;
            Log.getLogger().log(Level.WARNING, message, e);
            errors.add(new MessageError(e, message));
        }
    }

    private static MergingNarrowFrameStore getMergingFrameStore(DefaultKnowledgeBase kb) {
        return MergingNarrowFrameStore.get(kb);
    }

    public void loadKnowledgeBase(KnowledgeBase kb, String driver, String url, String user, String password, String table, Collection errors) {
        try {
            this.initializeKB(kb, driver, url, user, password, table, false);
        }
        catch (Exception e) {
            String message = "Unable to load knowledgebase " + url;
            Log.getLogger().log(Level.WARNING, message, e);
            errors.add(new MessageError(e, message));
        }
    }

    @Override
    public void saveKnowledgeBase(KnowledgeBase kb, PropertyList sources, Collection errors) {
        if (kb instanceof DefaultKnowledgeBase) {
            DatabaseFrameDb databaseFrameDb = DatabaseKnowledgeBaseFactory.getDatabaseFrameDb(kb);
            if (databaseFrameDb == null) {
                this.copyKnowledgeBase(kb, sources, errors);
            } else if (!databaseFrameDb.getTableName().equals(DatabaseKnowledgeBaseFactory.getTableName(sources))) {
                this.copyKnowledgeBase(kb, sources, errors);
            }
        } else {
            this.copyKnowledgeBase(kb, sources, errors);
        }
    }

    protected static DatabaseFrameDb getDatabaseFrameDb(KnowledgeBase kb) {
        NarrowFrameStore nfs = MergingNarrowFrameStore.get(kb);
        while ((nfs = nfs.getDelegate()) != null) {
            if (!(nfs instanceof DatabaseFrameDb)) continue;
            return (DatabaseFrameDb)nfs;
        }
        return null;
    }

    public static void setDriver(PropertyList sources, String driver) {
        sources.setString(DatabaseProperty.DRIVER_PROPERTY.getName(), driver);
    }

    public static void setPassword(PropertyList sources, String password) {
        sources.setString(DatabaseProperty.PASSWORD_PROPERTY.getName(), password);
    }

    public static void setTablename(PropertyList sources, String tablename) {
        sources.setString(DatabaseProperty.TABLENAME_PROPERTY.getName(), tablename);
    }

    public static void setURL(PropertyList sources, String url) {
        sources.setString(DatabaseProperty.URL_PROPERTY.getName(), url);
    }

    public static void setUsername(PropertyList sources, String username) {
        sources.setString(DatabaseProperty.USERNAME_PROPERTY.getName(), username);
    }

    public static void setSources(PropertyList sources, String driver, String url, String table, String user, String password) {
        DatabaseKnowledgeBaseFactory.setDriver(sources, driver);
        DatabaseKnowledgeBaseFactory.setURL(sources, url);
        DatabaseKnowledgeBaseFactory.setTablename(sources, table);
        DatabaseKnowledgeBaseFactory.setUsername(sources, user);
        DatabaseKnowledgeBaseFactory.setPassword(sources, password);
    }

    @Override
    public void prepareToSaveInFormat(KnowledgeBase kb, KnowledgeBaseFactory factory, Collection errors) {
    }

    @Override
    public NarrowFrameStore createNarrowFrameStore(String name) {
        DatabaseFrameDb store = DatabaseFrameDbFactory.createDatabaseFrameDb(this.getDatabaseFrameDbClass());
        ValueCachingNarrowFrameStore vcnfs = new ValueCachingNarrowFrameStore(store);
        IdleConnectionNarrowFrameStore icnfs = new IdleConnectionNarrowFrameStore(vcnfs);
        icnfs.setName(name);
        return icnfs;
    }

    protected void initializeKB(KnowledgeBase kb, String driver, String url, String user, String password, String table, boolean isInclude) {
        DefaultKnowledgeBase dkb = (DefaultKnowledgeBase)kb;
        FrameFactory factory = dkb.getFrameFactory();
        DatabaseFrameDb db = DatabaseKnowledgeBaseFactory.getDatabaseFrameDb(dkb);
        db.initialize(factory, driver, url, user, password, table, isInclude);
        kb.flushCache();
    }

    private void copyKnowledgeBase(KnowledgeBase kb, PropertyList sources, Collection errors) {
        String driver = DatabaseKnowledgeBaseFactory.getDriver(sources);
        String url = DatabaseKnowledgeBaseFactory.getURL(sources);
        String username = DatabaseKnowledgeBaseFactory.getUsername(sources);
        String password = DatabaseKnowledgeBaseFactory.getPassword(sources);
        String tablename = DatabaseKnowledgeBaseFactory.getTableName(sources);
        this.copyKnowledgeBase(kb, driver, url, username, password, tablename, errors);
    }

    private void copyKnowledgeBase(KnowledgeBase inputKb, String driver, String url, String username, String password, String tablename, Collection errors) {
        try {
            DatabaseFrameDb db = DatabaseFrameDbFactory.createDatabaseFrameDb(this.getDatabaseFrameDbClass());
            db.initialize(inputKb.getFrameFactory(), driver, url, username, password, tablename, false);
            db.overwriteKB(inputKb, true);
            db.close();
        }
        catch (Exception e) {
            String message = "Errors at copying knowledgebase " + url;
            Log.getLogger().log(Level.WARNING, message, e);
            errors.add(new MessageError(e, message));
        }
    }

    protected void setOwlMode(boolean owlMode) {
        this.owlMode = owlMode;
    }

    public boolean owlMode() {
        return this.owlMode;
    }
}

