/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.Component;
import java.awt.GridLayout;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DatabaseKnowledgeBaseSourcesEditor
extends KnowledgeBaseSourcesEditor {
    private static final long serialVersionUID = -1850928285684275958L;
    public static final String DEFAULT_TABLE_NAME = "ProtegeTable";
    private JTextField _driverComponent;
    private JTextField _urlComponent;
    private JTextField _tableNameComponent;
    private JTextField _usernameComponent;
    private JTextField _passwordComponent;

    public DatabaseKnowledgeBaseSourcesEditor(String projectURIString, PropertyList sources) {
        super(projectURIString, sources);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(5, 1));
        panel.add(this.createDriverComponent());
        panel.add(this.createURLComponent());
        panel.add(this.createTableNameComponent());
        panel.add(this.createUsernameComponent());
        panel.add(this.createPasswordComponent());
        this.add(panel);
    }

    public Component createDriverComponent() {
        this._driverComponent = ComponentFactory.createTextField();
        String text = DatabaseKnowledgeBaseFactory.getDriver(this.getSources());
        if (text == null) {
            text = DatabaseProperty.getProperty(DatabaseProperty.DRIVER_PROPERTY);
        }
        this._driverComponent.setText(text);
        return new LabeledComponent(DatabaseProperty.DRIVER_PROPERTY.getTitle(), this._driverComponent);
    }

    private Component createPasswordComponent() {
        this._passwordComponent = ComponentFactory.createPasswordField();
        String text = DatabaseKnowledgeBaseFactory.getPassword(this.getSources());
        this._passwordComponent.setText(text);
        return new LabeledComponent(DatabaseProperty.PASSWORD_PROPERTY.getTitle(), this._passwordComponent);
    }

    private Component createTableNameComponent() {
        this._tableNameComponent = ComponentFactory.createTextField();
        String text = DatabaseKnowledgeBaseFactory.getTableName(this.getSources());
        if (text == null) {
            text = this.getDefaultTableName();
        }
        this._tableNameComponent.setText(text);
        return new LabeledComponent(DatabaseProperty.TABLENAME_PROPERTY.getTitle(), this._tableNameComponent);
    }

    private Component createURLComponent() {
        this._urlComponent = ComponentFactory.createTextField();
        String text = DatabaseKnowledgeBaseFactory.getURL(this.getSources());
        if (text == null) {
            text = DatabaseProperty.getProperty(DatabaseProperty.URL_PROPERTY);
        }
        this._urlComponent.setText(text);
        return new LabeledComponent(DatabaseProperty.URL_PROPERTY.getTitle(), this._urlComponent);
    }

    private Component createUsernameComponent() {
        this._usernameComponent = ComponentFactory.createTextField();
        String text = DatabaseKnowledgeBaseFactory.getUsername(this.getSources());
        if (text == null) {
            text = DatabaseProperty.getProperty(DatabaseProperty.USERNAME_PROPERTY);
        }
        if (text == null) {
            text = SystemUtilities.getUserName();
        }
        this._usernameComponent.setText(text);
        return new LabeledComponent(DatabaseProperty.USERNAME_PROPERTY.getTitle(), this._usernameComponent);
    }

    private String getDefaultTableName() {
        String path;
        String tableName = DatabaseProperty.getProperty(DatabaseProperty.TABLENAME_PROPERTY);
        if (tableName == null && (path = this.getProjectPath()) != null) {
            tableName = FileUtilities.getBaseName(path);
        }
        if (tableName == null) {
            tableName = DatabaseProperty.TABLENAME_PROPERTY.getDefaultValue();
        }
        return tableName;
    }

    protected void onProjectURIChange(URI oldURI, URI newURI) {
    }

    public void saveContents() {
        String driver = this._driverComponent.getText();
        DatabaseKnowledgeBaseFactory.setDriver(this.getSources(), driver);
        DatabaseProperty.setProperty(DatabaseProperty.DRIVER_PROPERTY, driver);
        String url = this._urlComponent.getText();
        DatabaseKnowledgeBaseFactory.setURL(this.getSources(), url);
        DatabaseProperty.setProperty(DatabaseProperty.URL_PROPERTY, url);
        String tableName = this._tableNameComponent.getText();
        DatabaseKnowledgeBaseFactory.setTablename(this.getSources(), tableName);
        DatabaseProperty.setProperty(DatabaseProperty.TABLENAME_PROPERTY, tableName);
        String userName = this._usernameComponent.getText();
        DatabaseKnowledgeBaseFactory.setUsername(this.getSources(), userName);
        DatabaseProperty.setProperty(DatabaseProperty.USERNAME_PROPERTY, userName);
        DatabaseKnowledgeBaseFactory.setPassword(this.getSources(), this._passwordComponent.getText());
    }

    public boolean validateContents() {
        boolean isValid = true;
        String driver = this._driverComponent.getText();
        Class clas = SystemUtilities.forName(driver);
        if (clas == null) {
            isValid = false;
            String text = LocalizedText.getText(ResourceKey.DATABASE_CONFIGURE_FAILED_DIALOG_DRIVER_NOT_FOUND_TEXT);
            this.complain(text);
        } else {
            try {
                String url = this._urlComponent.getText();
                String userName = this._usernameComponent.getText();
                String password = this._passwordComponent.getText();
                Connection c = DriverManager.getConnection(url, userName, password);
                isValid = this.confirmOverwriteIfNecessary(c);
                c.close();
            }
            catch (SQLException e) {
                isValid = false;
                String text = LocalizedText.getText(ResourceKey.DATABASE_CONFIGURE_FAILED_DIALOG_CANNOT_CREATE_CONNECTION_TEXT, e.getMessage());
                this.complain(text);
            }
        }
        return isValid;
    }

    private boolean confirmOverwriteIfNecessary(Connection c) {
        boolean canCreate = true;
        String tableName = this._tableNameComponent.getText();
        if (this.newTable(tableName) && DatabaseKnowledgeBaseSourcesEditor.tableExists(c, tableName)) {
            String text = "Table already exists.  Overwrite it?";
            int rval = ModalDialog.showMessageDialog((Component)this, text, 13);
            canCreate = rval == 2;
        }
        return canCreate;
    }

    private boolean newTable(String tableName) {
        String existingTableName = DatabaseKnowledgeBaseFactory.getTableName(this.getSources());
        return !tableName.equals(existingTableName);
    }

    private static boolean tableExists(Connection connection, String tableName) {
        boolean exists = false;
        try {
            Statement statement = connection.createStatement();
            String query = "SELECT COUNT(*) FROM " + tableName;
            ResultSet rs = statement.executeQuery(query);
            rs.close();
            statement.close();
            exists = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return exists;
    }

    private void complain(String text) {
        String title = LocalizedText.getText(ResourceKey.ERROR_DIALOG_TITLE);
        ModalDialog.showMessageDialog((Component)this, text, title);
    }
}

