/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Assert;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;

public class DatabaseUtils {
    public static final String NULL_FRAME_ID_STRING = "";
    private static final int VALUE_TYPE_INTEGER = 1;
    private static final int VALUE_TYPE_FLOAT = 2;
    private static final int VALUE_TYPE_STRING = 3;
    private static final int VALUE_TYPE_BOOLEAN = 4;
    public static final int BASE_FRAME_TYPE_VALUE = 5;
    private static final char SINGLE_QUOTE = '\'';
    static boolean first = true;

    public static String getValue(FrameID id) {
        return id == null ? NULL_FRAME_ID_STRING : id.getName();
    }

    public static int getStringValueType() {
        return 3;
    }

    private static void setId(PreparedStatement stmt, int index, Frame frame) throws SQLException {
        DatabaseUtils.setId(stmt, index, DatabaseUtils.getId(frame));
    }

    private static FrameID getId(Frame frame) {
        return frame == null ? null : frame.getFrameID();
    }

    private static void setId(PreparedStatement stmt, int index, FrameID id) throws SQLException {
        stmt.setString(index, DatabaseUtils.getValue(id));
    }

    private static String getFrameIDValueString(FrameID id) {
        return id == null ? NULL_FRAME_ID_STRING : id.getName();
    }

    public static void setValueType(PreparedStatement stmt, int index, Object o, FrameFactory factory) throws SQLException {
        DatabaseUtils.setValueType(stmt, index, DatabaseUtils.valueType(o, factory));
    }

    public static void setValueType(PreparedStatement stmt, int index, int type) throws SQLException {
        stmt.setInt(index, (short)type);
    }

    public static int valueType(Object value, FrameFactory factory) {
        int type = value instanceof String ? 3 : (value instanceof Integer ? 1 : (value instanceof Float ? 2 : (value instanceof Boolean ? 4 : factory.getJavaClassId((Frame)value))));
        return type;
    }

    public static void setFrameId(PreparedStatement stmt, int index, FrameID frameId) throws SQLException {
        DatabaseUtils.setId(stmt, index, frameId);
    }

    public static void setFrame(PreparedStatement stmt, int index, Frame frame) throws SQLException {
        DatabaseUtils.setId(stmt, index, frame);
    }

    public static void setFrame(PreparedStatement stmt, int frameIndex, int typeIndex, Frame frame, FrameFactory factory) throws SQLException {
        DatabaseUtils.setId(stmt, frameIndex, frame);
        DatabaseUtils.setValueType(stmt, typeIndex, frame, factory);
    }

    public static void setSlot(PreparedStatement stmt, int index, Slot slot) throws SQLException {
        DatabaseUtils.setId(stmt, index, slot);
    }

    public static void setFacet(PreparedStatement stmt, int index, Facet facet) throws SQLException {
        DatabaseUtils.setId(stmt, index, facet);
    }

    public static void setIsTemplate(PreparedStatement stmt, int index, boolean isTemplate) throws SQLException {
        stmt.setBoolean(index, isTemplate);
    }

    public static int getIsTemplateValue(boolean isTemplate) {
        return isTemplate ? 1 : 0;
    }

    public static void setValueIndex(PreparedStatement stmt, int index, int valueIndex) throws SQLException {
        stmt.setInt(index, valueIndex);
    }

    public static void setShortValue(PreparedStatement stmt, int valueIndex, int valueTypeIndex, Object object, FrameFactory factory) throws SQLException {
        stmt.setString(valueIndex, DatabaseUtils.toString(object));
        DatabaseUtils.setValueType(stmt, valueTypeIndex, object, factory);
    }

    private static String toString(Object o) {
        Assert.assertNotNull("object", o);
        String s = o instanceof Frame ? DatabaseUtils.getFrameIDValueString(((Frame)o).getFrameID()) : o.toString();
        return s;
    }

    public static void setShortMatchValue(PreparedStatement stmt, int valueIndex, int valueTypeIndex, String value, char escapeChar) throws SQLException {
        stmt.setString(valueIndex, DatabaseUtils.getMatchString(value, escapeChar));
        DatabaseUtils.setValueType(stmt, valueTypeIndex, 3);
    }

    private static void setNullShortValue(PreparedStatement stmt, int valueIndex, int valueTypeIndex) throws SQLException {
        if (DatabaseUtils.isJdbcOdbcBridge(stmt)) {
            stmt.setString(valueIndex, NULL_FRAME_ID_STRING);
        } else {
            stmt.setNull(valueIndex, 12);
        }
        DatabaseUtils.setValueType(stmt, valueTypeIndex, 3);
    }

    private static boolean isJdbcOdbcBridge(Statement stmt) {
        return stmt.getClass().getName().startsWith("sun.jdbc.odbc.JdbcOdbcPreparedStatement");
    }

    public static void setLongValue(PreparedStatement stmt, int valueIndex, Object object) throws SQLException {
        stmt.setString(valueIndex, DatabaseUtils.toString(object));
    }

    public static void setNullLongValue(PreparedStatement stmt, int index) throws SQLException {
        stmt.setNull(index, -1);
    }

    public static void setValue(PreparedStatement stmt, int shortValueIndex, int longValueIndex, int valueTypeIndex, Object o, int sizeLimit, FrameFactory factory) throws SQLException {
        if (DatabaseUtils.isShortValue(o, sizeLimit)) {
            DatabaseUtils.setShortValue(stmt, shortValueIndex, valueTypeIndex, o, factory);
            DatabaseUtils.setNullLongValue(stmt, longValueIndex);
        } else {
            DatabaseUtils.setNullShortValue(stmt, shortValueIndex, valueTypeIndex);
            DatabaseUtils.setLongValue(stmt, longValueIndex, o);
        }
    }

    public static String getMatchString(String input, char escapeChar) {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            c = Character.toUpperCase(c);
            if (escapeChar != '\u0000' && (c == '%' || c == '_' || c == escapeChar)) {
                output.append(escapeChar);
                output.append(c);
                continue;
            }
            if (c == '\'') {
                output.append('\'');
                output.append('\'');
                continue;
            }
            if (c == '*') {
                output.append('%');
                continue;
            }
            output.append(Character.toLowerCase(c));
        }
        return output.toString();
    }

    private static boolean isShortValue(Object o, int sizeLimit) {
        boolean isShortValue = o instanceof String ? ((String)o).length() <= sizeLimit : true;
        return isShortValue;
    }

    public static Frame getFrame(ResultSet rs, int frameIndex, int typeIndex, FrameFactory factory, boolean isInclude) throws SQLException {
        FrameID id = DatabaseUtils.getFrameId(rs, frameIndex);
        int type = rs.getInt(typeIndex);
        return DatabaseUtils.getFrame(id, type, factory, isInclude);
    }

    private static Frame getFrame(FrameID id, int type, FrameFactory factory, boolean isInclude) {
        if (id == null) {
            return null;
        }
        Frame frame = factory.createFrameFromClassId(type, id);
        if (isInclude) {
            frame.setIncluded(true);
        }
        return frame;
    }

    private static FrameID getFrameId(ResultSet rs, int index) throws SQLException {
        String value = rs.getString(index);
        if (value.equals(NULL_FRAME_ID_STRING)) {
            return null;
        }
        return new FrameID(value);
    }

    public static Slot getSlot(ResultSet rs, int index, FrameFactory factory, boolean isInclude) throws SQLException {
        List types = Collections.EMPTY_LIST;
        FrameID id = DatabaseUtils.getFrameId(rs, index);
        Slot slot = factory.createSlot(id, types);
        if (isInclude) {
            slot.setIncluded(isInclude);
        }
        return slot;
    }

    public static Facet getFacet(ResultSet rs, int index, FrameFactory factory, boolean isInclude) throws SQLException {
        Facet facet;
        List types = Collections.EMPTY_LIST;
        FrameID id = DatabaseUtils.getFrameId(rs, index);
        if (id == null) {
            facet = null;
        } else {
            facet = factory.createFacet(id, types);
            if (isInclude) {
                facet.setIncluded(true);
            }
        }
        return facet;
    }

    public static Object getShortValue(ResultSet rs, int valueIndex, int valueTypeIndex, FrameFactory factory, int projectId, boolean isInclude) throws SQLException {
        Object value;
        byte type = rs.getByte(valueTypeIndex);
        String valueString = rs.getString(valueIndex);
        switch (type) {
            case 1: {
                value = Integer.valueOf(valueString);
                break;
            }
            case 2: {
                value = Float.valueOf(valueString);
                break;
            }
            case 4: {
                value = Boolean.valueOf(valueString);
                break;
            }
            case 3: {
                value = valueString;
                if (valueString == null || valueString.length() != 0) break;
                value = null;
                break;
            }
            default: {
                FrameID id = new FrameID(valueString);
                value = DatabaseUtils.getFrame(id, type, factory, isInclude);
            }
        }
        return value;
    }

    public static Object getLongValue(ResultSet rs, int valueIndex) throws SQLException {
        return rs.getString(valueIndex);
    }

    public static int getIndex(ResultSet rs, int index) throws SQLException {
        return rs.getInt(index);
    }

    public static boolean getIsTemplate(ResultSet rs, int index) throws SQLException {
        return rs.getBoolean(index);
    }

    public static void setFrameType(PreparedStatement stmt, int index, int type) throws SQLException {
        DatabaseUtils.setValueType(stmt, index, type);
    }
}

