/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.storage.database.DatabasePlugin;
import edu.stanford.smi.protege.storage.database.DatabaseProperty;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DatabaseWizardPage
extends WizardPage {
    private static final long serialVersionUID = -6619215858750011057L;
    private Map<DatabaseProperty, JTextField> fields = new EnumMap<DatabaseProperty, JTextField>(DatabaseProperty.class);
    private JTextArea errorArea;
    private DatabasePlugin plugin;

    public DatabaseWizardPage(Wizard wizard, DatabasePlugin plugin) {
        super("datbase", wizard);
        this.plugin = plugin;
        this.createComponents();
        this.layoutComponents();
        this.updateSetPageComplete();
    }

    private void createComponents() {
        for (DatabaseProperty property : DatabaseProperty.values()) {
            if (property == DatabaseProperty.PASSWORD_PROPERTY) {
                this.fields.put(property, this.createPasswordTextField());
                continue;
            }
            this.fields.put(property, this.createTextField(property));
        }
        this.errorArea = ComponentFactory.createTextArea();
        this.errorArea.setEditable(false);
    }

    private JTextField createTextField(final DatabaseProperty property) {
        String value = DatabaseProperty.getProperty(property);
        final JTextField field = ComponentFactory.createTextField(value);
        field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                DatabaseWizardPage.this.updateSetPageComplete();
                DatabaseProperty.setProperty(property, field.getText());
            }
        });
        return field;
    }

    private JTextField createPasswordTextField() {
        JPasswordField field = ComponentFactory.createPasswordField();
        field.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                DatabaseWizardPage.this.updateSetPageComplete();
            }
        });
        return field;
    }

    protected void updateSetPageComplete() {
        this.setErrorText(null);
        this.setPageComplete(this.isComplete());
    }

    protected boolean isComplete() {
        return this.hasValidDriver() && this.hasValidUrl() && this.hasValidTable();
    }

    private boolean hasValidDriver() {
        boolean isValid = false;
        String text = this.getFieldText(DatabaseProperty.DRIVER_PROPERTY);
        if ((text = text.trim()).length() == 0) {
            this.setErrorText("Driver class required");
        } else {
            Class clas = SystemUtilities.forName(text);
            boolean bl = isValid = clas != null;
            if (clas == null) {
                this.setErrorText("Driver class not found");
            }
        }
        return isValid;
    }

    private boolean hasValidUrl() {
        boolean isValid = false;
        String url = this.getFieldText(DatabaseProperty.URL_PROPERTY);
        url = url.trim();
        String username = this.getFieldText(DatabaseProperty.USERNAME_PROPERTY);
        String password = this.getFieldText(DatabaseProperty.PASSWORD_PROPERTY);
        if (url.length() == 0) {
            this.setErrorText("URL is required");
        } else if (username.length() == 0) {
            this.setErrorText("Username is required");
        } else {
            try {
                Connection c = DriverManager.getConnection(url, username, password);
                c.close();
                isValid = true;
            }
            catch (SQLException e) {
                this.setErrorText("Invalid URL, username, or password:\n" + e.getMessage());
            }
        }
        return isValid;
    }

    private boolean hasValidTable() {
        boolean isValid = false;
        String text = this.getFieldText(DatabaseProperty.TABLENAME_PROPERTY);
        if (text.length() == 0) {
            this.setErrorText("Table name is required.");
        } else {
            isValid = true;
        }
        return isValid;
    }

    protected void setErrorText(String text) {
        this.errorArea.setText(text);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        Box panel = Box.createVerticalBox();
        this.layoutComponents(panel);
    }

    protected void layoutComponents(Box panel) {
        for (DatabaseProperty property : DatabaseProperty.values()) {
            this.addField(panel, property);
        }
        this.errorArea.setPreferredSize(new Dimension(10, 50));
        this.errorArea.setBackground(this.getBackground());
        panel.add(Box.createVerticalStrut(20));
        panel.add(ComponentFactory.createScrollPane(this.errorArea));
        this.add((Component)panel, "North");
    }

    private void addField(Box panel, DatabaseProperty property) {
        panel.add(new LabeledComponent(property.getTitle(), this.fields.get((Object)property)));
    }

    public void onFinish() {
        this.plugin.setDriver(this.getFieldText(DatabaseProperty.DRIVER_PROPERTY));
        this.plugin.setTable(this.getFieldText(DatabaseProperty.TABLENAME_PROPERTY));
        this.plugin.setUsername(this.getFieldText(DatabaseProperty.USERNAME_PROPERTY));
        this.plugin.setPassword(this.getFieldText(DatabaseProperty.PASSWORD_PROPERTY));
        this.plugin.setURL(this.getFieldText(DatabaseProperty.URL_PROPERTY));
    }

    protected String getFieldText(DatabaseProperty property) {
        return this.fields.get((Object)property).getText();
    }
}

