/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.storage.database.AbstractDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseUtils;
import edu.stanford.smi.protege.util.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDatabaseFrameDb
extends AbstractDatabaseFrameDb {
    private static final String FRAME_COLUMN = "frame";
    private static final String FRAME_TYPE_COLUMN = "frame_type";
    private static final String SLOT_COLUMN = "slot";
    private static final String FACET_COLUMN = "facet";
    private static final String IS_TEMPLATE_COLUMN = "is_template";
    private static final String VALUE_INDEX_COLUMN = "value_index";
    private static final String VALUE_TYPE_COLUMN = "value_type";
    private static final String SHORT_VALUE_COLUMN = "short_value";
    private static final String LONG_VALUE_COLUMN = "long_value";
    private static boolean _isModifiable = true;
    private static int lastReturnedFrameID;
    private String _referencesText;
    private String _matchingReferencesText;
    private String _removeValueText;
    private String _removeValuesText;
    private String _addValuesText;
    private String _maxIndexText;
    private String _framesText;
    private String _framesWithAnyValueText;
    private String _valuesText;
    private String _valuesCountText;
    private String _frameValuesText;
    private String _allFrameValuesText;
    private String _longValueText;
    private PreparedStatement _addValuesBatchStmt;
    private int _addValuesBatchCounter;
    private static final int MAX_BATCH = 1000;
    private static final Map slotToFacetsCacheMap;
    private static final int LOOP_SIZE = 1000;
    private int loopcount;
    private int nFrames;
    private long previousTime;
    private String replaceFrameTypeCommand;
    private String _matchingFramesCommandForSwizzle;
    private String _updateValueTypeCommandForSwizzle;
    private String _countFramesText;
    private String _getFramesText;
    private String _getFrameFromIdText;
    private String _updateFrameFieldText;
    private String _updateSlotFieldText;
    private String _updateFacetFieldText;
    private String _replaceNameText;
    private String _matchingFramesCommandForRename;
    private String _updateValueFieldTextForRename;

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        throw new UnsupportedOperationException();
    }

    public String getTable() {
        return this._table;
    }

    public static void setModifiable(boolean modifiable) {
        _isModifiable = modifiable;
    }

    public void ensureEmptyTableExists() throws SQLException {
        this.dropTableIfItExists();
        this.createTable();
    }

    private void dropTableIfItExists() {
        try {
            this.getCurrentConnection().closeStatements();
            String command = "DROP TABLE " + this._table;
            this.executeUpdate(command);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTable() throws SQLException {
        String createTableString = "CREATE TABLE " + this._table + " (";
        createTableString = createTableString + "frame " + this.getFrameDataType() + " NOT NULL, ";
        createTableString = createTableString + "frame_type " + this.getFrameTypeDataType() + " NOT NULL, ";
        createTableString = createTableString + "slot " + this.getFrameDataType() + " NOT NULL, ";
        createTableString = createTableString + "facet " + this.getFrameDataType() + " NOT NULL, ";
        createTableString = createTableString + "is_template " + this.getIsTemplateDataType() + " NOT NULL, ";
        createTableString = createTableString + "value_index " + this.getValueIndexDataType() + " NOT NULL, ";
        createTableString = createTableString + "value_type " + this.getFrameTypeDataType() + " NOT NULL, ";
        createTableString = createTableString + "short_value " + this.getShortValueDataType() + ", ";
        createTableString = createTableString + "long_value " + this.getLongValueDataType();
        createTableString = createTableString + ")";
        if (this.checkMySQLBug()) {
            createTableString = createTableString + " ENGINE = INNODB DEFAULT CHARACTER SET 'utf8'";
        }
        try {
            this.executeUpdate(createTableString);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Created table with command '" + createTableString + "'");
            }
            this.createIndices();
        }
        catch (SQLException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Failed to create table on database ");
            buffer.append(this.getCurrentConnection().getDatabaseProductName());
            buffer.append(" with command '");
            buffer.append(createTableString);
            buffer.append("' :");
            buffer.append(e.getMessage());
            Log.getLogger().warning(buffer.toString());
            throw e;
        }
    }

    private String getFrameDataType() throws SQLException {
        String dtype = this.getCurrentConnection().getFrameNameType();
        return dtype;
    }

    private String getFrameTypeDataType() throws SQLException {
        return this.getCurrentConnection().getSmallIntTypeName();
    }

    private String getIsTemplateDataType() throws SQLException {
        return this.getCurrentConnection().getBitTypeName();
    }

    private String getValueIndexDataType() throws SQLException {
        return this.getCurrentConnection().getIntegerTypeName();
    }

    private String getShortValueDataType() throws SQLException {
        return this.getCurrentConnection().getShortValueType();
    }

    private String getLongValueDataType() throws SQLException {
        return this.getCurrentConnection().getLongvarcharTypeName();
    }

    public boolean checkMySQLBug() {
        try {
            if (this.getCurrentConnection().isMySql() && this.getCurrentConnection().getDatabaseMajorVersion() == 5) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Found mysql 5.0 - correcting for mysql bug 16121.");
                }
                return true;
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Exception caught checking database version", e);
            Log.getLogger().warning("Unable to check database version with this jdbc driver");
            Log.getLogger().warning("If this database is mysql 5 then protege will perform incorrectly");
        }
        return false;
    }

    private void createIndices() throws SQLException {
        log.info("Creating database indicies:");
        LapTimer timer = new LapTimer();
        String indexString = "CREATE INDEX " + this._table + "_I1 ON " + this._table;
        indexString = indexString + " (frame, slot, facet, is_template, value_index)";
        this.executeUpdate(indexString);
        if (log.isLoggable(Level.FINE)) {
            log.fine("\t..._I1 created (" + timer.lap() / 1000L + "s).");
        }
        indexString = "CREATE INDEX " + this._table + "_I2 ON " + this._table;
        indexString = indexString + " (short_value)";
        this.executeUpdate(indexString);
        if (log.isLoggable(Level.FINE)) {
            log.fine("\t..._I2 created (" + timer.lap() / 1000L + "s).");
        }
        indexString = "CREATE INDEX " + this._table + "_I4 ON " + this._table;
        indexString = indexString + " (slot, frame_type)";
        this.executeUpdate(indexString);
        if (log.isLoggable(Level.FINE)) {
            log.fine("\t..._I4 created (" + timer.lap() / 1000L + "s).");
        }
        if (this.needsIndexOnLowerValue()) {
            log.info("\t..._I3 created (" + timer.lap() / 1000L + "s).");
            this.createIndexOnLowerValue();
            if (log.isLoggable(Level.FINE)) {
                log.fine("\t..._IV created (" + timer.lap() / 1000L + "s).");
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.info("\t..._I3 created (" + timer.lap() / 1000L + "s).");
        }
        log.info("All database indexes created (" + timer.total() / 1000L + "s).");
    }

    private boolean needsIndexOnLowerValue() throws SQLException {
        return !this.getCurrentConnection().supportsCaseInsensitiveMatches() && this.getCurrentConnection().supportsIndexOnFunction();
    }

    private void createIndexOnLowerValue() throws SQLException {
        String indexString = "CREATE INDEX " + this._table + "_IV ON " + this._table + "(LOWER(" + SHORT_VALUE_COLUMN + "))";
        this.executeUpdate(indexString);
    }

    @Override
    public void deleteFrame(Frame frame) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.deleteFrameSQL(frame);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private void deleteFrameSQL(Frame frame) throws SQLException {
        String deleteFrameText = "DELETE FROM " + this._table + " WHERE " + FRAME_COLUMN + " = ?";
        PreparedStatement deleteFrameStmt = this.getCurrentConnection().getPreparedStatement(deleteFrameText);
        DefaultDatabaseFrameDb.setFrame(deleteFrameStmt, 1, frame);
        DefaultDatabaseFrameDb.executeUpdate(deleteFrameStmt);
        String deleteValueText = "DELETE FROM " + this._table;
        deleteValueText = deleteValueText + " WHERE short_value = ? AND value_type = ?";
        PreparedStatement deleteValueStmt = this.getCurrentConnection().getPreparedStatement(deleteValueText);
        this.setShortValue(deleteValueStmt, 1, 2, frame);
        DefaultDatabaseFrameDb.executeUpdate(deleteValueStmt);
        if (frame instanceof Slot) {
            String text = "DELETE FROM " + this._table + " WHERE " + SLOT_COLUMN + " = ?";
            PreparedStatement deleteSlotStmt = this.getCurrentConnection().getPreparedStatement(text);
            DefaultDatabaseFrameDb.setFrame(deleteSlotStmt, 1, frame);
            DefaultDatabaseFrameDb.executeUpdate(deleteSlotStmt);
        } else if (frame instanceof Facet) {
            String text = "DELETE FROM " + this._table + " WHERE " + FACET_COLUMN + " = ?";
            PreparedStatement deleteFacetStmt = this.getCurrentConnection().getPreparedStatement(text);
            DefaultDatabaseFrameDb.setFrame(deleteFacetStmt, 1, frame);
            DefaultDatabaseFrameDb.executeUpdate(deleteFacetStmt);
        }
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        try {
            return this.getReferencesSQL(value);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Reference> getReferencesSQL(Object value) throws SQLException {
        if (this._referencesText == null) {
            this._referencesText = "SELECT short_value, frame, frame_type, slot, facet, is_template";
            this._referencesText = this._referencesText + " FROM " + this._table;
            this._referencesText = this._referencesText + " WHERE short_value = ?";
            this._referencesText = this._referencesText + " AND value_type = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._referencesText);
        this.setShortValue(stmt, 1, 2, value);
        HashSet<Reference> references = new HashSet<Reference>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                boolean realMatch = true;
                if (value instanceof String) {
                    String returnedValue = rs.getString(1);
                    realMatch = value.toString().equals(returnedValue);
                }
                if (!realMatch) continue;
                Frame frame = this.getFrame(rs, 2, 3);
                Slot slot = this.getSlot(rs, 4);
                Facet facet = this.getFacet(rs, 5);
                boolean isTemplate = DefaultDatabaseFrameDb.getIsTemplate(rs, 6);
                references.add(new ReferenceImpl(frame, slot, facet, isTemplate));
            }
        }
        finally {
            rs.close();
        }
        return references;
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        try {
            return this.getMatchingReferencesSQL(value, maxMatches);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Reference> getMatchingReferencesSQL(String value, int maxMatches) throws SQLException {
        if (this._matchingReferencesText == null) {
            this._matchingReferencesText = "SELECT frame, frame_type, slot, facet";
            this._matchingReferencesText = this._matchingReferencesText + ", is_template";
            this._matchingReferencesText = this._matchingReferencesText + " FROM " + this._table;
            this._matchingReferencesText = this._matchingReferencesText + " WHERE value_type = " + DatabaseUtils.getStringValueType();
            this._matchingReferencesText = this._matchingReferencesText + " AND " + this.getShortValueMatchColumn();
            this._matchingReferencesText = this._matchingReferencesText + " LIKE '";
        }
        String text = this._matchingReferencesText + this.getMatchString(value) + "' " + this.getEscapeClause();
        HashSet<Reference> references = new HashSet<Reference>();
        ResultSet rs = this.executeQuery(text, maxMatches);
        try {
            while (rs.next()) {
                Frame frame = this.getFrame(rs, 1, 2);
                Slot slot = this.getSlot(rs, 3);
                Facet facet = this.getFacet(rs, 4);
                boolean isTemplate = DefaultDatabaseFrameDb.getIsTemplate(rs, 5);
                references.add(new ReferenceImpl(frame, slot, facet, isTemplate));
            }
        }
        finally {
            rs.close();
        }
        return references;
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.removeValueSQL(frame, slot, facet, isTemplate, value);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private void removeValueSQL(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) throws SQLException {
        if (this._removeValueText == null) {
            this._removeValueText = "DELETE FROM " + this._table;
            this._removeValueText = this._removeValueText + " WHERE frame = ?";
            this._removeValueText = this._removeValueText + " AND slot = ?";
            this._removeValueText = this._removeValueText + " AND facet = ?";
            this._removeValueText = this._removeValueText + " AND is_template = ?";
            this._removeValueText = this._removeValueText + " AND short_value = ?";
            this._removeValueText = this._removeValueText + " AND value_type = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._removeValueText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        DefaultDatabaseFrameDb.setSlot(stmt, 2, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 4, isTemplate);
        this.setShortValue(stmt, 5, 6, value);
        DefaultDatabaseFrameDb.executeUpdate(stmt);
    }

    public void removeValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.removeValuesSQL(frame, slot, facet, isTemplate);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private void removeValuesSQL(Frame frame, Slot slot, Facet facet, boolean isTemplate) throws SQLException {
        if (this._removeValuesText == null) {
            this._removeValuesText = "DELETE FROM " + this._table;
            this._removeValuesText = this._removeValuesText + " WHERE frame = ?";
            this._removeValuesText = this._removeValuesText + " AND slot = ?";
            this._removeValuesText = this._removeValuesText + " AND facet = ?";
            this._removeValuesText = this._removeValuesText + " AND is_template = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._removeValuesText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        DefaultDatabaseFrameDb.setSlot(stmt, 2, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 4, isTemplate);
        DefaultDatabaseFrameDb.executeUpdate(stmt);
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        try {
            int index = this.getMaxIndex(frame, slot, facet, isTemplate);
            this.addValuesSQL(frame, slot, facet, isTemplate, values, index + 1);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private PreparedStatement getAddValuesStatement() throws SQLException {
        if (this._addValuesText == null) {
            this._addValuesText = "INSERT INTO " + this._table;
            this._addValuesText = this._addValuesText + " (frame, frame_type, slot, facet, is_template, ";
            this._addValuesText = this._addValuesText + "value_index, short_value, long_value, value_type)";
            this._addValuesText = this._addValuesText + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        return this.getCurrentConnection().getPreparedStatement(this._addValuesText);
    }

    private void addValuesSQL(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values, int index) throws SQLException {
        PreparedStatement stmt = this.getAddValuesStatement();
        boolean useBatch = values.size() > 1 && this.getCurrentConnection().supportsBatch();
        DefaultDatabaseFrameDb.setFrame(stmt, 1, 2, frame, this._frameFactory);
        DefaultDatabaseFrameDb.setSlot(stmt, 3, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 4, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 5, isTemplate);
        for (Object value : values) {
            if (DefaultDatabaseFrameDb.isNullValue(value)) {
                Log.getLogger().warning("Skiping null value");
                continue;
            }
            DefaultDatabaseFrameDb.setValueIndex(stmt, 6, index);
            this.setValue(stmt, 7, 8, 9, value);
            if (useBatch) {
                stmt.addBatch();
            } else {
                DefaultDatabaseFrameDb.executeUpdate(stmt);
            }
            ++index;
        }
        if (useBatch) {
            stmt.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxIndex(Frame frame, Slot slot, Facet facet, boolean isTemplate) throws SQLException {
        if (this._maxIndexText == null) {
            this._maxIndexText = "SELECT MAX(value_index)";
            this._maxIndexText = this._maxIndexText + " FROM " + this._table;
            this._maxIndexText = this._maxIndexText + " WHERE frame = ?";
            this._maxIndexText = this._maxIndexText + " AND slot = ? ";
            this._maxIndexText = this._maxIndexText + " AND facet = ? ";
            this._maxIndexText = this._maxIndexText + " AND is_template = ? ";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._maxIndexText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        DefaultDatabaseFrameDb.setSlot(stmt, 2, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 4, isTemplate);
        int index = -1;
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            if (rs.next()) {
                index = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        return index;
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int index) {
        DefaultDatabaseFrameDb.checkModifiability();
        List values = this.getValues(frame, slot, facet, isTemplate);
        Object value = values.remove(from);
        values.add(index, value);
        this.setValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        try {
            return this.getMatchingFramesSQL(slot, facet, isTemplate, value, maxMatches);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private String getShortValueMatchColumn() throws SQLException {
        String matchColumn = this.getCurrentConnection().supportsCaseInsensitiveMatches() ? SHORT_VALUE_COLUMN : "LOWER(short_value)";
        return matchColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Frame> getMatchingFramesSQL(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) throws SQLException {
        String text = "SELECT frame, frame_type, slot, facet, is_template";
        text = text + " FROM " + this._table;
        text = text + " WHERE value_type = " + DatabaseUtils.getStringValueType();
        text = text + " AND (" + this.getShortValueMatchColumn() + " LIKE '" + this.getMatchString(value) + "' " + this.getEscapeClause();
        text = text + " OR long_value LIKE '" + this.getMatchString(value) + "' " + this.getEscapeClause() + " )";
        HashSet<Frame> results = new HashSet<Frame>();
        ResultSet rs = this.executeQuery(text);
        try {
            while (rs.next()) {
                Frame frame = this.getFrame(rs, 1, 2);
                String returnedSlot = rs.getString(3);
                String returnedFacet = rs.getString(4);
                boolean returnedIsTemplate = rs.getBoolean(5);
                if (!DefaultDatabaseFrameDb.equals(returnedSlot, slot) || !DefaultDatabaseFrameDb.equals(returnedFacet, facet) || returnedIsTemplate != isTemplate) continue;
                results.add(frame);
                if (--maxMatches != 0) continue;
                break;
            }
        }
        finally {
            rs.close();
        }
        return results;
    }

    private static boolean equals(String frameIDValue, Frame frame) {
        if (frame == null) {
            return frameIDValue.equals("");
        }
        return frame.getName().equals(frameIDValue);
    }

    private String getMatchString(String value) throws SQLException {
        return DatabaseUtils.getMatchString(value, this.getCurrentConnection().getEscapeCharacter());
    }

    private String getEscapeClause() throws SQLException {
        return this.getCurrentConnection().getEscapeClause();
    }

    public Set getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        try {
            return this.getFramesSQL(slot, facet, isTemplate, value);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFramesSQL(Slot slot, Facet facet, boolean isTemplate, Object value) throws SQLException {
        if (this._framesText == null) {
            this._framesText = "SELECT short_value, frame, frame_type FROM " + this._table;
            this._framesText = this._framesText + " WHERE slot = ?";
            this._framesText = this._framesText + " AND facet = ?";
            this._framesText = this._framesText + " AND is_template = ?";
            this._framesText = this._framesText + " AND short_value = ?";
            this._framesText = this._framesText + " AND value_type = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._framesText);
        DefaultDatabaseFrameDb.setSlot(stmt, 1, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 2, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 3, isTemplate);
        this.setShortValue(stmt, 4, 5, value);
        HashSet<Frame> results = new HashSet<Frame>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                boolean isRealMatch = true;
                if (value instanceof String) {
                    String returnedValue = rs.getString(1);
                    isRealMatch = value.equals(returnedValue);
                }
                if (!isRealMatch) continue;
                Frame frame = this.getFrame(rs, 2, 3);
                results.add(frame);
            }
        }
        finally {
            rs.close();
        }
        return results;
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        try {
            return this.getFramesWithAnyValueSQL(slot, facet, isTemplate);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFramesWithAnyValueSQL(Slot slot, Facet facet, boolean isTemplate) throws SQLException {
        if (this._framesWithAnyValueText == null) {
            this._framesWithAnyValueText = "SELECT frame, frame_type FROM " + this._table;
            this._framesWithAnyValueText = this._framesWithAnyValueText + " WHERE slot = ?";
            this._framesWithAnyValueText = this._framesWithAnyValueText + " AND facet = ?";
            this._framesWithAnyValueText = this._framesWithAnyValueText + " AND is_template = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._framesWithAnyValueText);
        DefaultDatabaseFrameDb.setSlot(stmt, 1, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 2, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 3, isTemplate);
        HashSet<Frame> results = new HashSet<Frame>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                Frame frame = this.getFrame(rs, 1, 2);
                results.add(frame);
            }
        }
        finally {
            rs.close();
        }
        return results;
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        DefaultDatabaseFrameDb.checkModifiability();
        try {
            this.removeValuesSQL(frame, slot, facet, isTemplate);
            this.addValuesSQL(frame, slot, facet, isTemplate, values, 0);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        List values;
        try {
            values = this.getValuesSQL(frame, slot, facet, isTemplate);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getValuesSQL(Frame frame, Slot slot, Facet facet, boolean isTemplate) throws SQLException {
        if (this._valuesText == null) {
            this._valuesText = "SELECT short_value, value_type, value_index";
            this._valuesText = this._valuesText + " FROM " + this._table;
            this._valuesText = this._valuesText + " WHERE frame = ?";
            this._valuesText = this._valuesText + " AND slot = ?";
            this._valuesText = this._valuesText + " AND facet = ?";
            this._valuesText = this._valuesText + " AND is_template = ?";
            this._valuesText = this._valuesText + " ORDER BY value_index";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._valuesText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        DefaultDatabaseFrameDb.setSlot(stmt, 2, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 4, isTemplate);
        ArrayList<Object> values = new ArrayList<Object>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                int index;
                Object value = this.getShortValue(rs, 1, 2);
                if (value == null && (value = this.getLongValue(frame, slot, facet, isTemplate, index = DefaultDatabaseFrameDb.getIndex(rs, 3))) == null) {
                    value = "";
                }
                values.add(value);
            }
        }
        finally {
            rs.close();
        }
        return values;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        int count = 0;
        try {
            count = this.getValuesCountSQL(frame, slot, facet, isTemplate);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getValuesCountSQL(Frame frame, Slot slot, Facet facet, boolean isTemplate) throws SQLException {
        if (this._valuesCountText == null) {
            this._valuesCountText = "SELECT COUNT(*) ";
            this._valuesCountText = this._valuesCountText + " FROM " + this._table;
            this._valuesCountText = this._valuesCountText + " WHERE frame = ?";
            this._valuesCountText = this._valuesCountText + " AND slot = ?";
            this._valuesCountText = this._valuesCountText + " AND facet = ?";
            this._valuesCountText = this._valuesCountText + " AND is_template = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._valuesCountText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        DefaultDatabaseFrameDb.setSlot(stmt, 2, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 4, isTemplate);
        int count = 0;
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        return count;
    }

    public Map<Frame, Map<Sft, List>> getFrameValues() {
        try {
            return this.getFrameValuesSQL();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    @Override
    public Map<Sft, List> getFrameValues(Frame frame) {
        try {
            return this.getFrameValuesSQL(frame);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private static String getValue(FrameID id) {
        return DatabaseUtils.getValue(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Sft, List> getFrameValuesSQL(Frame frame) throws SQLException {
        if (this._frameValuesText == null) {
            this._frameValuesText = "SELECT frame, slot, ";
            this._frameValuesText = this._frameValuesText + "facet, is_template, ";
            this._frameValuesText = this._frameValuesText + "short_value, value_type, value_index";
            this._frameValuesText = this._frameValuesText + " FROM " + this._table;
            this._frameValuesText = this._frameValuesText + " WHERE frame = ?";
            this._frameValuesText = this._frameValuesText + " AND slot <> '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.DIRECT_INSTANCES) + "'";
            this._frameValuesText = this._frameValuesText + " ORDER BY frame, slot, facet, is_template, value_index";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._frameValuesText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        HashMap<Sft, List> sftToValueMap = new HashMap<Sft, List>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                int index;
                Slot slot = this.getSlot(rs, 2);
                Facet facet = this.getFacet(rs, 3);
                boolean isTemplate = DefaultDatabaseFrameDb.getIsTemplate(rs, 4);
                Object value = this.getShortValue(rs, 5, 6);
                if (value == null && (value = this.getLongValue(frame, slot, facet, isTemplate, index = DefaultDatabaseFrameDb.getIndex(rs, 7))) == null) {
                    value = "";
                }
                DefaultDatabaseFrameDb.addToMap(sftToValueMap, slot, facet, isTemplate, value);
            }
        }
        finally {
            rs.close();
        }
        return sftToValueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Frame, Map<Sft, List>> getFrameValuesSQL() throws SQLException {
        if (this._allFrameValuesText == null) {
            this._allFrameValuesText = "SELECT frame, frame_type";
            this._allFrameValuesText = this._allFrameValuesText + ", slot, facet, is_template";
            this._allFrameValuesText = this._allFrameValuesText + ", short_value, value_type, value_index";
            this._allFrameValuesText = this._allFrameValuesText + ", long_value";
            this._allFrameValuesText = this._allFrameValuesText + " FROM " + this._table;
            this._allFrameValuesText = this._allFrameValuesText + " ORDER BY slot, facet, is_template, value_index";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._allFrameValuesText);
        HashMap<Frame, Map<Sft, List>> frameToSftToValueMap = new HashMap<Frame, Map<Sft, List>>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                Frame frame = this.getFrame(rs, 1, 2);
                Slot slot = this.getSlot(rs, 3);
                Facet facet = this.getFacet(rs, 4);
                boolean isTemplate = DefaultDatabaseFrameDb.getIsTemplate(rs, 5);
                Object value = this.getShortValue(rs, 6, 7);
                if (value == null && (value = DefaultDatabaseFrameDb.getLongValue(rs, 9)) == null) {
                    value = "";
                }
                DefaultDatabaseFrameDb.addToMap(frameToSftToValueMap, frame, slot, facet, isTemplate, value);
            }
        }
        finally {
            rs.close();
        }
        return frameToSftToValueMap;
    }

    private static void addToMap(Map<Sft, List> map, Slot slot, Facet facet, boolean isTemplate, Object value) {
        Sft sft = new Sft(slot, facet, isTemplate);
        ArrayList<Object> values = map.get(sft);
        if (values == null) {
            values = new ArrayList<Object>();
            map.put(sft, values);
        }
        values.add(value);
    }

    private static void addToMap(Map<Frame, Map<Sft, List>> map, Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        Map<Sft, List> sftToValueMap = map.get(frame);
        if (sftToValueMap == null) {
            sftToValueMap = DefaultDatabaseFrameDb.createInitialMap(frame);
            map.put(frame, sftToValueMap);
        }
        DefaultDatabaseFrameDb.addToMap(sftToValueMap, slot, facet, isTemplate, value);
    }

    private static Map<Sft, List> createInitialMap(Frame frame) {
        HashMap<Sft, List> map = new HashMap<Sft, List>();
        if (frame instanceof Cls) {
            Slot directInstancesSlot = frame.getKnowledgeBase().getSystemFrames().getDirectInstancesSlot();
            map.put(new Sft(directInstancesSlot, null, false), new ArrayList());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLongValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int index) throws SQLException {
        if (this._longValueText == null) {
            this._longValueText = "SELECT long_value";
            this._longValueText = this._longValueText + " FROM " + this._table;
            this._longValueText = this._longValueText + " WHERE frame = ?";
            this._longValueText = this._longValueText + " AND slot = ?";
            this._longValueText = this._longValueText + " AND facet = ?";
            this._longValueText = this._longValueText + " AND is_template = ?";
            this._longValueText = this._longValueText + " AND value_index = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._longValueText);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        DefaultDatabaseFrameDb.setSlot(stmt, 2, slot);
        DefaultDatabaseFrameDb.setFacet(stmt, 3, facet);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 4, isTemplate);
        DefaultDatabaseFrameDb.setValueIndex(stmt, 5, index);
        Object value = null;
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            if (rs.next()) {
                value = DefaultDatabaseFrameDb.getLongValue(rs, 1);
            }
        }
        finally {
            rs.close();
        }
        return value;
    }

    private static void setFrame(PreparedStatement stmt, int index, Frame frame) throws SQLException {
        DatabaseUtils.setFrame(stmt, index, frame);
    }

    private static void setFrame(PreparedStatement stmt, int frameIndex, int valueTypeIndex, Frame frame, FrameFactory factory) throws SQLException {
        DatabaseUtils.setFrame(stmt, frameIndex, valueTypeIndex, frame, factory);
    }

    private static void setSlot(PreparedStatement stmt, int index, Slot slot) throws SQLException {
        DatabaseUtils.setSlot(stmt, index, slot);
    }

    private static void setFacet(PreparedStatement stmt, int index, Facet facet) throws SQLException {
        DatabaseUtils.setFacet(stmt, index, facet);
    }

    private static void setIsTemplate(PreparedStatement stmt, int index, boolean isTemplate) throws SQLException {
        DatabaseUtils.setIsTemplate(stmt, index, isTemplate);
    }

    private void setShortValue(PreparedStatement stmt, int valueIndex, int valueTypeIndex, Object value) throws SQLException {
        DatabaseUtils.setShortValue(stmt, valueIndex, valueTypeIndex, value, this._frameFactory);
    }

    private void setValue(PreparedStatement stmt, int shortIndex, int longIndex, int valueTypeIndex, Object value) throws SQLException {
        DatabaseUtils.setValue(stmt, shortIndex, longIndex, valueTypeIndex, value, this.getCurrentConnection().getMaxVarcharSize(), this._frameFactory);
    }

    private static void setValueIndex(PreparedStatement stmt, int index, int valueIndex) throws SQLException {
        DatabaseUtils.setValueIndex(stmt, index, valueIndex);
    }

    private Frame getFrame(ResultSet rs, int frameIndex, int typeIndex) throws SQLException {
        return DatabaseUtils.getFrame(rs, frameIndex, typeIndex, this._frameFactory, this._isInclude);
    }

    private Slot getSlot(ResultSet rs, int index) throws SQLException {
        return DatabaseUtils.getSlot(rs, index, this._frameFactory, this._isInclude);
    }

    private Facet getFacet(ResultSet rs, int index) throws SQLException {
        return DatabaseUtils.getFacet(rs, index, this._frameFactory, this._isInclude);
    }

    private static int getIndex(ResultSet rs, int index) throws SQLException {
        return DatabaseUtils.getIndex(rs, index);
    }

    private static boolean getIsTemplate(ResultSet rs, int index) throws SQLException {
        return DatabaseUtils.getIsTemplate(rs, index);
    }

    private Object getShortValue(ResultSet rs, int index, int valueTypeIndex) throws SQLException {
        return DatabaseUtils.getShortValue(rs, index, valueTypeIndex, this._frameFactory, 0, this._isInclude);
    }

    private static Object getLongValue(ResultSet rs, int index) throws SQLException {
        return DatabaseUtils.getLongValue(rs, index);
    }

    protected void beginBatch() throws SQLException {
        this._addValuesBatchStmt = this.getAddValuesStatement();
        this.getCurrentConnection().setAutoCommit(false);
        this._addValuesBatchCounter = 0;
    }

    protected void endBatch() throws SQLException {
        if (this._addValuesBatchCounter > 0) {
            this.executeBatch();
        }
        this._addValuesBatchStmt = null;
        this.getCurrentConnection().setAutoCommit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteKB(KnowledgeBase kb, boolean saveFrames) throws SQLException {
        slotToFacetsCacheMap.clear();
        try {
            this.ensureEmptyTableExists();
            boolean wasCaching = kb.setCallCachingEnabled(false);
            if (saveFrames) {
                this.beginBatch();
                this.saveFrames(kb);
                this.endBatch();
            }
            kb.setCallCachingEnabled(wasCaching);
        }
        finally {
            slotToFacetsCacheMap.clear();
        }
    }

    protected void saveFrames(KnowledgeBase kb) throws SQLException {
        this.nFrames = kb.getFrameCount();
        this.loopcount = 0;
        this.previousTime = System.currentTimeMillis();
        MergingNarrowFrameStore mnfs = MergingNarrowFrameStore.get(kb);
        NarrowFrameStore nfs = null;
        if (mnfs != null) {
            nfs = mnfs.getActiveFrameStore();
        }
        if (this.nFrames > 1000) {
            Log.getLogger().info("Getting " + this.nFrames + " frames, please be patient, " + new Date());
        }
        Collection<Frame> frames = nfs == null ? kb.getFrames() : nfs.getFrames();
        for (Frame frame : frames) {
            this.printTraceMessage();
            this.saveDirectOwnSlotValues(frame, nfs);
            if (!(frame instanceof Cls)) continue;
            Cls cls = (Cls)frame;
            this.saveDirectTemplateSlotInformation(cls, nfs);
        }
    }

    private void printTraceMessage() {
        ++this.loopcount;
        if (this.loopcount % 1000 == 0) {
            long currentTime = System.currentTimeMillis();
            long delta = (currentTime - this.previousTime) / 1000L;
            this.previousTime = currentTime;
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            String text = this.loopcount + "/" + this.nFrames;
            text = text + ", " + new Date();
            text = text + ", delta=" + delta;
            text = text + ", mem(f/t/m)=" + runtime.freeMemory() / 1000L;
            text = text + "/" + runtime.totalMemory() / 1000L;
            text = text + "/" + runtime.maxMemory() / 1000L;
            Log.getLogger().info(text);
        }
    }

    protected void saveValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) throws SQLException {
        DefaultDatabaseFrameDb.setFrame(this._addValuesBatchStmt, 1, 2, frame, this._frameFactory);
        DefaultDatabaseFrameDb.setSlot(this._addValuesBatchStmt, 3, slot);
        DefaultDatabaseFrameDb.setFacet(this._addValuesBatchStmt, 4, facet);
        DefaultDatabaseFrameDb.setIsTemplate(this._addValuesBatchStmt, 5, isTemplate);
        boolean locationIsSystem = DefaultDatabaseFrameDb.locationIsSystem(frame, slot, facet);
        int index = 0;
        for (Object value : values) {
            if (locationIsSystem && DefaultDatabaseFrameDb.valueIsSystem(value)) continue;
            DefaultDatabaseFrameDb.setValueIndex(this._addValuesBatchStmt, 6, index);
            this.setValue(this._addValuesBatchStmt, 7, 8, 9, value);
            this.addBatch();
            ++index;
        }
    }

    private static boolean locationIsSystem(Frame frame, Slot slot, Facet facet) {
        boolean isSystem;
        boolean bl = isSystem = frame.isSystem() && slot.isSystem();
        if (isSystem && facet != null) {
            isSystem = facet.isSystem();
        }
        return isSystem;
    }

    private static boolean valueIsSystem(Object value) {
        boolean valueIsSystem = true;
        if (value instanceof Frame) {
            Frame frame = (Frame)value;
            valueIsSystem = frame.isSystem();
        }
        return valueIsSystem;
    }

    private void addBatch() throws SQLException {
        this._addValuesBatchStmt.addBatch();
        ++this._addValuesBatchCounter;
        if (this._addValuesBatchCounter == 1000) {
            this.executeBatch();
        }
    }

    private void executeBatch() throws SQLException {
        this._addValuesBatchStmt.executeBatch();
        this._addValuesBatchCounter = 0;
        this.getCurrentConnection().commit();
    }

    private void saveDirectOwnSlotValues(Frame frame, NarrowFrameStore nfs) throws SQLException {
        for (Slot slot : frame.getOwnSlots()) {
            List values = nfs == null ? frame.getDirectOwnSlotValues(slot) : nfs.getValues(frame, slot, null, false);
            this.saveValues(frame, slot, null, false, values);
        }
    }

    private void saveDirectTemplateSlotInformation(Cls cls, NarrowFrameStore nfs) throws SQLException {
        for (Slot slot : cls.getTemplateSlots()) {
            List values = nfs == null ? cls.getDirectTemplateSlotValues(slot) : nfs.getValues(cls, slot, null, true);
            this.saveValues(cls, slot, null, true, values);
            this.saveDirectTemplateFacetValues(cls, slot, nfs);
        }
    }

    private void saveDirectTemplateFacetValues(Cls cls, Slot slot, NarrowFrameStore nfs) throws SQLException {
        for (Facet facet : DefaultDatabaseFrameDb.getTemplateFacets(cls, slot)) {
            List values = nfs == null ? cls.getDirectTemplateFacetValues(slot, facet) : nfs.getValues(cls, slot, facet, true);
            this.saveValues(cls, slot, facet, true, values);
        }
    }

    private static Collection getTemplateFacets(Cls cls, Slot slot) {
        Collection<Facet> facets = (Collection<Facet>)slotToFacetsCacheMap.get(slot);
        if (facets == null) {
            facets = cls.getTemplateFacets(slot);
            slotToFacetsCacheMap.put(slot, facets);
        }
        return facets;
    }

    @Override
    public boolean beginTransaction(String name) {
        DefaultDatabaseFrameDb.checkModifiability();
        return super.beginTransaction(name);
    }

    @Override
    public boolean commitTransaction() {
        DefaultDatabaseFrameDb.checkModifiability();
        return super.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        DefaultDatabaseFrameDb.checkModifiability();
        return super.rollbackTransaction();
    }

    private static void checkModifiability() {
        if (!_isModifiable) {
            throw new IllegalStateException("Database is not modifiable");
        }
    }

    @Override
    public void replaceFrame(Frame frame) {
        try {
            int newTypeId = DatabaseUtils.valueType(frame, this._frameFactory);
            this.replaceFrameTypeSQL(frame, newTypeId);
            this.replaceValueTypeSQL(frame, newTypeId);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
    }

    private void replaceFrameTypeSQL(Frame frame, int newTypeId) throws SQLException {
        if (this.replaceFrameTypeCommand == null) {
            this.replaceFrameTypeCommand = "UPDATE " + this._table + " SET " + FRAME_TYPE_COLUMN + " = ?";
            this.replaceFrameTypeCommand = this.replaceFrameTypeCommand + " WHERE frame = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this.replaceFrameTypeCommand);
        DatabaseUtils.setValueType(stmt, 1, newTypeId);
        DatabaseUtils.setFrame(stmt, 2, frame);
        DefaultDatabaseFrameDb.executeUpdate(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceValueTypeSQL(Frame frame, int newTypeId) throws SQLException {
        if (this._matchingFramesCommandForSwizzle == null) {
            this._matchingFramesCommandForSwizzle = "SELECT frame, slot, facet, is_template, value_index, short_value FROM " + this._table + " WHERE " + SHORT_VALUE_COLUMN + " = ?  AND " + VALUE_TYPE_COLUMN + " >= " + 5;
        }
        if (this._updateValueTypeCommandForSwizzle == null) {
            this._updateValueTypeCommandForSwizzle = "UPDATE " + this._table + " SET " + VALUE_TYPE_COLUMN + " = ? " + " WHERE " + FRAME_COLUMN + " = ? " + " AND " + SLOT_COLUMN + " = ? AND " + FACET_COLUMN + " = ? AND " + IS_TEMPLATE_COLUMN + " = ?" + " AND " + VALUE_INDEX_COLUMN + " = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._matchingFramesCommandForSwizzle);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, frame);
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                if (!frame.getName().equals(rs.getString(6))) continue;
                PreparedStatement exe = this.getCurrentConnection().getPreparedStatement(this._updateValueTypeCommandForSwizzle);
                exe.setInt(1, newTypeId);
                exe.setString(2, rs.getString(1));
                exe.setString(3, rs.getString(2));
                exe.setString(4, rs.getString(3));
                exe.setBoolean(5, rs.getBoolean(4));
                exe.setInt(6, rs.getInt(5));
                DefaultDatabaseFrameDb.executeUpdate(exe);
            }
        }
        finally {
            rs.close();
        }
    }

    @Override
    public int getClsCount() {
        return this.countUniqueFrames(this._frameFactory.getClsJavaClassIds());
    }

    @Override
    public int getSlotCount() {
        return this.countUniqueFrames(this._frameFactory.getSlotJavaClassIds());
    }

    @Override
    public int getFacetCount() {
        return this.countUniqueFrames(this._frameFactory.getFacetJavaClassIds());
    }

    @Override
    public int getFrameCount() {
        return this.countUniqueFrames();
    }

    public Set getFrames() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Calling get frames...");
        }
        Set frames = null;
        try {
            frames = this.getFramesSQL();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
        return frames;
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.countUniqueFrames(this._frameFactory.getSimpleInstanceJavaClassIds());
    }

    private int countUniqueFrames(Collection types) {
        int count = -1;
        try {
            count = this.countFramesSQL(types);
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countFramesSQL(Collection types) throws SQLException {
        StringBuffer command = new StringBuffer();
        command.append("SELECT COUNT(*) FROM " + this._table);
        command.append(" WHERE slot = '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.NAME));
        command.append("' AND facet = ''");
        command.append(" AND is_template = ?");
        command.append(" AND (");
        boolean isFirst = true;
        for (Integer intValue : types) {
            if (isFirst) {
                isFirst = false;
            } else {
                command.append(" OR ");
            }
            command.append("frame_type = ");
            command.append(intValue);
        }
        command.append(")");
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(command.toString());
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 1, false);
        int count = -1;
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        return count;
    }

    private int countUniqueFrames() {
        int count = -1;
        try {
            count = this.countFramesSQL();
        }
        catch (SQLException e) {
            throw this.createRuntimeException(e);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countFramesSQL() throws SQLException {
        if (this._countFramesText == null) {
            this._countFramesText = "SELECT COUNT(*) FROM " + this._table;
            this._countFramesText = this._countFramesText + " WHERE slot = '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.NAME) + "'";
            this._countFramesText = this._countFramesText + " AND facet = ''";
            this._countFramesText = this._countFramesText + " AND is_template = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._countFramesText);
        DefaultDatabaseFrameDb.setIsTemplate(stmt, 1, false);
        int count = -1;
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                count = rs.getInt(1);
            }
        }
        finally {
            rs.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFramesSQL() throws SQLException {
        if (this._getFramesText == null) {
            this._getFramesText = "SELECT DISTINCT frame, frame_type";
            this._getFramesText = this._getFramesText + " FROM " + this._table;
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._getFramesText);
        HashSet<Frame> frames = new HashSet<Frame>();
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                Frame frame = this.getFrame(rs, 1, 2);
                frames.add(frame);
            }
        }
        finally {
            rs.close();
        }
        return frames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID id) {
        Frame returnFrame;
        block7: {
            returnFrame = null;
            if (this._getFrameFromIdText == null) {
                this._getFrameFromIdText = "SELECT DISTINCT frame, frame_type FROM " + this._table + " WHERE " + FRAME_COLUMN + " = ?";
            }
            try {
                if (id == null) break block7;
                PreparedStatement getFrameStmt = this.getCurrentConnection().getPreparedStatement(this._getFrameFromIdText);
                DatabaseUtils.setFrameId(getFrameStmt, 1, id);
                ResultSet rs = DefaultDatabaseFrameDb.executeQuery(getFrameStmt);
                try {
                    while (rs.next()) {
                        returnFrame = this.getFrame(rs, 1, 2);
                    }
                }
                finally {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.createRuntimeException(e);
            }
        }
        return returnFrame;
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return null;
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        try {
            if (this._updateFrameFieldText == null) {
                this._updateFrameFieldText = "UPDATE " + this._table + " SET " + FRAME_COLUMN + " = ? WHERE ";
                this._updateFrameFieldText = this._updateFrameFieldText + FRAME_COLUMN + " = ?";
            }
            PreparedStatement updateFrameFieldStatement = this.getCurrentConnection().getPreparedStatement(this._updateFrameFieldText);
            DefaultDatabaseFrameDb.setFrame(updateFrameFieldStatement, 1, replacement);
            DefaultDatabaseFrameDb.setFrame(updateFrameFieldStatement, 2, original);
            DefaultDatabaseFrameDb.executeUpdate(updateFrameFieldStatement);
            if (replacement instanceof Slot) {
                if (this._updateSlotFieldText == null) {
                    this._updateSlotFieldText = "UPDATE " + this._table + " SET " + SLOT_COLUMN + " = ? WHERE ";
                    this._updateSlotFieldText = this._updateSlotFieldText + SLOT_COLUMN + " = ?";
                }
                PreparedStatement updateSlotFieldStatement = this.getCurrentConnection().getPreparedStatement(this._updateSlotFieldText);
                DefaultDatabaseFrameDb.setFrame(updateSlotFieldStatement, 1, replacement);
                DefaultDatabaseFrameDb.setFrame(updateSlotFieldStatement, 2, original);
                DefaultDatabaseFrameDb.executeUpdate(updateSlotFieldStatement);
            }
            if (replacement instanceof Facet) {
                if (this._updateFacetFieldText == null) {
                    this._updateFacetFieldText = "UPDATE " + this._table + " SET " + FACET_COLUMN + " = ? WHERE ";
                    this._updateFacetFieldText = this._updateFacetFieldText + FACET_COLUMN + " = ?";
                }
                PreparedStatement updateFacetFieldStatement = this.getCurrentConnection().getPreparedStatement(this._updateFacetFieldText);
                DefaultDatabaseFrameDb.setFrame(updateFacetFieldStatement, 1, replacement);
                DefaultDatabaseFrameDb.setFrame(updateFacetFieldStatement, 2, original);
                DefaultDatabaseFrameDb.executeUpdate(updateFacetFieldStatement);
            }
            this.replaceFrameShortValueField(original, replacement);
            if (this._replaceNameText == null) {
                this._replaceNameText = "UPDATE " + this._table + " SET " + SHORT_VALUE_COLUMN + " = ?," + VALUE_TYPE_COLUMN + " = ? WHERE ";
                this._replaceNameText = this._replaceNameText + FRAME_COLUMN + " = ? AND ";
                this._replaceNameText = this._replaceNameText + SLOT_COLUMN + " = '" + DefaultDatabaseFrameDb.getValue(Model.SlotID.NAME) + "'";
            }
            PreparedStatement replaceNameStatement = this.getCurrentConnection().getPreparedStatement(this._replaceNameText);
            this.setShortValue(replaceNameStatement, 1, 2, replacement.getFrameID().getName());
            DefaultDatabaseFrameDb.setFrame(replaceNameStatement, 3, replacement);
            DefaultDatabaseFrameDb.executeUpdate(replaceNameStatement);
            original.markDeleted(true);
        }
        catch (SQLException sqle) {
            this.createRuntimeException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceFrameShortValueField(Frame original, Frame replacement) throws SQLException {
        if (this._matchingFramesCommandForRename == null) {
            this._matchingFramesCommandForRename = "SELECT frame, slot, facet, is_template, value_index, short_value FROM " + this._table + " WHERE " + SHORT_VALUE_COLUMN + " = ?  AND " + VALUE_TYPE_COLUMN + " >= " + 5;
        }
        if (this._updateValueFieldTextForRename == null) {
            this._updateValueFieldTextForRename = "UPDATE " + this._table + " SET " + SHORT_VALUE_COLUMN + " = ? " + " WHERE " + FRAME_COLUMN + " = ? " + " AND " + SLOT_COLUMN + " = ? AND " + FACET_COLUMN + " = ? AND " + IS_TEMPLATE_COLUMN + " = ?" + " AND " + VALUE_INDEX_COLUMN + " = ?";
        }
        PreparedStatement stmt = this.getCurrentConnection().getPreparedStatement(this._matchingFramesCommandForRename);
        DefaultDatabaseFrameDb.setFrame(stmt, 1, original);
        ResultSet rs = DefaultDatabaseFrameDb.executeQuery(stmt);
        try {
            while (rs.next()) {
                if (!original.getName().equals(rs.getString(6))) continue;
                PreparedStatement exe = this.getCurrentConnection().getPreparedStatement(this._updateValueFieldTextForRename);
                DefaultDatabaseFrameDb.setFrame(exe, 1, replacement);
                exe.setString(2, rs.getString(1));
                exe.setString(3, rs.getString(2));
                exe.setString(4, rs.getString(3));
                exe.setBoolean(5, rs.getBoolean(4));
                exe.setInt(6, rs.getInt(5));
                DefaultDatabaseFrameDb.executeUpdate(exe);
            }
        }
        finally {
            rs.close();
        }
    }

    @Override
    public void reinitialize() {
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        return false;
    }

    public String toString() {
        return "DefaultDatabaseFrameDb(" + this.getName() + ")";
    }

    static {
        slotToFacetsCacheMap = new HashMap();
    }

    private class LapTimer {
        private final long start;
        private long lapStart;

        public LapTimer() {
            this.lapStart = this.start = System.currentTimeMillis();
        }

        public long lap() {
            long lapEnd = System.currentTimeMillis();
            long interval = lapEnd - this.lapStart;
            this.lapStart = lapEnd;
            return interval;
        }

        public long total() {
            return System.currentTimeMillis() - this.start;
        }
    }
}

