/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.CollectionUtilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class FrameHolder {
    private Map _frameIdToFrameMap = new HashMap();
    private FrameFactory _frameFactory;

    public FrameHolder(FrameFactory factory) {
        this._frameFactory = factory;
    }

    public Frame getFrame(FrameID id, Collection directTypes) {
        Frame frame = (Frame)this._frameIdToFrameMap.get(id);
        if (frame == null) {
            frame = this.createFrame(id, directTypes);
            this._frameIdToFrameMap.put(id, frame);
        }
        return frame;
    }

    private Frame createFrame(FrameID id, Collection directTypes) {
        Instance frame;
        Cls firstType = (Cls)CollectionUtilities.getFirstItem(directTypes);
        if (firstType == null || !firstType.isMetaCls()) {
            frame = this._frameFactory.createSimpleInstance(id, directTypes);
        } else if (firstType.isClsMetaCls()) {
            frame = this._frameFactory.createCls(id, directTypes);
        } else if (firstType.isSlotMetaCls()) {
            frame = this._frameFactory.createSlot(id, directTypes);
        } else if (firstType.isFacetMetaCls()) {
            frame = this._frameFactory.createFacet(id, directTypes);
        } else {
            throw new IllegalStateException("No metaclass found");
        }
        return frame;
    }
}

