/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.storage.database.AbstractDatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdleConnectionNarrowFrameStore
implements NarrowFrameStore {
    private static Logger logger = Log.getLogger(IdleConnectionNarrowFrameStore.class);
    private final NarrowFrameStore delegate;
    private final AbstractDatabaseFrameDb databaseNfs;

    public IdleConnectionNarrowFrameStore(ValueCachingNarrowFrameStore delegate) {
        this.delegate = delegate;
        this.databaseNfs = (AbstractDatabaseFrameDb)delegate.getFrameDb();
    }

    private void setIdle() {
        try {
            this.databaseNfs.getCurrentConnection().setIdle(true);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        try {
            this.delegate.addValues(frame, slot, facet, isTemplate, values);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginTransaction(String name) {
        try {
            boolean bl = this.delegate.beginTransaction(name);
            return bl;
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction() {
        try {
            boolean bl = this.delegate.commitTransaction();
            return bl;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFrame(Frame frame) {
        try {
            this.delegate.deleteFrame(frame);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(Query query, QueryCallback callback) {
        try {
            this.delegate.executeQuery(query, callback);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        try {
            Set set = this.delegate.getClosure(frame, slot, facet, isTemplate);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClsCount() {
        try {
            int n = this.delegate.getClsCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public NarrowFrameStore getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFacetCount() {
        try {
            int n = this.delegate.getFacetCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID id) {
        try {
            Frame frame = this.delegate.getFrame(id);
            return frame;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameCount() {
        try {
            int n = this.delegate.getFrameCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames() {
        try {
            Set<Frame> set = this.delegate.getFrames();
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        try {
            Set<Frame> set = this.delegate.getFrames(slot, facet, isTemplate, value);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        try {
            Set<Frame> set = this.delegate.getFramesWithAnyValue(slot, facet, isTemplate);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        try {
            Set<Frame> set = this.delegate.getMatchingFrames(slot, facet, isTemplate, value, maxMatches);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        try {
            Set<Reference> set = this.delegate.getMatchingReferences(value, maxMatches);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        try {
            String string = this.delegate.getName();
            return string;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getReferences(Object value) {
        try {
            Set<Reference> set = this.delegate.getReferences(value);
            return set;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSimpleInstanceCount() {
        try {
            int n = this.delegate.getSimpleInstanceCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSlotCount() {
        try {
            int n = this.delegate.getSlotCount();
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        try {
            TransactionMonitor transactionMonitor = this.delegate.getTransactionStatusMonitor();
            return transactionMonitor;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        try {
            List list = this.delegate.getValues(frame, slot, facet, isTemplate);
            return list;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        try {
            int n = this.delegate.getValuesCount(frame, slot, facet, isTemplate);
            return n;
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to) {
        try {
            this.delegate.moveValue(frame, slot, facet, isTemplate, from, to);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize() {
        try {
            this.delegate.reinitialize();
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        return this.delegate.setCaching(session, doCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        try {
            this.delegate.removeValue(frame, slot, facet, isTemplate, value);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFrame(Frame frame) {
        try {
            this.delegate.replaceFrame(frame);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        try {
            this.delegate.replaceFrame(original, replacement);
        }
        finally {
            this.setIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollbackTransaction() {
        try {
            boolean bl = this.delegate.rollbackTransaction();
            return bl;
        }
        finally {
            this.setIdle();
        }
    }

    @Override
    public void setName(String name) {
        this.delegate.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        try {
            this.delegate.setValues(frame, slot, facet, isTemplate, values);
        }
        finally {
            this.setIdle();
        }
    }
}

