/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class KnowledgeBaseUtils {
    public static void update(KnowledgeBase kb) {
        boolean enabled = kb.setCleanDispatchEnabled(false);
        DefaultKnowledgeBase goodKB = new DefaultKnowledgeBase();
        for (Frame frame : goodKB.getFrames()) {
            KnowledgeBaseUtils.updateFrame(frame, kb);
        }
        kb.setCleanDispatchEnabled(enabled);
    }

    private static void updateFrame(Frame goodFrame, KnowledgeBase kb) {
        KnowledgeBaseUtils.updateOwnSlots(goodFrame, kb);
        if (goodFrame instanceof Cls) {
            KnowledgeBaseUtils.updateTemplateSlots((Cls)goodFrame, kb);
        }
    }

    private static void updateOwnSlots(Frame goodFrame, KnowledgeBase kb) {
        for (Slot goodSlot : goodFrame.getOwnSlots()) {
            KnowledgeBaseUtils.updateOwnSlotValues(goodFrame, goodSlot, kb);
        }
    }

    private static void updateTemplateSlots(Cls goodCls, KnowledgeBase kb) {
        for (Slot goodSlot : goodCls.getTemplateSlots()) {
            KnowledgeBaseUtils.updateTemplateSlotValues(goodCls, goodSlot, kb);
            KnowledgeBaseUtils.updateTemplateFacets(goodCls, goodSlot, kb);
        }
    }

    private static List getNewValues(List goodValues, List currentValues, KnowledgeBase kb) {
        ArrayList<Frame> values = null;
        if (!((Object)goodValues).equals(currentValues)) {
            values = new ArrayList<Frame>();
            for (Object o : goodValues) {
                if (o instanceof Frame) {
                    Frame goodFrame = (Frame)o;
                    values.add(KnowledgeBaseUtils.getFrame(goodFrame, kb));
                    continue;
                }
                values.add((Frame)o);
            }
            ArrayList unusedCurrentValues = new ArrayList(currentValues);
            unusedCurrentValues.removeAll(values);
            values.addAll(KnowledgeBaseUtils.getCurrentUserFrames(unusedCurrentValues));
            if (KnowledgeBaseUtils.equalsSet(values, currentValues)) {
                values = null;
            }
        }
        return values;
    }

    private static boolean equalsSet(Collection c1, Collection c2) {
        return new HashSet(c1).equals(new HashSet(c2));
    }

    private static Collection getCurrentUserFrames(Collection values) {
        ArrayList<Frame> userFrames = new ArrayList<Frame>();
        for (Object o : values) {
            Frame frame;
            if (!(o instanceof Frame) || (frame = (Frame)o).isSystem()) continue;
            userFrames.add(frame);
        }
        return userFrames;
    }

    private static Frame getFrame(Frame goodFrame, KnowledgeBase kb) {
        Frame frame = kb.getFrame(goodFrame.getName());
        if (frame == null) {
            Cls goodType = ((Instance)goodFrame).getDirectType();
            if (goodType.equals(goodFrame)) {
                Cls instance = kb.createCls(goodFrame.getFrameID(), (Collection)Collections.EMPTY_LIST, Collections.EMPTY_LIST, false);
                instance.setDirectType(instance);
                frame = instance;
            } else {
                Cls type = (Cls)KnowledgeBaseUtils.getFrame(goodType, kb);
                frame = kb.createInstance(goodFrame.getFrameID(), type, false);
            }
            KnowledgeBaseUtils.trace("create frame: " + goodFrame);
        }
        return frame;
    }

    private static void updateTemplateSlotValues(Cls goodCls, Slot goodSlot, KnowledgeBase kb) {
        Slot slot;
        Cls cls;
        List currentValues;
        List goodValues = goodCls.getDirectTemplateSlotValues(goodSlot);
        List newValues = KnowledgeBaseUtils.getNewValues(goodValues, currentValues = (cls = (Cls)KnowledgeBaseUtils.getFrame(goodCls, kb)).getDirectTemplateSlotValues(slot = (Slot)KnowledgeBaseUtils.getFrame(goodSlot, kb)), kb);
        if (newValues != null) {
            cls.setTemplateSlotValues(slot, newValues);
            KnowledgeBaseUtils.trace("update template slot values: " + cls + ", " + slot + " to " + newValues);
        }
    }

    private static void updateTemplateFacets(Cls goodCls, Slot goodSlot, KnowledgeBase kb) {
        for (Facet goodFacet : goodCls.getTemplateFacets(goodSlot)) {
            KnowledgeBaseUtils.updateTemplateFacetValues(goodCls, goodSlot, goodFacet, kb);
        }
    }

    private static void updateTemplateFacetValues(Cls goodCls, Slot goodSlot, Facet goodFacet, KnowledgeBase kb) {
        Facet facet;
        Slot slot;
        Cls cls;
        List currentValues;
        List goodValues = goodCls.getDirectTemplateFacetValues(goodSlot, goodFacet);
        List newValues = KnowledgeBaseUtils.getNewValues(goodValues, currentValues = (cls = (Cls)KnowledgeBaseUtils.getFrame(goodCls, kb)).getDirectTemplateFacetValues(slot = (Slot)KnowledgeBaseUtils.getFrame(goodSlot, kb), facet = (Facet)KnowledgeBaseUtils.getFrame(goodFacet, kb)), kb);
        if (newValues != null) {
            cls.setTemplateFacetValues(slot, facet, newValues);
            KnowledgeBaseUtils.trace("update template facet values: " + cls + ", " + slot + ", " + facet + " to " + newValues);
        }
    }

    private static void updateOwnSlotValues(Frame goodFrame, Slot goodSlot, KnowledgeBase kb) {
        Slot slot;
        Frame frame;
        List currentValues;
        List goodValues = goodFrame.getDirectOwnSlotValues(goodSlot);
        List newValues = KnowledgeBaseUtils.getNewValues(goodValues, currentValues = (frame = KnowledgeBaseUtils.getFrame(goodFrame, kb)).getDirectOwnSlotValues(slot = (Slot)KnowledgeBaseUtils.getFrame(goodSlot, kb)), kb);
        if (newValues != null) {
            frame.setOwnSlotValues(slot, newValues);
            KnowledgeBaseUtils.trace("update own slot values: " + frame + ", " + slot + " to " + newValues);
        }
    }

    private static void trace(String s) {
    }
}

