/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.storage.database.KnownDatabase;
import edu.stanford.smi.protege.storage.database.pool.ConnectionPool;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RobustConnection {
    private static final transient Logger log = Log.getLogger(RobustConnection.class);
    public static final String OLD_PROPERTY_LONGVARCHAR_TYPE_NAME = "SimpleJdbcDatabaseManager.longvarcharname";
    public static final String PROPERTY_LONGVARCHAR_TYPE_NAME = "Database.typename.longvarchar";
    public static final String PROPERTY_FRAME_NAME_TYPE_NAME = "Database.typename.frame.name.type";
    public static final String PROPERTY_SHORT_VALUE_TYPE_NAME = "Database.typename.short.value.type";
    public static final String PROPERTY_VARCHAR_TYPE_SIZE = "Database.type.varchar.maxsize";
    public static final int DEFAULT_MAX_STRING_SIZE = 255;
    public static final String PROPERTY_INTEGER_TYPE_NAME = "Database.typename.integer";
    public static final String PROPERTY_SMALL_INTEGER_TYPE_NAME = "Database.typename.small_integer";
    public static final String PROPERTY_BIT_TYPE_NAME = "Database.typename.bit";
    private static int idCounter = 0;
    private int id = idCounter++;
    private Connection connection;
    private ConnectionPool pool;
    private boolean idleFlag = true;
    private KnownDatabase dbType;
    private boolean _supportsBatch;
    private char _escapeChar;
    private String _escapeClause;
    private boolean _supportsTransactions;
    private RemoteSession session;
    private TransactionMonitor transactionMonitor;
    private String driver;
    private String _driverLongvarcharTypeName;
    private String _driverTinyIntTypeName;
    private String _driverBitTypeName;
    private String _driverSmallIntTypeName;
    private String _driverIntegerTypeName;
    private String _driverVarcharTypeName;
    private String _driverVarBinaryTypeName;
    private String _driverCharTypeName;
    private Integer transactionIsolationLevel = null;

    public RobustConnection(String driver, String url, String username, String password, TransactionMonitor transactionMonitor, RemoteSession session) throws SQLException {
        this.driver = driver;
        this.pool = ConnectionPool.getConnectionPool(driver, url, username, password);
        this.transactionMonitor = transactionMonitor;
        this.session = session;
        this.initializeDatabaseType();
        this.initializeSupportsBatch();
        this.initializeSupportsEscapeSyntax();
        this.initializeDriverTypeNames();
        this.initializeSupportsTransactions();
    }

    private void initializeDatabaseType() throws SQLException {
        String productName = this.getDatabaseProductName();
        this.dbType = productName.equalsIgnoreCase("mysql") ? KnownDatabase.MYSQL : (productName.equalsIgnoreCase("PostgreSQL") ? KnownDatabase.POSTGRESQL : (productName.equalsIgnoreCase("Microsoft SQL Server") ? KnownDatabase.SQLSERVER : (productName.equalsIgnoreCase("oracle") ? KnownDatabase.ORACLE : (productName.equalsIgnoreCase("apache derby") ? KnownDatabase.DERBY : null))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean b) throws SQLException {
        try {
            this.getConnection().setAutoCommit(b);
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        try {
            this.getConnection().commit();
        }
        finally {
            this.setIdle(true);
        }
    }

    private void setupConnection() throws SQLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Opening connection for robust connection manager #" + this.id);
        }
        this.connection = this.pool.getConnection();
        TransactionIsolationLevel defaultLevel = ServerProperties.getDefaultTransactionIsolationLevel();
        if (defaultLevel != null) {
            this.connection.setTransactionIsolation(defaultLevel.getJdbcLevel());
        }
    }

    public void dispose() throws SQLException {
        if (this.connection != null) {
            this.pool.ungetConnection(this.connection);
        }
        this.pool.dereference();
    }

    public void closeStatements() throws SQLException {
        this.pool.closeStatements(this.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupportsBatch() throws SQLException {
        try {
            this._supportsBatch = this.getConnection().getMetaData().supportsBatchUpdates();
            if (!this._supportsBatch) {
                String s = "This JDBC driver does not support batch update.";
                s = s + " For much better performance try using a newer driver";
                Log.getLogger().warning(s);
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupportsTransactions() throws SQLException {
        try {
            this._supportsTransactions = this.getConnection().getMetaData().supportsTransactions();
            if (!this._supportsTransactions) {
                Log.getLogger().warning("This database does not support transactions");
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSupportsEscapeSyntax() throws SQLException {
        try {
            this._escapeChar = '\u0000';
            this._escapeClause = "";
            boolean escapeSupported = this.getConnection().getMetaData().supportsLikeEscapeClause();
            if (escapeSupported) {
                if (this.isMySql()) {
                    this._escapeChar = (char)92;
                } else {
                    this._escapeChar = (char)124;
                    this._escapeClause = "{ESCAPE '" + this._escapeChar + "'}";
                }
            } else {
                Log.getLogger().warning("This driver does not support SQL Escape processing.");
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    public char getEscapeCharacter() {
        return this._escapeChar;
    }

    public String getEscapeClause() {
        return this._escapeClause;
    }

    public boolean supportsBatch() {
        return this._supportsBatch;
    }

    public PreparedStatement getPreparedStatement(String text) throws SQLException {
        return this.pool.getPreparedStatement(this.getConnection(), text);
    }

    public Statement getStatement() throws SQLException {
        return this.pool.getStatement(this.getConnection());
    }

    public synchronized void checkConnection() throws SQLException {
        if (this.connection == null) {
            this.setupConnection();
        } else if (this.connection.isClosed()) {
            Log.getLogger().warning("Found closed connection, reinitializing...");
            this.pool.reportProblem(this.connection);
            this.connection = null;
        }
    }

    public KnownDatabase getKnownDatabaseType() {
        return this.dbType;
    }

    public boolean isOracle() throws SQLException {
        return this.dbType == KnownDatabase.ORACLE;
    }

    public boolean isSqlServer() throws SQLException {
        return this.dbType == KnownDatabase.SQLSERVER;
    }

    public boolean isMsAccess() throws SQLException {
        return this.getDatabaseProductName().equalsIgnoreCase("access");
    }

    public boolean isMySql() throws SQLException {
        return this.dbType == KnownDatabase.MYSQL;
    }

    public boolean isPostgres() throws SQLException {
        return this.dbType == KnownDatabase.POSTGRESQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseProductName() throws SQLException {
        try {
            String string = this.getConnection().getMetaData().getDatabaseProductName();
            return string;
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            int n = this.getConnection().getMetaData().getDatabaseMajorVersion();
            return n;
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            int n = this.getConnection().getMetaData().getDatabaseMinorVersion();
            return n;
        }
        finally {
            this.setIdle(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDriverTypeNames() throws SQLException {
        try {
            String longvarbinaryTypeName = null;
            String blobTypeName = null;
            String clobTypeName = null;
            DatabaseMetaData md = this.getConnection().getMetaData();
            if (log.isLoggable(Level.FINE)) {
                log.fine(" ----------------------- type information for " + md.getDatabaseProductName());
                log.fine("See http://java.sun.com/j2se/1.5.0/docs/api/java/sql/Types.html for a list of the sql types");
            }
            ResultSet rs = md.getTypeInfo();
            while (rs.next()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Info for type " + rs.getString("TYPE_NAME"));
                    log.fine("\tsql data type = " + rs.getInt("DATA_TYPE"));
                    short nullable = rs.getShort("NULLABLE");
                    log.fine("\tnullable = " + (nullable == 0 ? "false" : (nullable == 1 ? "true" : "maybe")));
                    log.fine("\tcase sensitive = " + rs.getBoolean("CASE_SENSITIVE"));
                }
                String name = rs.getString("TYPE_NAME");
                int type = rs.getInt("DATA_TYPE");
                if (name.length() == 0) continue;
                switch (type) {
                    case -1: {
                        if (this._driverLongvarcharTypeName != null) break;
                        this._driverLongvarcharTypeName = name;
                        break;
                    }
                    case -4: {
                        if (longvarbinaryTypeName != null) break;
                        longvarbinaryTypeName = name;
                        break;
                    }
                    case 2005: {
                        if (clobTypeName != null) break;
                        clobTypeName = name;
                        break;
                    }
                    case 2004: {
                        if (blobTypeName != null) break;
                        blobTypeName = name;
                        break;
                    }
                    case -6: {
                        if (this._driverTinyIntTypeName != null) break;
                        this._driverTinyIntTypeName = name;
                        break;
                    }
                    case -7: {
                        if (this._driverBitTypeName != null) break;
                        this._driverBitTypeName = name;
                        break;
                    }
                    case 5: {
                        if (this._driverSmallIntTypeName != null) break;
                        this._driverSmallIntTypeName = name;
                        break;
                    }
                    case 4: {
                        if (this._driverIntegerTypeName != null) break;
                        this._driverIntegerTypeName = name;
                        break;
                    }
                    case 12: {
                        if (this._driverVarcharTypeName != null) break;
                        this._driverVarcharTypeName = name;
                        break;
                    }
                    case -3: {
                        if (this._driverVarBinaryTypeName != null) break;
                        this._driverVarBinaryTypeName = name;
                        break;
                    }
                    case 1: {
                        if (this._driverCharTypeName != null) break;
                        this._driverCharTypeName = name;
                        break;
                    }
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(" ----------------------- end of type information for " + md.getDatabaseProductName());
            }
            rs.close();
            if (this._driverLongvarcharTypeName == null) {
                this._driverLongvarcharTypeName = longvarbinaryTypeName == null ? (clobTypeName == null ? blobTypeName : clobTypeName) : longvarbinaryTypeName;
                if (this._driverLongvarcharTypeName == null && this.isPostgres()) {
                    this._driverLongvarcharTypeName = "TEXT";
                }
            }
            if (this._driverIntegerTypeName == null) {
                this._driverIntegerTypeName = "INTEGER";
            }
            if (this._driverSmallIntTypeName == null) {
                this._driverSmallIntTypeName = this._driverIntegerTypeName;
            }
            if (this._driverTinyIntTypeName == null) {
                this._driverTinyIntTypeName = this._driverSmallIntTypeName;
            }
            if (this._driverBitTypeName == null) {
                this._driverBitTypeName = this._driverTinyIntTypeName;
            }
            if (this._driverVarcharTypeName == null || this.isPostgres() || this.isSqlServer()) {
                this._driverVarcharTypeName = "VARCHAR";
            }
            if (this._driverVarBinaryTypeName == null) {
                this._driverVarBinaryTypeName = "VARCHAR";
            }
            if (this.isOracle()) {
                this._driverLongvarcharTypeName = "CLOB";
            }
        }
        finally {
            this.setIdle(true);
        }
    }

    private String getName(String typeName, String driverName) {
        String userTypeName = ApplicationProperties.getApplicationOrSystemProperty(typeName + "." + this.driver);
        return userTypeName == null || userTypeName.length() == 0 ? driverName : userTypeName;
    }

    public String getBitTypeName() {
        String defaultValue = this.dbType != null ? this.dbType.getBitType() : this._driverBitTypeName;
        return this.getName(PROPERTY_BIT_TYPE_NAME, defaultValue);
    }

    public String getSmallIntTypeName() {
        String defaultValue = this.dbType != null ? this.dbType.getSmallIntType() : this._driverSmallIntTypeName;
        return this.getName(PROPERTY_SMALL_INTEGER_TYPE_NAME, defaultValue);
    }

    public String getIntegerTypeName() {
        String defaultValue = this.dbType != null ? this.dbType.getIntType() : this._driverIntegerTypeName;
        return this.getName(PROPERTY_INTEGER_TYPE_NAME, defaultValue);
    }

    public String getFrameNameType() {
        String defaultValue = this.dbType != null ? this.dbType.getFrameNameType() : this._driverVarcharTypeName;
        return this.getName(PROPERTY_FRAME_NAME_TYPE_NAME, defaultValue);
    }

    public String getShortValueType() {
        String defaultValue = this.dbType != null ? this.dbType.getShortValueType() : this._driverVarcharTypeName;
        return this.getName(PROPERTY_SHORT_VALUE_TYPE_NAME, defaultValue);
    }

    public int getMaxVarcharSize() {
        String propValue = ApplicationProperties.getApplicationOrSystemProperty("Database.type.varchar.maxsize." + this.driver);
        if (propValue != null) {
            try {
                return Integer.parseInt(propValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.dbType != null) {
            return this.dbType.getMaxShortValueSize();
        }
        return 255;
    }

    public String getLongvarcharTypeName() {
        String defaultValue;
        if (this.dbType != null) {
            defaultValue = this.dbType.getLongStringType();
        } else {
            defaultValue = SystemUtilities.getSystemProperty("SimpleJdbcDatabaseManager.longvarcharname." + this.driver);
            if (defaultValue == null || defaultValue.length() == 0) {
                defaultValue = this._driverLongvarcharTypeName;
            }
            if (defaultValue == null) {
                defaultValue = this.getShortValueType();
                Log.getLogger().warning("Using VARCHAR in place of LONGVARCHAR, long strings will be truncated.");
            }
        }
        return this.getName(PROPERTY_LONGVARCHAR_TYPE_NAME, defaultValue);
    }

    public boolean supportsCaseInsensitiveMatches() throws SQLException {
        return !this.isOracle() && !this.isPostgres();
    }

    public boolean supportsIndexOnFunction() throws SQLException {
        return this.isOracle() || this.isPostgres();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginTransaction() {
        if (!this.sessionOk()) {
            return false;
        }
        boolean begun = false;
        try {
            if (this._supportsTransactions) {
                if (this.transactionMonitor.getNesting() == 0) {
                    if (this.isMsAccess()) {
                        this.pool.closeStatements(this.getConnection());
                    }
                    this.getConnection().setAutoCommit(false);
                }
                this.transactionMonitor.beginTransaction();
            }
            begun = true;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Thead " + Thread.currentThread() + " locking connection " + this.pool.getId(this.getConnection()));
            }
        }
        catch (SQLException e) {
            Log.getLogger().warning(e.toString());
        }
        finally {
            this.setIdle(true);
        }
        return begun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction() {
        if (!this.sessionOk()) {
            return false;
        }
        boolean committed = false;
        try {
            if (this._supportsTransactions && this.transactionMonitor.getNesting() > 0) {
                this.transactionMonitor.commitTransaction();
                if (this.transactionMonitor.getNesting() == 0) {
                    this.getConnection().commit();
                    this.getConnection().setAutoCommit(true);
                }
            }
            committed = true;
        }
        catch (SQLException e) {
            Log.getLogger().warning(e.toString());
        }
        finally {
            this.setIdle(true);
        }
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollbackTransaction() {
        if (!this.sessionOk()) {
            return false;
        }
        boolean rolledBack = false;
        try {
            if (this._supportsTransactions && this.transactionMonitor.getNesting() > 0) {
                this.transactionMonitor.rollbackTransaction();
                if (this.transactionMonitor.getNesting() == 0) {
                    this.getConnection().rollback();
                    this.getConnection().setAutoCommit(true);
                }
            }
            rolledBack = true;
        }
        catch (SQLException e) {
            Log.getLogger().warning(e.toString());
        }
        finally {
            this.setIdle(true);
        }
        return rolledBack;
    }

    private boolean sessionOk() {
        if (ServerFrameStore.getCurrentSession() == null) {
            return this.session == null;
        }
        return ServerFrameStore.getCurrentSession().equals(this.session);
    }

    public boolean supportsTransactions() {
        return this._supportsTransactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolationLevel() throws SQLException {
        if (this.transactionIsolationLevel != null) {
            return this.transactionIsolationLevel;
        }
        try {
            this.transactionIsolationLevel = this.getConnection().getTransactionIsolation();
            int n = this.transactionIsolationLevel;
            return n;
        }
        finally {
            this.setIdle(true);
        }
    }

    public void setTransactionIsolationLevel(int level) throws SQLException {
        this.transactionIsolationLevel = null;
        try {
            this.getConnection().setTransactionIsolation(level);
        }
        catch (SQLException sqle) {
            Log.getLogger().log(Level.WARNING, "Problem setting the transaction isolation level", sqle);
            this.transactionIsolationLevel = null;
            throw sqle;
        }
        finally {
            this.setIdle(true);
        }
    }

    private synchronized Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.setupConnection();
        }
        this.setIdle(false);
        return this.connection;
    }

    public void setIdle(boolean idleFlag) {
        this.idleFlag = idleFlag;
        if (this.getIdle() && this.connection != null) {
            this.pool.ungetConnection(this.connection);
            this.connection = null;
        }
    }

    public boolean getIdle() {
        if (this._supportsTransactions && this.transactionMonitor != null && this.transactionMonitor.getNesting() > 0) {
            return false;
        }
        return this.idleFlag;
    }

    public static void main(String[] args) throws SQLException {
        RobustConnection connection = new RobustConnection(args[0], args[1], args[2], args[3], null, null);
        ResultSet rs = connection.connection.getMetaData().getTypeInfo();
        while (rs.next()) {
            System.out.println("TYPE_NAME: " + rs.getString(1));
            System.out.println("\tDATA_TYPE: " + rs.getInt(2));
            System.out.println("\tPRECISION: " + rs.getLong(3));
            System.out.println("\tLITERAL_PREFIX: " + rs.getString(4));
            System.out.println("\tLITERAL_SUFFIX: " + rs.getString(5));
            System.out.println("\tCREATE_PARAMS: " + rs.getString(6));
            System.out.println("\tNULLABLE: " + rs.getShort(7));
            System.out.println("\tCASE_SENSITIVE: " + rs.getBoolean(8));
            System.out.println("\tSEARCHABLE: " + rs.getShort(9));
            System.out.println("\tUNSIGNED_ATTRIBUTE: " + rs.getBoolean(10));
            System.out.println("\tFIXED_PREC_SCALE: " + rs.getBoolean(11));
            System.out.println("\tAUTO_INCREMENT: " + rs.getBoolean(12));
            System.out.println("\tLOCAL_TYPE_NAME: " + rs.getString(13));
            System.out.println("\tMINIMUM_SCALE: " + rs.getShort(14));
            System.out.println("\tMAXIMUM_SCALE: " + rs.getShort(15));
            System.out.println("\tSQL_DATA_TYPE: " + rs.getShort(16));
            System.out.println("\tSQL_DATETIME_SUB: " + rs.getShort(17));
            System.out.println("\tNUM_PREC_RADIX: " + rs.getInt(18));
        }
        rs.close();
    }
}

