/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.update.DeferredOperationCache;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheFactory;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.impl.CompleteableCache;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheBeginTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCommitTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRollbackTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueCachingNarrowFrameStore
implements NarrowFrameStore {
    public static final transient Logger CACHE_LOG = Logger.getLogger(CompleteableCache.class.getPackage().getName() + ".ValueCachingNFS");
    public static final Logger LOGGER = Log.getLogger(ValueCachingNarrowFrameStore.class);
    private DatabaseFrameDb framedb;
    private final WeakHashMap<String, SoftReference<DeferredOperationCache>> cacheMap = new WeakHashMap();
    private Sft directInstancesSft;
    private FifoWriter<SerializedCacheUpdate<RemoteSession, Sft, List>> transactions = new FifoWriter();
    private Set<RemoteSession> unCachingSessions;
    private long totalBuildTime = 0L;
    private long cacheBuilds = 0L;
    private long cacheLost = 0L;
    private long cacheHits = 0L;

    public ValueCachingNarrowFrameStore(DatabaseFrameDb delegate) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Constructing ValueCachingNarrowFrameStore with delegate " + delegate);
        }
        this.framedb = delegate;
    }

    @Override
    public boolean setCaching(RemoteSession session, boolean doCache) {
        boolean ret;
        if (this.unCachingSessions == null) {
            this.unCachingSessions = new HashSet<RemoteSession>();
        }
        boolean bl = ret = !this.unCachingSessions.contains(session);
        if (doCache) {
            this.unCachingSessions.remove(session);
        } else {
            this.unCachingSessions.add(session);
        }
        return ret;
    }

    private boolean cachingDisabledForSession() {
        return this.unCachingSessions != null && this.unCachingSessions.contains(ServerFrameStore.getCurrentSession());
    }

    public void setFrameDb(DatabaseFrameDb framedb) {
        this.framedb = framedb;
    }

    public DatabaseFrameDb getFrameDb() {
        return this.framedb;
    }

    @Override
    public DatabaseFrameDb getDelegate() {
        return this.framedb;
    }

    private DeferredOperationCache getCache(Frame frame, boolean create) {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        SoftReference<DeferredOperationCache> reference = this.cacheMap.get(frame.getFrameID().getName());
        DeferredOperationCache cache = null;
        if (reference != null) {
            cache = reference.get();
        }
        if (cache != null && cache.isInvalid()) {
            cache = null;
            this.cacheMap.remove(frame.getFrameID().getName());
        }
        if (reference != null && cache == null) {
            if (CACHE_LOG.isLoggable(Level.FINER)) {
                CACHE_LOG.finer("Cache for frame " + frame.getFrameID().getName() + " garbage collected");
            }
            ++this.cacheLost;
        }
        if (cache == null && create) {
            String frameName = frame.getFrameID().getName();
            Cache<RemoteSession, Sft, List> delegateCache = CacheFactory.createEmptyCache(this.getTransactionStatusMonitor().getTransationIsolationLevel());
            cache = new DeferredOperationCache(delegateCache, new FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>>(this.transactions));
            if (CACHE_LOG.isLoggable(Level.FINER)) {
                CACHE_LOG.finer("Created cache " + cache.getCacheId() + " for frame " + frame.getFrameID().getName());
            }
            this.cacheMap.put(frameName, new SoftReference<DeferredOperationCache>(cache));
            if (!this.cachingDisabledForSession()) {
                if (this.directInstancesSft == null && frame.getKnowledgeBase() != null) {
                    SystemFrames frames = frame.getKnowledgeBase().getSystemFrames();
                    Slot directInstancesSlot = frames.getDirectInstancesSlot();
                    this.directInstancesSft = new Sft(directInstancesSlot, null, false);
                }
                if (!this.getTransactionStatusMonitor().inTransaction() && this.directInstancesSft != null) {
                    long startTime = System.nanoTime();
                    Map<Sft, List> values = this.framedb.getFrameValues(frame);
                    cache.startCompleteCache();
                    cache.updateCache(session, this.directInstancesSft);
                    for (Map.Entry<Sft, List> entry : values.entrySet()) {
                        cache.updateCache(session, entry.getKey(), entry.getValue());
                    }
                    cache.finishCompleteCache();
                    this.totalBuildTime += System.nanoTime() - startTime;
                }
                ++this.cacheBuilds;
                this.logStats(Level.FINE);
                if (CACHE_LOG.isLoggable(Level.FINER)) {
                    CACHE_LOG.finer("Filled cache " + cache.getCacheId() + " for frame " + frame.getFrameID().getName());
                }
            }
        }
        return cache;
    }

    private void logStats(Level level) {
        if (CACHE_LOG.isLoggable(level) && this.cacheBuilds % 300L == 0L) {
            CACHE_LOG.log(level, "------------------- Database ValueCaching Stats");
            CACHE_LOG.log(level, "Caches built = " + this.cacheBuilds + " but only " + this.cacheMap.size() + " cache references still present.");
            CACHE_LOG.log(level, "Cache references found but were invalid at time of use = " + this.cacheLost);
            CACHE_LOG.log(level, "Ave time per build = " + (float)this.totalBuildTime / (float)(1000000L * this.cacheBuilds) + "ms.");
            CACHE_LOG.log(level, "Ave hits per build = " + this.cacheHits / this.cacheBuilds);
            CACHE_LOG.log(level, "------------------- Database ValueCaching Stats");
        }
    }

    private List getValues(CacheResult<List> result) {
        ArrayList values = result.getResult();
        if (values == null) {
            values = new ArrayList();
        }
        return values;
    }

    public String toString() {
        return "ValueCachingFrameStore(" + this.getName() + ")";
    }

    public void debugOutOfMemory() {
        ArrayList<Integer> junk = new ArrayList<Integer>();
        junk.add(8);
        try {
            while (true) {
                junk.addAll(junk);
            }
        }
        catch (OutOfMemoryError oops) {
            LOGGER.info("Out of memory achieved");
            return;
        }
    }

    @Override
    public void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this.getDelegate().addValues(frame, slot, facet, isTemplate, values);
        DeferredOperationCache cache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (cache != null) {
            Sft sft;
            RemoteSession session = ServerFrameStore.getCurrentSession();
            CacheResult<List> result = cache.readCache(session, sft = new Sft(slot, facet, isTemplate));
            if (result.isValid()) {
                ArrayList newValues = new ArrayList(this.getValues(result));
                newValues.addAll(values);
                cache.modifyCache(session, sft, newValues);
            } else {
                cache.modifyCache(session, sft);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginTransaction(String name) {
        try {
            boolean bl = this.getDelegate().beginTransaction(name);
            return bl;
        }
        finally {
            this.transactions.write(new CacheBeginTransaction(ServerFrameStore.getCurrentSession()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction() {
        try {
            boolean bl = this.getDelegate().commitTransaction();
            return bl;
        }
        finally {
            this.transactions.write(new CacheCommitTransaction(ServerFrameStore.getCurrentSession()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rollbackTransaction() {
        try {
            boolean bl = this.getDelegate().rollbackTransaction();
            return bl;
        }
        finally {
            this.transactions.write(new CacheRollbackTransaction(ServerFrameStore.getCurrentSession()));
        }
    }

    @Override
    public void close() {
        this.framedb.close();
        this.framedb = null;
        this.cacheMap.clear();
        this.directInstancesSft = null;
        this.transactions = null;
    }

    @Override
    public void deleteFrame(Frame frame) {
        this.removeFrameReferences(frame);
        this.getDelegate().deleteFrame(frame);
    }

    private void removeFrameReferences(Frame frame) {
        if (frame instanceof Slot || frame instanceof Facet) {
            this.cacheMap.clear();
        } else {
            RemoteSession session = ServerFrameStore.getCurrentSession();
            DeferredOperationCache cache = this.getCache(frame, false);
            if (cache != null) {
                cache.invalidate(session);
            }
            for (Reference reference : this.framedb.getReferences(frame)) {
                cache = this.getCache(reference.getFrame(), false);
                if (cache == null) continue;
                cache.invalidate(session);
            }
        }
    }

    @Override
    public void executeQuery(Query query, QueryCallback callback) {
        this.getDelegate().executeQuery(query, callback);
    }

    @Override
    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.getDelegate().getClosure(frame, slot, facet, isTemplate);
    }

    @Override
    public int getClsCount() {
        return this.getDelegate().getClsCount();
    }

    @Override
    public int getFacetCount() {
        return this.getDelegate().getFacetCount();
    }

    @Override
    public Frame getFrame(FrameID id) {
        return this.getDelegate().getFrame(id);
    }

    @Override
    public int getFrameCount() {
        return this.getDelegate().getFrameCount();
    }

    @Override
    public Set<Frame> getFrames() {
        return this.getDelegate().getFrames();
    }

    @Override
    public Set<Frame> getFrames(Slot slot, Facet facet, boolean isTemplate, Object value) {
        return this.getDelegate().getFrames(slot, facet, isTemplate, value);
    }

    @Override
    public Set<Frame> getFramesWithAnyValue(Slot slot, Facet facet, boolean isTemplate) {
        return this.getDelegate().getFramesWithAnyValue(slot, facet, isTemplate);
    }

    @Override
    public Set<Frame> getMatchingFrames(Slot slot, Facet facet, boolean isTemplate, String value, int maxMatches) {
        return this.getDelegate().getMatchingFrames(slot, facet, isTemplate, value, maxMatches);
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        return this.getDelegate().getMatchingReferences(value, maxMatches);
    }

    @Override
    public String getName() {
        return this.getDelegate().getName();
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        return this.getDelegate().getReferences(value);
    }

    @Override
    public int getSimpleInstanceCount() {
        return this.getDelegate().getSimpleInstanceCount();
    }

    @Override
    public int getSlotCount() {
        return this.getDelegate().getSlotCount();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this.getDelegate().getTransactionStatusMonitor();
    }

    @Override
    public List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        Sft sft;
        RemoteSession session;
        DeferredOperationCache cache = this.getCache(frame, true);
        CacheResult<List> result = cache.readCache(session = ServerFrameStore.getCurrentSession(), sft = new Sft(slot, facet, isTemplate));
        if (result.isValid()) {
            ++this.cacheHits;
            return new ArrayList(this.getValues(result));
        }
        List values = this.getDelegate().getValues(frame, slot, facet, isTemplate);
        cache.updateCache(session, sft, values);
        return values;
    }

    @Override
    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        Sft sft;
        RemoteSession session;
        DeferredOperationCache cache = this.getCache(frame, true);
        CacheResult<List> result = cache.readCache(session = ServerFrameStore.getCurrentSession(), sft = new Sft(slot, facet, isTemplate));
        if (result.isValid()) {
            ++this.cacheHits;
            return this.getValues(result).size();
        }
        return this.getDelegate().getValuesCount(frame, slot, facet, isTemplate);
    }

    @Override
    public void moveValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, int from, int to) {
        DeferredOperationCache cache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (cache != null) {
            RemoteSession session = ServerFrameStore.getCurrentSession();
            Sft sft = new Sft(slot, facet, isTemplate);
            cache.modifyCache(session, sft);
        }
        this.getDelegate().moveValue(frame, slot, facet, isTemplate, from, to);
    }

    @Override
    public void reinitialize() {
        this.cacheMap.clear();
    }

    @Override
    public void removeValue(Frame frame, Slot slot, Facet facet, boolean isTemplate, Object value) {
        DeferredOperationCache cache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (cache != null) {
            Sft sft;
            RemoteSession session = ServerFrameStore.getCurrentSession();
            CacheResult<List> result = cache.readCache(session, sft = new Sft(slot, facet, isTemplate));
            if (result.isValid()) {
                ArrayList oldValues = new ArrayList(this.getValues(result));
                oldValues.remove(value);
                cache.modifyCache(session, sft, oldValues);
            } else {
                cache.modifyCache(session, sft);
            }
        }
        this.getDelegate().removeValue(frame, slot, facet, isTemplate, value);
    }

    @Override
    public void replaceFrame(Frame frame) {
        this.getDelegate().replaceFrame(frame);
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        this.removeFrameReferences(original);
        DeferredOperationCache replacementCache = this.getCache(replacement, false);
        if (replacementCache != null) {
            RemoteSession session = ServerFrameStore.getCurrentSession();
            replacementCache.invalidate(session);
        }
        this.getDelegate().replaceFrame(original, replacement);
    }

    @Override
    public void setName(String name) {
        this.getDelegate().setName(name);
    }

    @Override
    public void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        DeferredOperationCache cache = this.getCache(frame, this.getTransactionStatusMonitor().inTransaction());
        if (cache != null) {
            RemoteSession session = ServerFrameStore.getCurrentSession();
            Sft sft = new Sft(slot, facet, isTemplate);
            cache.modifyCache(session, sft, new ArrayList(values));
        }
        this.getDelegate().setValues(frame, slot, facet, isTemplate, values);
    }
}

