/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database.pool;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class ConnectionInfo {
    private static int nextId = 0;
    private int id = nextId++;
    private Connection connection;
    private Map<String, PreparedStatement> preparedStatementMap = new HashMap<String, PreparedStatement>();
    private Statement genericStatement;
    private long lastAccessTime;
    private boolean InformedUserOfLongConnectionTime = false;
    private Exception connectionCallStack;

    public ConnectionInfo(Connection connection) {
        this.connection = connection;
    }

    public int getId() {
        return this.id;
    }

    public void touch() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public boolean getInformedUserOfLongConnectionTime() {
        return this.InformedUserOfLongConnectionTime;
    }

    public void setInformedUserOfLongConnectionTime(boolean informedUserOfLongConnectionTime) {
        this.InformedUserOfLongConnectionTime = informedUserOfLongConnectionTime;
    }

    public Exception getConnectionCallStack() {
        return this.connectionCallStack;
    }

    public void setConnectionCallStack(Exception connectionCallStack) {
        this.connectionCallStack = connectionCallStack;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public PreparedStatement getPreparedStatement(String text) throws SQLException {
        PreparedStatement stmt = this.preparedStatementMap.get(text);
        if (stmt == null) {
            stmt = this.connection.prepareStatement(text);
            this.preparedStatementMap.put(text, stmt);
        }
        return stmt;
    }

    public synchronized Statement getStatement() throws SQLException {
        if (this.genericStatement == null) {
            this.genericStatement = this.connection.createStatement();
        }
        return this.genericStatement;
    }

    public void close() throws SQLException {
        this.closeStatements();
        this.connection.close();
    }

    public synchronized void closeStatements() throws SQLException {
        for (PreparedStatement stmt : this.preparedStatementMap.values()) {
            stmt.close();
        }
        this.preparedStatementMap.clear();
        if (this.genericStatement != null) {
            this.genericStatement.close();
            this.genericStatement = null;
        }
    }
}

